//$Id: app-res.h,v 1.6 2001/09/16 13:06:06 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_APP_RES_H
#define GUIKACHU_APP_RES_H

namespace Guikachu
{
    namespace Resources
    {
	class Application;
    }
}

#include <gnome-xml/tree.h>
#include <iostream>
#include <sigc++/basic_signal.h>
#include <string>

#include "app-win.h"
#include "resource.h"

namespace Guikachu
{
    namespace Resources
    {
	class Application: public SigC::Object
	{
	    GUI::AppWindow *gui;

	public:
	    Application ();
	    ~Application ();
	    SigC::Signal0<void> changed;

	    void show_ui ();

	    Property<string> iconname;
	    Property<string> version;
	    Property<string> vendor;
	    
	    void reset ();
	    
	private:
	    bool load (StorageNode &node);
	    void save (StorageNode &node) const;
	    void save_rcp (ostream &ostr) const;
	    friend ostream& operator<< (ostream &ostr, const Application *res);

	    friend class ResourceManager;
	};

	ostream& operator<< (ostream &ostr, const Application* res);
    };
};

#endif /* !GUIKACHU_APP_RES_H */
