<?xml version="1.0"?> <!-- -*- xml -*- -->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <!-- Position and size -->
  <xsl:template match="form/widgets/*/pos">
    <xsl:text> AT (</xsl:text>
    
    <!-- Position -->
    <xsl:value-of select="@x"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@y"/>
    
    <!-- Size -->
    <xsl:if test="@width">
      <xsl:text> </xsl:text>
      <xsl:value-of select="@width"/>
    </xsl:if>
    <xsl:if test="@height">
      <xsl:text> </xsl:text>
      <xsl:value-of select="@height"/>
    </xsl:if>
    <xsl:text>)</xsl:text>  
  </xsl:template>

  <xsl:template match="form/widgets/*/text">
    <xsl:text>"</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>"</xsl:text>
  </xsl:template>

  <xsl:include href="button.xsl"/>
  <xsl:include href="label.xsl"/>
  <xsl:include href="graffiti.xsl"/>
  <xsl:include href="checkbox.xsl"/>
  <xsl:include href="pushbutton.xsl"/>
  <xsl:include href="popup-trigger.xsl"/>
  <xsl:include href="selector-trigger.xsl"/>
  <xsl:include href="list.xsl"/>
  <xsl:include href="scrollbar.xsl"/>
  <xsl:include href="text-field.xsl"/>
  <xsl:include href="table.xsl"/>
  
</xsl:stylesheet>
