//$Id: string-list.cc,v 1.5 2001/10/09 16:37:13 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "string-list.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <gtk--/scrolledwindow.h>
#include <gtk--/buttonbox.h>
#include <gnome--/stock.h>

using namespace Guikachu::GUI;

StringList::StringList (Property<value_t> &property_):
    Gtk::HBox (false, 5),
    property (property_),	 
    update_block (false)
{
    using namespace SigC;

    /* Left pane: list of strings and an entry to edit the current
     * item */
    Gtk::VBox *vbox = new Gtk::VBox (false, 5);
    add (*manage (vbox));
    
    /* The List holding the strings */
    list_widget = new Gtk::List;
    list_widget->set_selection_mode (GTK_SELECTION_BROWSE);
    list_widget->selection_changed.connect (slot (this, &StringList::selection_cb));
    
    Gtk::ScrolledWindow *scrollwin = new Gtk::ScrolledWindow;
    scrollwin->add_with_viewport (*manage (list_widget));
    scrollwin->set_policy (GTK_POLICY_AUTOMATIC,
			   GTK_POLICY_AUTOMATIC);
    
    scrollwin->show_all ();
    vbox->add (*manage (scrollwin));

    /* The Entry for editing items */
    entry = new Gtk::Entry;
    entry->activate.connect (slot (this, &StringList::entry_activate_cb));
    
    vbox->pack_start (*manage (entry), false, false);
    
    /* The modifier buttons */
    btnAdd  = Gtk::wrap (GTK_BUTTON (
	gnome_pixmap_button (
	    GTK_WIDGET (manage(new Gnome::Stock::Pixmap (GNOME_STOCK_PIXMAP_ADD))->gtkobj ()),
	    _("Add"))));
    btnAdd->clicked.connect (slot (this, &StringList::button_add_cb));

    btnRemove  = Gtk::wrap (GTK_BUTTON (
	gnome_pixmap_button (
	    GTK_WIDGET (manage(new Gnome::Stock::Pixmap (GNOME_STOCK_PIXMAP_REMOVE))->gtkobj ()),
	    _("Remove"))));
    btnRemove->clicked.connect (slot (this, &StringList::button_remove_cb));
	
    btnUp   = new Gnome::Stock::Button (GNOME_STOCK_BUTTON_UP);
    btnUp->clicked.connect (slot (this, &StringList::button_up_cb));
	
    btnDown = new Gnome::Stock::Button (GNOME_STOCK_BUTTON_DOWN);
    btnDown->clicked.connect (slot (this, &StringList::button_down_cb));
    
    Gtk::VButtonBox *buttons = new Gtk::VButtonBox;
    buttons->add (*manage (btnUp));
    buttons->add (*manage (btnDown));
    buttons->add (*manage (btnRemove));
    buttons->add (*manage (btnAdd));
    buttons->show_all ();
    add (*manage (buttons));
    
    property.changed.connect (slot (this, &StringList::update));
    update ();
    selection_cb ();
}

void StringList::update ()
{
    update_block = true;

    list_widget->items ().clear ();
    
    const value_t &curr_val = property;
    unsigned int index = 0;
    for (value_t::const_iterator i = curr_val.begin ();
	 i != curr_val.end (); i++, index++)
    {
	Gtk::ListItem *item = new Gtk::ListItem (*i);
	item->show ();
	item->set_user_data (GUINT_TO_POINTER (index));
	
	list_widget->items ().push_back (*manage (item));
    }
    
    update_block = false;
}

void StringList::selection_cb ()
{
    Gtk::List::SelectionList sel_list = list_widget->selection ();
	
    if (!sel_list.size ())
    {
	
	btnRemove->set_sensitive (false);
	btnUp->set_sensitive (false);
	btnDown->set_sensitive (false);

	entry->set_text ("");
	
    } else {
	
	g_return_if_fail (sel_list.size() == 1);

	unsigned int index = GPOINTER_TO_UINT ((*(sel_list.begin()))->get_user_data ());

	btnRemove->set_sensitive (true);
	btnUp->set_sensitive ((index > 0));
	btnDown->set_sensitive ((index < (property ().size () - 1)));

	entry->set_text (property ()[index]);
    }
}

void StringList::button_remove_cb ()
{
    g_return_if_fail (list_widget->selection ().size () == 1);

    Gtk::List::SelectionList::iterator sel = list_widget->selection ().begin ();  
    unsigned int index = GPOINTER_TO_UINT ((*sel)->get_user_data ());

    value_t val = property;
    val.erase (val.begin () + index);
    property = val;

    list_widget->select_item (index);
}

void StringList::button_up_cb ()
{
    Gtk::List::SelectionList sel_list = list_widget->selection ();
    g_return_if_fail (sel_list.size () == 1);

    unsigned int index = GPOINTER_TO_UINT ((*(sel_list.begin ()))->get_user_data ());
    g_return_if_fail (index != 0);

    value_t val = property;
    value_t::iterator curr = val.begin () + index;
    value_t::iterator prev = curr - 1;
    iter_swap (curr, prev);
    property = val;

    list_widget->select_item (index - 1);
}

void StringList::button_down_cb ()
{
    Gtk::List::SelectionList sel_list = list_widget->selection ();
    g_return_if_fail (sel_list.size () == 1);

    unsigned int index = GPOINTER_TO_UINT ((*(sel_list.begin ()))->get_user_data ());
    g_return_if_fail (index < list_widget->items ().size () - 1);

    value_t val = property;
    value_t::iterator curr = val.begin () + index;
    value_t::iterator next = curr + 1;
    iter_swap (curr, next);
    property = val;

    list_widget->select_item (index + 1);
}

void StringList::button_add_cb ()
{
    int index = 0;
    
    if (list_widget->selection ().size ())
	index = GPOINTER_TO_UINT ((*(list_widget->selection ().begin ()))->get_user_data ());
    
    value_t curr_val = property;
    curr_val.push_back (entry->get_text ());
    property = curr_val;

    if (index)
	list_widget->select_item (index);
}

void StringList::entry_activate_cb ()
{
    if (!list_widget->selection ().size ())
    {
	button_add_cb ();
	return;
    }
    
    string new_text = entry->get_text ();
    unsigned int index = GPOINTER_TO_UINT ((*(list_widget->selection ().begin ()))->get_user_data ());
    value_t val = property;

    val[index] = new_text;
    property = val;

    list_widget->select_item (index);
}
