//$Id: resource-combo.cc,v 1.2 2001/08/18 14:23:02 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "resource-combo.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <vector>
#include "resource-manager.h"

using namespace Guikachu;

GUI::ResourceCombo::ResourceCombo (Resources::Type   type_,
				   Property<string> &property_):
    Gtk::HBox (false, 5),
    button_edit (_("Edit...")),
    type (type_),
    current (""),
    property (property_)
{
    combo.set_value_in_list (true, true);
    combo.set_use_arrows (true);
    combo.set_case_sensitive (false);
    combo.get_entry ()->set_editable (false);
    
    set<Resources::Resource*> resource_set = ResourceManager::get_resources ();

    Gtk::ListItem *item = new Gtk::ListItem ("");
    item->set_user_data (0);
    item->show ();
    combo.get_list ()->add (*manage (item));
    for (set<Resources::Resource*>::iterator i = resource_set.begin ();
	 i != resource_set.end (); i++)
	add_resource ((*i));

    button_edit.clicked.connect (slot (this, &ResourceCombo::edit_cb));
    
    ResourceManager::resource_created.connect (slot (this, &ResourceCombo::add_resource));
    ResourceManager::resource_removed.connect (slot (this, &ResourceCombo::remove_resource));
    combo.get_entry ()->changed.connect (slot (this, &ResourceCombo::entry_cb));
    
    pack_start (combo);
    pack_start (button_edit);
    
    property.changed.connect (slot (this, &ResourceCombo::update));
    update ();
}

void GUI::ResourceCombo::add_resource (Resources::Resource *res)
{
    if (res->get_type () != type)
	return;

    update_block = true;

    Gtk::ListItem *item = new Gtk::ListItem (res->id);
    item->set_user_data (res);
    item->show ();
    combo.get_list ()->add (*manage (item));

    if (res->id == current)
	current_res = res;
    combo.get_entry ()->set_text (current);

    res->changed.connect (bind (slot (this, &ResourceCombo::resource_changed_cb),
				res));
	
    update_block = false;
}

void GUI::ResourceCombo::remove_resource (Resources::Resource *res)
{
    if (res->get_type () != type)
	return;
	
    update_block = true;

    Gtk::List::ItemList listitems = combo.get_list ()->items ();
    for (Gtk::List::ItemList::iterator i = listitems.begin ();
	 i != listitems.end (); i++)
    {
	if ((*i)->get_user_data () == res)
	    i = listitems.erase (i);
    }

    update_block = false;

    if (res->id == current)
	property = "";
}

void GUI::ResourceCombo::update ()
{
    update_block = true;

    current = property;
    current_res = ResourceManager::get_resource (current);
    
    combo.get_entry ()->set_text (current);

    update_block = false;
}

void GUI::ResourceCombo::edit_cb ()
{
    Resources::Resource *res = ResourceManager::get_resource (current);
    g_return_if_fail (res != 0);
    
    res->show_ui ();
}

void GUI::ResourceCombo::entry_cb ()
{
    if (!update_block)
	property = combo.get_entry ()->get_text ();
    
    if (current != "")
	button_edit.set_sensitive (true);
    else
	button_edit.set_sensitive (false);
}

void GUI::ResourceCombo::resource_changed_cb (Resources::Resource *res)
{
    if (res == current_res)
	combo.get_entry ()->set_text (res->id);
    
    update_block = true;

    using namespace Gtk::List_Helpers;

    ItemList& itemlist = combo.get_list ()->items ();
    ItemList::iterator i = itemlist.begin ();
    while (i != itemlist.end () && (*i)->get_user_data () != res)
	i++;
    g_return_if_fail (i != itemlist.end ());
    
    (*i)->remove ();
    (*i)->add_label (res->id);
    
    update_block = false;
}

