//$Id: property.cc,v 1.2 2001/10/10 16:17:45 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "property.h"

#include "resource-manager.h"

using namespace Guikachu;

ID::ID (notify_signal_t &notify_signal,
	const string    &value):
    Property<string> (notify_signal, value)
{
}

void ID::set_val (const string& value_)
{
    string real_id = value_;

    for (string::iterator i = real_id.begin ();
	 i != real_id.end (); i++)
    {
	if (*i == ' ')
	    *i = '_';
    }

    cerr << "renaming to " << real_id << endl;
    
    if (ResourceManager::rename_resource (value, real_id))
	Property<string>::set_val (real_id);
}
