//$Id: form-win.cc,v 1.29 2001/09/19 20:30:53 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "form-win.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "form-editor/palette.h"

#include <gtk--/treeitem.h>
#include <gtk--/table.h>
#include <gtk--/button.h>
#include <gtk--/pixmap.h>
#include <gtk--/menu.h>

#include <gdk--/cursor.h>

#include <gnome--/canvas-group.h>
#include <gnome--/canvas-polygon.h>

#include "form-win-helpers.h"
#include "form-editor/form-editor.h"

using namespace Guikachu::GUI;
using namespace Guikachu::Resources;

// Static members of FormWindow
static Guikachu::GUI::Palette *palette = 0;


FormWindow::FormWindow (Form *res_):
    res (res_),
    edited_widget (0),
    selected_widget (0),
    canvas_overlay (0),
    selected_widget_type (Widgets::WIDGET_NONE)
{
    gui = glade_xml_new (GLADEDIR "/guikachu.glade", 0);

    using namespace Gtk;
    using namespace SigC;
    
    window = wrap (GTK_WINDOW (glade_xml_get_widget (gui, "res_form")));
    window->delete_event.connect (slot (this, &FormWindow::delete_event_impl));

    property_window = new Gtk::Window (GTK_WINDOW_DIALOG);
    property_window->set_title (_("Widget properties"));
    property_window->delete_event.connect (slot (this, &FormWindow::property_delete_event_impl));
    property_window->set_policy (false, true, true);
    
    canvas = wrap (GNOME_CANVAS (glade_xml_get_widget (gui, "form_canvas")));
    Gtk::Tree *tree = wrap (GTK_TREE (glade_xml_get_widget (gui, "form_tree")));
    tree->map_ (); // FIXME: Is this evil?
    
    FormWindow_Helpers::TopTreeItem *item = new FormWindow_Helpers::TopTreeItem (res);
    item->show ();
    item->activate.connect (slot (this, &FormWindow::form_clicked_cb));
    tree->add (*manage (item));
    top_treeitem = item;
    
    form = new FormEditor::Form (res, this);
    form->clicked.connect (slot (this, &FormWindow::form_clicked_cb));
    
    // Initial widget tree
    const set<Widgets::Widget*>& widgets = res->get_widgets ();
    for (set<Widgets::Widget*>::const_iterator i = widgets.begin ();
	 i != widgets.end (); i++)
	widget_created_cb (*i);

    
    res->changed.connect (slot (this, &FormWindow::update));
    res->widget_created.connect (slot (this, &FormWindow::widget_created_cb));
    res->widget_removed.connect (slot (this, &FormWindow::widget_removed_cb));
    update ();
    
    if (!palette)
	palette = new Guikachu::GUI::Palette ();
    palette->palette_changed.connect (slot (this, &FormWindow::palette_cb));

}

FormWindow::~FormWindow ()
{
//    window->destroy ();
    gtk_widget_destroy (GTK_WIDGET (window->gtkobj ()));
    gtk_object_unref (GTK_OBJECT (gui));

    delete form;
    delete property_window;
}

void FormWindow::show ()
{
    window->show_all ();
    window->get_window ().raise ();
    palette->show_all ();
    palette->get_window ().raise ();
    
    if (edited_widget)
	show_property_editor (edited_widget);
    else
	show_form_property_editor ();
}

int FormWindow::delete_event_impl (GdkEventAny *e)
{
    window->hide ();
    property_window->hide ();
    return true;
}

int FormWindow::property_delete_event_impl (GdkEventAny *e)
{
    property_window->hide ();
    return true;
}

void FormWindow::update ()
{
    gchar *title_buf = g_strdup_printf (_("Form: %s"), res->id ().c_str ());
    window->set_title (title_buf);
    g_free (title_buf);

    if (!edited_widget)
    {
	gchar *prop_buf = g_strdup_printf (_("Properties: %s"), res->id ().c_str ());
	property_window->set_title (prop_buf);
	g_free (prop_buf);
    }

}

void FormWindow::edited_widget_changed ()
{
    g_return_if_fail (edited_widget != 0);

    gchar *buffer = g_strdup_printf (_("Properties: %s"), edited_widget->id ().c_str ());
    property_window->set_title (buffer);
    g_free (buffer);
}

void FormWindow::widget_created_cb (Widgets::Widget *widget)
{
    g_return_if_fail (widget != 0);

    using namespace SigC;
    
    widget->request_edit.connect (bind (
	slot (this, &FormWindow::show_property_editor),
	widget));
    
    // Add tree item
    Gtk::Tree *tree = top_treeitem->get_subtree ();
    if (!tree)
    {
	tree = new Gtk::Tree ();
	top_treeitem->set_subtree (*manage (tree));
	top_treeitem->expand ();
    }

    // Add canvas item
    FormEditor::CanvasItem *canvas_item = widget->get_canvas_item (form);
    canvas_item->clicked.connect (bind (slot (this, &FormWindow::widget_clicked_cb), widget));
    
    FormWindow_Helpers::WidgetTreeItem *item = new FormWindow_Helpers::WidgetTreeItem (widget);
    item->show ();
    // FIXME: clearly the selection stuff needs clearer
    // model/view/controller separation
    item->activate.connect (bind (slot (this, &FormWindow::widget_clicked_cb), widget));
    
    tree->add (*item);
}

void FormWindow::widget_removed_cb (Widgets::Widget *widget)
{
    if (widget == selected_widget)
	selected_widget = 0;
    
    if (widget == edited_widget)
	form_clicked_cb ();
    
    // Remove tree item
    Gtk::Tree::ItemList &itemlist = top_treeitem->get_subtree ()->tree ();
    Gtk::Tree::ItemList::iterator i = itemlist.begin ();
    
    while (i != itemlist.end () && (*i)->get_user_data () != widget)
	i++;

    g_return_if_fail (i != itemlist.end ());

    itemlist.erase (i);
}

int FormWindow::canvas_overlay_cb (GdkEvent *event)
{
    if (event->type != GDK_BUTTON_PRESS)
	return false;

    if (event->button.button != 1)
	return false;
    
    add_widget (event->button.x - res->x,
		event->button.y - res->y);
    
    palette->palette_applied ();

    return true;
}

void FormWindow::palette_cb (Widgets::Type type)
{
    if (type == selected_widget_type)
	return;

    selected_widget_type = type;
    delete canvas_overlay;
    canvas_overlay = 0;
    
    // Change pointer
    Gdk_Window window = canvas->get_window ();
    if (type == Widgets::WIDGET_NONE)
    {
	Gdk_Cursor cursor (0);
	window.set_cursor (cursor);
	return;

    } else {
	
	Gdk_Cursor cursor (GDK_CROSSHAIR);
	window.set_cursor (cursor);
    }
    
			   
    // Create overlay canvas item
    Gnome::CanvasPoints   points;

    int x = res->x;
    int y = res->y;
    
    points.push_back (Gnome::Art::Point (x, y));
    points.push_back (Gnome::Art::Point (GUIKACHU_SCREEN_WIDTH + x, y));
    points.push_back (Gnome::Art::Point (GUIKACHU_SCREEN_WIDTH + x, GUIKACHU_SCREEN_HEIGHT + y));
    points.push_back (Gnome::Art::Point (x, GUIKACHU_SCREEN_HEIGHT + y));
    points.push_back (Gnome::Art::Point (x, y));
    
    canvas_overlay = new Gnome::CanvasPolygon (*canvas->root (), points);
    canvas_overlay->event.connect (slot (this, &FormWindow::canvas_overlay_cb));
    canvas_overlay->raise_to_top ();
}

void FormWindow::add_widget (int x, int y)
{
    Widgets::Widget *widget = res->create_widget (selected_widget_type);

    widget->x = x;
    widget->y = y;
}

void FormWindow::show_property_editor (Widgets::Widget *widget)
{
    if (edited_widget == widget)
    {
	property_window->show_all ();
	property_window->get_window ().raise ();
	
	return;
    }

    edited_widget = widget;
    edited_widget_changed_conn.disconnect ();
    edited_widget_changed_conn = edited_widget->changed.connect (
	SigC::slot (this, &FormWindow::edited_widget_changed));
    
    Gtk::Widget *editor = widget->get_editor ();
    
    property_window->remove ();
    property_window->add (*editor);
    
    property_window->show_all ();
    property_window->get_window ().raise ();

    edited_widget_changed ();
}

void FormWindow::show_form_property_editor ()
{
    edited_widget = 0;
    edited_widget_changed_conn.disconnect ();
    
    Gtk::Widget *editor = form->get_editor ();
    
    if (property_window->get_child () != editor)
    {
	property_window->remove ();
	property_window->add (*editor);
    }
    
    gchar *buffer = g_strdup_printf (_("Properties: %s"), res->id ().c_str());
    property_window->set_title (buffer);
    g_free (buffer);
    
    property_window->show_all ();
    property_window->get_window ().raise ();
}

void FormWindow::form_clicked_cb ()
{
    if (selected_widget)
    {
	selected_widget->selected (false);
	selected_widget = 0;
    }

    top_treeitem->select ();
   
    show_form_property_editor ();
}

void FormWindow::widget_clicked_cb (Widgets::Widget *widget)
{
    if (selected_widget)
	selected_widget->selected (false);
    else
	top_treeitem->deselect ();
    
    widget->selected (true);
    selected_widget = widget;

    widget->request_edit ();
}
