//$Id: scrollbar.cc,v 1.9 2001/10/07 13:06:19 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "scrollbar.h"
#include "scrollbar-canvas.h"

#include "form-editor.h"

#include <gnome-xml/xmlmemory.h>

using Guikachu::Widgets::ScrollBar;
using namespace Guikachu::GUI::FormEditor;

ScrollBar::ScrollBar (Resources::Form *owner,
		      const string& id):
    Widget (owner, id),
    Resizeable (changed),
    editor (0),
    usable (changed, true),
    min_value (changed, 0),
    max_value (changed, 0),
    value (changed, 0),
    page_size (changed, 0)
{
    changed.connect (SigC::slot (this, &ScrollBar::update));
}

ScrollBar::~ScrollBar ()
{
    if (editor)
	delete editor;
}

void ScrollBar::update ()
{
    static bool update_block = false;

    if (update_block)
	return;

    update_block = true;
    
    if (max_value < min_value)
	max_value = min_value;

    if (value < min_value)
	value = min_value;

    if (value > max_value)
	value = max_value;

    update_block = false;
}

Gtk::Widget* ScrollBar::create_editor ()
{
    if (!editor)
	editor = new ScrollBarProperties (this);

    return editor->get_editor ();
}

CanvasItem* ScrollBar::create_canvas_item (GUI::FormEditor::Form *form)
{
    return new ScrollBarCanvasItem (this, form);
}

bool ScrollBar::load (StorageNode &node)
{
    /* Non-NULL default values */
    usable = false;
    
    for (StorageNode curr_node  = node.children ();
	 curr_node; curr_node++)
    {
	if (curr_node.name () == "pos")
	{
	    x = curr_node.get_prop<int> ("x");
	    y = curr_node.get_prop<int> ("y");

	    string width_str = curr_node.get_prop<string> ("width");
	    if (width_str == "auto")
	    {
		manual_width = false;
		width = 0;
	    } else {
		manual_width = true;
		width = atoi (width_str.c_str ());
	    }
	    
	    string height_str = curr_node.get_prop<string> ("height");
	    if (height_str == "auto")
	    {
		manual_height = false;
		height = 0;
	    } else {
		manual_height = true;
		height = atoi (height_str.c_str ());
	    }
	}
	else if (curr_node.name () == "usable")
	    usable = true;
	else if (curr_node.name () == "values")
	{
	    min_value = curr_node.get_prop<int> ("min");
	    max_value = curr_node.get_prop<int> ("max");
	    page_size = curr_node.get_prop<int> ("page_size");
	    value     = curr_node.get_prop<int> ("value");
	}
	else
	    g_warning ("Error parsing `scrollbar' widget: "
		       "unexpected element `%s'",
		       curr_node.name ().c_str ());
	}
    
    changed ();

    return true;
}

void ScrollBar::save (StorageNode &node) const
{
    StorageNode my_node;

    /* Position */
    my_node = node.add_node ("pos");
    my_node.set_prop ("x", x);
    my_node.set_prop ("y", y);

    /* Size */
    if (manual_width)
	my_node.set_prop ("width", width);
    else
	my_node.set_prop ("width", "auto");

    if (manual_height)
	my_node.set_prop ("height", height);
    else
	my_node.set_prop ("height", "auto");
    
    /* Usable */
    if (usable)
	node.add_node ("usable");

    /* Values */
    my_node = node.add_node ("values");
    my_node.set_prop ("min",       min_value);
    my_node.set_prop ("max",       min_value);
    my_node.set_prop ("page_size", page_size);
    my_node.set_prop ("value",     value);
}

void ScrollBar::save_rcp (ostream &ostr) const
{
    gchar *width_str, *height_str;

    if (manual_width)
	width_str = g_strdup_printf ("%d", width ());
    else
	width_str = g_strdup ("7");
    
    if (manual_height)
	height_str = g_strdup_printf ("%d", height ());
    else
	height_str = g_strdup ("AUTO");

    ostr << "  SCROLLBAR ID " << id;
    ostr << " AT (" << x << " " << y << " " << width_str << " " << height_str << ")";

    ostr << " VALUE "    << value
	 << " MIN "      << min_value
	 << " MAX "      << max_value
	 << " PAGESIZE " << page_size;

    g_free (height_str);
    g_free (width_str);
}

int ScrollBar::get_display_width ()
{
    if (manual_width)
	return width;

    return 7; /* recommended width for scroll bars */
}

int ScrollBar::get_display_height ()
{
    if (manual_height)
	return height;

    return 100;
}
