//$Id: palette.cc,v 1.9 2001/10/02 21:47:04 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "palette.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <gtk--/table.h>
#include <gtk--/pixmap.h>
#include <gtk--/box.h>
#include <gtk--/separator.h>

#include "form-editor/widget-util.h"

using namespace Guikachu::GUI;

namespace {
#include "pixmaps/none.xpm"
}
    
Palette::Palette ():
    Gtk::Window (GTK_WINDOW_DIALOG),
    sticky (false),
    inside_button_cb (false)
{
    set_title (_("Widget palette"));
    set_policy (false, false, false);

    using namespace SigC;

    Gtk::VBox *vbox = new Gtk::VBox;
    Gtk::HBox *hbox = new Gtk::HBox;

    Gtk::ToggleButton *button_none;

    button_none = create_button (Widgets::WIDGET_NONE, _("Selector"), none_xpm);
    
    hbox->pack_start (*manage (button_none), false, false);
    vbox->add (*manage (hbox));
    vbox->add (*manage (new Gtk::HSeparator));
    
    Gtk::Table *table = new Gtk::Table (3, 5);

#define PALETTE_ADD_BUTTON(type,tip,x,y)						\
    table->attach (*manage (create_button (type, tip, Widgets::type_icon (type))),	\
		   x, (x + 1), y, (y + 1),						\
		   0, 0);								\
    
    PALETTE_ADD_BUTTON(Widgets::WIDGET_LABEL,
		       _("Static text label"),
		       0, 0);
    PALETTE_ADD_BUTTON(Widgets::WIDGET_TEXT_FIELD,
		       _("Editable, dynamic text field"),
		       1, 0);
    PALETTE_ADD_BUTTON(Widgets::WIDGET_GRAFFITI,
		       _("Graffiti state indicator"),
		       2, 0);    

    PALETTE_ADD_BUTTON(Widgets::WIDGET_BUTTON,
		       _("Clickable button"),
		       0, 1);
    PALETTE_ADD_BUTTON(Widgets::WIDGET_PUSHBUTTON,
		       _("Pushbutton"),
		       1, 1);
    PALETTE_ADD_BUTTON(Widgets::WIDGET_SELECTOR_TRIGGER,
		       _("Selector trigger"),
		       2, 1);
    
    PALETTE_ADD_BUTTON(Widgets::WIDGET_CHECKBOX,
		       _("Check box"),
		       0, 2);

    PALETTE_ADD_BUTTON(Widgets::WIDGET_LIST,
		       _("List"),
		       2, 2);

    PALETTE_ADD_BUTTON(Widgets::WIDGET_POPUP_TRIGGER,
		       _("Popup trigger"),
		       1, 2);

    PALETTE_ADD_BUTTON(Widgets::WIDGET_SCROLLBAR,
		       _("Vertical scroll bar"),
		       0, 3);

    PALETTE_ADD_BUTTON(Widgets::WIDGET_SCROLLBAR,
		       _("Vertical scroll bar"),
		       0, 3);

    PALETTE_ADD_BUTTON(Widgets::WIDGET_TABLE,
		       _("Multi-column table"),
		       1, 3);
		       
#undef PALETTE_ADD_BUTTON

    vbox->add (*manage (table));

    add (*manage (vbox));
}

Gtk::ToggleButton * Palette::create_button (Widgets::Type       type,
					    const string&       tooltip,
					    const char * const *icon_xpm)
{
    using namespace SigC;
    
    Gtk::ToggleButton *button = new Gtk::ToggleButton;		

    button->set_relief (GTK_RELIEF_NONE);
    button->add (*manage (new Gtk::Pixmap (icon_xpm)));
    button->set_user_data (GINT_TO_POINTER (type));
    
    button->clicked.connect (bind (slot (this, &Palette::widget_button_cb), type));
    
    tips.set_tip (*button, tooltip);

    buttons.push_front (button);

    return button;
}

void Palette::palette_applied ()
{
    if (!sticky)
	set_selection (Widgets::WIDGET_NONE);
}

int Palette::delete_event_impl (GdkEventAny *e)
{
    hide ();
    return true;
}

void Palette::widget_button_cb (Widgets::Type type)
{
    GdkModifierType modifiers;
    int dummy;
    
    get_window ().get_pointer (dummy, dummy, modifiers);

    sticky = (modifiers & GDK_CONTROL_MASK);
    set_selection (type);
}

void Palette::set_selection (Widgets::Type type)
{
    if (inside_button_cb)
	return;

    inside_button_cb = true;
    
    for (list<Gtk::ToggleButton*>::iterator i = buttons.begin ();
	 i != buttons.end (); i++)
    {
	if (GPOINTER_TO_INT ((*i)->get_user_data ()) == type)
	    (*i)->set_active (true);
	else
	    (*i)->set_active (false);
    }

    inside_button_cb = false;

    palette_changed (type);
}
