//$Id: list.h,v 1.7 2001/10/02 21:47:04 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_LIST_H
#define GUIKACHU_FORM_EDITOR_LIST_H

namespace Guikachu
{
    namespace Widgets
    {
	class List;
    }
}

#include "widget.h"

#include "list-prop.h"

#include <vector>

namespace Guikachu
{
    namespace Widgets
    {
	class List: public Widget
	{
	    GUI::FormEditor::ListProperties *editor;
	    
	public:
	    List (Resources::Form *owner,
		  const string& id);
	    virtual ~List ();
	    
	    virtual Type get_type () const { return WIDGET_LIST; };
	    
	    virtual GUI::FormEditor::CanvasItem *create_canvas_item (GUI::FormEditor::Form *form);
	    virtual Gtk::Widget                 *create_editor ();

	    Property<int>             font;
	    Property<int>             visible_items;
	    Property<bool>            usable;
	    Property<vector<string> > items;
	    Property<int>             width;
	    Property<bool>            manual_width;
	    
	private:
	    // Persistance
	    virtual bool load (StorageNode &node);
	    virtual void save (StorageNode &node) const;
	    virtual void save_rcp (ostream &ostr) const;
	};
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_LIST_H */
