//$Id: form.cc,v 1.21 2001/09/22 19:21:42 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "form.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <gnome--/canvas-group.h>
#include <gnome--/canvas-polygon.h>
#include <gnome--/canvas-rect.h>
#include <sigc++/retbind.h>

#include <list>

#include "form-editor.h"

using namespace Guikachu::GUI::FormEditor;

#define GUIKACHU_WINDOW_TITLE_HEIGHT 13

Form::Form (Resources::Form *res_,
	    GUI::FormWindow *win_):
    res (res_),
    win (win_),
    editor (res),
    group (0),
    frame_group (0),
    title_group (0),
    widget_group (0)
{
    using namespace SigC;

    Gnome::CanvasGroup *root = win->get_canvas ()->root ();
    root->lower_to_bottom ();
    
    Gnome::CanvasRect *background = 
	new Gnome::CanvasRect (*root,
			       0, 0,
			       GUIKACHU_SCREEN_WIDTH - 1,
			       GUIKACHU_SCREEN_HEIGHT - 1);
    background->set_width_pixels (0);
    background->set_fill_color (GUIKACHU_BGC);
    
    group = new Gnome::CanvasGroup (*root, 0, 0);
    group->event.connect (slot (this, &Form::canvas_event_cb));

    widget_group = new Gnome::CanvasGroup (*group, 0, 0);

    res->changed.connect (slot (this, &Form::update));
    update ();
}

Form::~Form ()
{
}

Gnome::CanvasGroup *Form::get_canvas () const
{
    return widget_group;
}

void Form::update ()
{
    draw_frame ();
    draw_title ();
    
    group->set_x (res->x);
    group->set_y (res->y);

    widget_group->raise_to_top ();
    
#if 0
    /* Reset canvas group */
    if (widget_group)
	delete widget_group;
    widget_group = new Gnome::CanvasGroup (*group, 0, 0);

#if 0
    /* FIXME: This looks like my ass
     * But I can't really find a feasible solution to bind the
     * lifetime of Guikachu::GUI::FormEditor::CanvasItems to
     * the lifetime of their underlying Gnome::CanvasItem.
     */
    static list<CanvasItem*> canvas_item_list;
    for (list<CanvasItem*>::iterator i = canvas_item_list.begin ();
	 i != canvas_item_list.end (); i++)
	delete *i;
    canvas_item_list.clear ();
    
    set<Widgets::Widget*> wset = res->get_widgets ();
    for (set<Widgets::Widget*>::iterator i = wset.begin ();
	 i != wset.end (); i++)
    {
	using namespace SigC;
	
	CanvasItem *canvas_item = (*i)->get_canvas_item (this);
	canvas_item->clicked.connect (bind (slot (this, &Form::widget_clicked_cb), *i));
	canvas_item_list.push_back (canvas_item);
    }
#endif
#endif
}

Gtk::Widget* Form::get_editor ()
{
    return editor.get_editor ();
}

void Form::draw_frame ()
{
    if (frame_group)
	delete frame_group;
    frame_group = new Gnome::CanvasGroup (*group, 0, 0);
    
    Gnome::CanvasRect *frame_rect =
	new Gnome::CanvasRect (*frame_group,
			       -1, -1,
			       res->width, res->height);
    frame_rect->set_width_units (1);
    frame_rect->set_fill_color ("");
    
    if (res->modal)
	draw_frame_modal ();
    else
	if (res->frame)
	    draw_frame_nonmodal ();
}

void Form::draw_frame_nonmodal ()
{
    Gnome::CanvasRect *frame_rect =
	new Gnome::CanvasRect (*frame_group,
			       -1, -1,
			       res->width, res->height);
    
    frame_rect->set_width_units (1);
    frame_rect->set_outline_color (GUIKACHU_FGC);
    frame_rect->set_fill_color ("");
}

void Form::draw_frame_modal ()
{
    Gnome::CanvasPoints outer_points, inner_points;

    int x0 = 0;
    int y0 = 0;
    int x1 = res->width;
    int y1 = res->height;
    
    // NW
    outer_points.push_back (Gnome::Art::Point ( (x0 - 2), (y0)     ));
    outer_points.push_back (Gnome::Art::Point ( (x0),     (y0 - 2) ));

    inner_points.push_back (Gnome::Art::Point ( (x0 - 1), (y0)     ));
    inner_points.push_back (Gnome::Art::Point ( (x0),     (y0)     ));
    inner_points.push_back (Gnome::Art::Point ( (x0),     (y0 - 1) ));
    
    // NE
    outer_points.push_back (Gnome::Art::Point ( (x1 - 1), (y0 - 2) ));
    outer_points.push_back (Gnome::Art::Point ( (x1 + 1), (y0)     ));

    inner_points.push_back (Gnome::Art::Point ( (x1 - 1), (y0 - 1) ));
    inner_points.push_back (Gnome::Art::Point ( (x1 - 1), (y0)     ));
    inner_points.push_back (Gnome::Art::Point ( (x1),     (y0)     ));

    // SE
    outer_points.push_back (Gnome::Art::Point ( (x1 + 1), (y1 - 1) ));
    outer_points.push_back (Gnome::Art::Point ( (x1 - 1), (y1 + 1) ));

    inner_points.push_back (Gnome::Art::Point ( (x1),     (y1 - 1) ));
    inner_points.push_back (Gnome::Art::Point ( (x1 - 1), (y1)     ));
    inner_points.push_back (Gnome::Art::Point ( (x1 - 1), (y1)     ));

    // SW
    outer_points.push_back (Gnome::Art::Point ( (x0),     (y1 + 1) ));
    outer_points.push_back (Gnome::Art::Point ( (x0 - 2), (y1 - 1) ));
    
    inner_points.push_back (Gnome::Art::Point ( (x0),     (y1)     ));
    inner_points.push_back (Gnome::Art::Point ( (x0),     (y1 - 1) ));
    inner_points.push_back (Gnome::Art::Point ( (x0 - 1), (y1 - 1) ));
    
    outer_points.push_back (Gnome::Art::Point ( (x0 - 2), (y0)     ));
    inner_points.push_back (Gnome::Art::Point ( (x0 - 1), (y0)     ));

    Gnome::CanvasLine *outer = new Gnome::CanvasLine (*frame_group, outer_points);
    outer->set_width_units (1);
    outer->set_fill_color (GUIKACHU_FGC);

    Gnome::CanvasLine *inner = new Gnome::CanvasLine (*frame_group, inner_points);
    inner->set_width_units (1);
    inner->set_fill_color (GUIKACHU_FGC);
}

void Form::draw_title ()
{
    if (title_group)
	delete title_group;
    title_group = new Gnome::CanvasGroup (*group, 0, 0);

    if (res->title == "")
	return;
    
    if (res->modal)
	draw_title_modal ();
    else
	draw_title_nonmodal ();
}

void Form::draw_title_nonmodal ()
{
    Gnome::CanvasPoints points;
    double title_width;
    const Font &font = get_title_font ();
    
    title_width = get_string_width (1, res->title); /* Title is font#1 (FIXME) */
    title_width = MIN (title_width + 4, res->width);

    int max_width = res->width;
    int max_height = MIN (res->height, GUIKACHU_WINDOW_TITLE_HEIGHT);
    
    // NW corner
    points.push_back (Gnome::Art::Point (0, 1));
    points.push_back (Gnome::Art::Point (1, 0));

    // NE corner
    points.push_back (Gnome::Art::Point (title_width,     0));
    points.push_back (Gnome::Art::Point (title_width + 1, 1));

    // SE corner
    points.push_back (Gnome::Art::Point ((title_width + 1), (GUIKACHU_WINDOW_TITLE_HEIGHT + 1)));
    // SW corner
    points.push_back (Gnome::Art::Point (0, (GUIKACHU_WINDOW_TITLE_HEIGHT + 1)));
    // Back to NW
    points.push_back (Gnome::Art::Point (0, 1));

    {
	using namespace Gnome::CanvasHelpers;

	*(new Gnome::CanvasPolygon (*title_group, points))
	    << width_units (1)
	    << fill_color (GUIKACHU_FGC);

	render_text (*title_group, res->title, font,
		     Gdk_Color (GUIKACHU_BGC),
		     3, 2,
		     GTK_ANCHOR_NW,
		     max_width, max_height);
	
	*(new Gnome::CanvasRect (*title_group))
	    << x1 (0) << y1 (GUIKACHU_WINDOW_TITLE_HEIGHT)
	    << x2 (res->width - 1) << y2 (GUIKACHU_WINDOW_TITLE_HEIGHT + 1)
	    << width_units (1)
	    << fill_color (GUIKACHU_FGC);
    }
}

void Form::draw_title_modal ()
{
    Gnome::CanvasPoints points;
    const Font &font = get_title_font ();
    
    int title_center = res->width / 2;
    int title_height = MIN (res->height, 11);

    int max_width = res->width;
    int max_height = MIN (res->height, 11);

    {
	using namespace Gnome::CanvasHelpers;
    
	*(new Gnome::CanvasRect (*title_group))
	    << x1 (0) << y1 (0)
	    << x2 (res->width) << y2 (title_height)
	    << width_units (1)
	    << fill_color (GUIKACHU_FGC);

	render_text (*title_group, res->title, font,
		     Gdk_Color (GUIKACHU_BGC),
		     title_center, 0,
		     GTK_ANCHOR_N,
		     max_width, max_height);
    }
}

int Form::canvas_event_cb (GdkEvent *e)
{
    static bool dragging = false;
    static bool drag_occured = false;

    static double last_x, last_y;    
    static double offset_x, offset_y;
    
    if (e->type == GDK_BUTTON_RELEASE &&
	(e->button.button == 1))
    {
	group->ungrab (e->button.time);
	dragging = false;
	
	if (drag_occured)
	{
	    res->x = (int)(last_x - offset_x);
	    res->y = (int)(last_y - offset_y);
	}
    }

    if (e->type == GDK_MOTION_NOTIFY && dragging)
    {
	drag_occured = true;

	double curr_x = e->motion.x;
	double curr_y = e->motion.y;

	// Right and lower bounds
	if ((curr_x - offset_x) > (GUIKACHU_SCREEN_WIDTH - 1))
	    curr_x = (GUIKACHU_SCREEN_WIDTH - 1) + offset_x;
	if ((curr_y - offset_y) > (GUIKACHU_SCREEN_HEIGHT - 1))
	    curr_y = (GUIKACHU_SCREEN_HEIGHT - 1) + offset_y;

	// Left and upper bounds
	if ((curr_x - offset_x) < 0)
	    curr_x = offset_x;
	if ((curr_y - offset_y) < 0)
	    curr_y = offset_y;
	
	group->move (curr_x - last_x, curr_y - last_y);
	
	last_x = curr_x;
	last_y = curr_y;
    }

    
    if ((e->type == GDK_BUTTON_PRESS) &&
	(e->button.button == 1))
    {
	dragging = true;
	drag_occured = false;

	last_x = e->button.x;
	last_y = e->button.y;

	offset_x = last_x - res->x;
	offset_y = last_y - res->y;

	Gdk_Cursor cursor (gdk_cursor_new (GDK_FLEUR));
	group->grab (GDK_POINTER_MOTION_MASK | GDK_BUTTON_RELEASE_MASK,
		     cursor, e->button.time);
	
	clicked ();
    }
    
    return true;
}

