//$Id: canvasitem.cc,v 1.10 2001/09/19 21:13:56 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "canvasitem.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <gnome--/app-helper.h>
#include <gnome--/canvas-rect.h>
#include <libgnomeui/gnome-stock.h>
#include <list>

#include "form-editor.h"

using namespace Guikachu::GUI::FormEditor;

CanvasItem::CanvasItem (Widgets::Widget  *widget_,
			FormEditor::Form *form_):
    item (0),
    widget (widget_),
    bounding_box (0),
    form (form_),
    selected (false)
{
    drag_context.dragging = false;
    drag_context.drag_occured = false;
    
    using namespace Gnome;
    
    list <UI::Info> popup_menu_list;
    /*
    popup_menu_list.push_back (
	UI::Item (_("Move"),
		  SigC::slot (this, &CanvasItem::move_cb)));
    */
    popup_menu_list.push_back (
	UI::Item (UI::Icon (GNOME_STOCK_PIXMAP_TRASH),
		  _("Remove"),
		  SigC::slot (this, &CanvasItem::remove_cb)));
    
    UI::fill (popup_menu, popup_menu_list, *(popup_menu.get_accel_group ()));

    widget->changed.connect  (SigC::slot (this, &CanvasItem::update));
    widget->selected.connect (SigC::slot (this, &CanvasItem::widget_selected_cb));
}

CanvasItem::~CanvasItem ()
{
    if (item)
	delete item;

    if (bounding_box)
	delete bounding_box;
}

void CanvasItem::set_canvas_item (Gnome::CanvasGroup *item_)
{
    item = item_;
    bounding_box = 0;
    
    item->event.connect (SigC::slot (this, &CanvasItem::canvas_event_cb));
    widget_selected_cb (selected);
}

void CanvasItem::remove_cb ()
{
    widget->get_form ()->remove_widget (widget);
}

void CanvasItem::move_cb ()
{
#if 0
    GdkEvent *event = gdk_event_get ();

    cerr << event->motion.x << endl << event->motion.y << endl;
    
    switch (event->type) {
    case GDK_ENTER_NOTIFY:
    case GDK_LEAVE_NOTIFY:
	item->get_canvas ()->window_to_world (event->crossing.x, event->crossing.y,
					      event->crossing.x, event->crossing.y);
	break;
	
    case GDK_MOTION_NOTIFY:
    case GDK_BUTTON_PRESS:
    case GDK_2BUTTON_PRESS:
    case GDK_3BUTTON_PRESS:
    case GDK_BUTTON_RELEASE:
	item->get_canvas ()->window_to_world (event->motion.x, event->motion.y,
					      event->motion.x, event->motion.y);
	break;
	
    default:
	break;
    }
    
    cerr << event->motion.x << endl << event->motion.y << endl;
    
    drag_begin (event);
#else
    GdkEvent event;

    int pointer_x, pointer_y;

    gdk_window_get_pointer (item->get_canvas ()->get_window (),
			    &pointer_x,
			    &pointer_y,
			    0);
    item->get_canvas ()->window_to_world (pointer_x, pointer_y,
					  event.button.x, event.button.y);
    event.button.time = GDK_CURRENT_TIME;
    
    drag_begin (&event);
#endif
}

int CanvasItem::canvas_event_cb (GdkEvent *e)
{
    /*
    if (drag_context.dragging)
	cerr << "canvas_event_cb" << endl;
    */
	
    // Begin drag
    if (e->type == GDK_BUTTON_PRESS &&
	e->button.button == 1 &&
	!drag_context.dragging)
	drag_begin (e);
    
    // Dragging
    if (e->type == GDK_MOTION_NOTIFY &&
	drag_context.dragging)
	drag_motion (e);

    // Ending drag
    if (e->type == GDK_BUTTON_RELEASE &&
	(e->button.button == 1) &&
	drag_context.dragging)
	drag_end (e);
    

    // Single click
    if ((e->type == GDK_BUTTON_PRESS) &&
	(e->button.button == 1))
	clicked ();
    

    // Context menu
    if ((e->type == GDK_BUTTON_PRESS) &&
	(e->button.button == 3))
    {
	popup_menu.popup (e->button.button, e->button.time);
    }
    
    return TRUE;
}

void CanvasItem::drag_begin (GdkEvent *e)
{
    drag_context.dragging = true;
    drag_context.drag_occured = false;

    drag_context.last_x = e->button.x;
    drag_context.last_y = e->button.y;
    
    drag_context.offset_x = drag_context.last_x - widget->x;
    drag_context.offset_y = drag_context.last_y - widget->y;
    
    Gdk_Cursor cursor (gdk_cursor_new (GDK_FLEUR));
    item->grab (GDK_POINTER_MOTION_MASK | GDK_BUTTON_MOTION_MASK |
		GDK_BUTTON_RELEASE_MASK | GDK_BUTTON_PRESS_MASK,
		cursor, e->button.time);
}

void CanvasItem::drag_motion (GdkEvent *e)
{
    drag_context.drag_occured = true;
    
    double curr_x = e->motion.x;
    double curr_y = e->motion.y;
    
    // East bound
    if ((curr_x - drag_context.offset_x) > (GUIKACHU_SCREEN_WIDTH - 1))
	    curr_x = (GUIKACHU_SCREEN_WIDTH - 1) + drag_context.offset_x;
    
    // South bound
    if ((curr_y - drag_context.offset_y) > (GUIKACHU_SCREEN_HEIGHT - 1))
	curr_y = (GUIKACHU_SCREEN_HEIGHT - 1) + drag_context.offset_y;
    
    // West bound
    if ((curr_x - drag_context.offset_x) < 0)
	curr_x = drag_context.offset_x;
    
    // North bound
    if ((curr_y - drag_context.offset_y) < 0)
	curr_y = drag_context.offset_y;
    
    item->move (curr_x - drag_context.last_x,
		curr_y - drag_context.last_y);
    
    drag_context.last_x = curr_x;
    drag_context.last_y = curr_y;     
}

void CanvasItem::drag_end (GdkEvent *e)
{
    item->ungrab (e->button.time);
    drag_context.dragging = false;
    
    if (drag_context.drag_occured)
    {
	widget->x = (int)(drag_context.last_x - drag_context.offset_x);
	widget->y = (int)(drag_context.last_y - drag_context.offset_y);
    }
}

void CanvasItem::widget_selected_cb (bool selected_)
{
    selected = selected_;
    
    if (!selected)
    {
	if (bounding_box)
	{
	    delete bounding_box;
	    bounding_box = 0;
	}
	return;
    }

    delete bounding_box;
    bounding_box = create_bounding_box ();
}

Gnome::CanvasItem * CanvasItem::create_bounding_box ()
{
    double x1, x2, y1, y2;

    item->get_bounds (x1, y1, x2, y2);

    using namespace Gnome::CanvasHelpers;
    Gnome::CanvasItem *bounding_box = new Gnome::CanvasRect (*item,
							     x1 - 2, y1 - 2,
							     x2 + 2, y2 + 2);
    *bounding_box
	<< width_units (2)
	<< outline_color (GUIKACHU_SELECTED);

    return bounding_box;
}
