//$Id: dialog-res.h,v 1.6 2001/09/16 13:06:06 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_DIALOG_RES_H
#define GUIKACHU_DIALOG_RES_H

namespace Guikachu
{
    namespace Resources
    {
	class Dialog;

	enum DialogType
	{
	    DIALOG_INFORMATION,
	    DIALOG_CONFIRMATION,
	    DIALOG_WARNING,
	    DIALOG_ERROR
	};
	    
    }
}

#include "resource.h"
#include "dialog-win.h"

#include <vector>

namespace Guikachu
{
    namespace Resources
    {
	class Dialog: public Resource
	{
	    Guikachu::GUI::DialogWindow *gui;
	public:
	    Dialog (const string& id);
	    virtual ~Dialog ();
	    
	    virtual Type get_type () const { return RESOURCE_DIALOG; };
	    virtual void show_ui ();

	    Property<string>          title;
	    Property<string>          text;
	    Property<DialogType>      dialog_type;
	    Property<vector<string> > buttons;
	    Property<unsigned int>    default_button;
	    Property<string>          help_id;
	    
	private:
	    virtual bool load (StorageNode &node);
	    virtual void save (StorageNode &node) const;
	    virtual void save_rcp (ostream &ostr) const;
	};
    };
};

#endif /* !GUIKACHU_DIALOG_RES_H */
