<?xml version="1.0"?> <!-- -*- xml -*- -->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <!-- Position and size -->
  <xsl:template match="form/pos">
    <xsl:text>AT (</xsl:text>
    
    <!-- Position -->
    <xsl:value-of select="@x"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@y"/>
    
    <!-- Size -->
    <xsl:text> </xsl:text>
    <xsl:value-of select="@width"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@height"/>
    <xsl:text>)</xsl:text>  
  </xsl:template>
  
  <!-- A form -->
  <xsl:template match="form">
    <xsl:text>FORM ID </xsl:text>
    <xsl:value-of select="@id"/>
    <xsl:text>
</xsl:text>

    <xsl:apply-templates select="pos"/>
    <xsl:text>
</xsl:text>

    <!-- Flags -->
    <xsl:text>USABLE </xsl:text>
    
    <xsl:choose>
      <xsl:when test="savebehind">
	<xsl:text>SAVEBEHIND </xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text>NOSAVEBEHIND </xsl:text>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:choose>
      <xsl:when test="frame">
	<xsl:text>FRAME </xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text>NOFRAME </xsl:text>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:if test="modal">
      <xsl:text>MODAL</xsl:text>
    </xsl:if>

    <xsl:text>
</xsl:text>

    <!-- Form menu -->
    <xsl:if test="menu">
      <xsl:text>MENUID </xsl:text>
      <xsl:value-of select="menu/@id"/>
      <xsl:text>
</xsl:text>
    </xsl:if>

    <!-- Widgets -->
    <xsl:text>BEGIN</xsl:text>
    <xsl:text>
</xsl:text>
    <xsl:if test="title">
      <xsl:text>  TITLE "</xsl:text>
      <xsl:value-of select="title"/>
      <xsl:text>"
</xsl:text>
    </xsl:if>
    <xsl:apply-templates select="widgets"/>
    <xsl:text>END</xsl:text>
    
    <xsl:text>

</xsl:text>
  </xsl:template>

  <xsl:include href="widgets.xsl"/>

</xsl:stylesheet>
