//$Id: widget.h,v 1.24 2001/09/22 17:59:13 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_WIDGET_H
#define GUIKACHU_FORM_EDITOR_WIDGET_H

namespace Guikachu
{
    namespace Widgets
    {
	enum Type
	{
	    WIDGET_NONE,
	    WIDGET_LABEL,
	    WIDGET_BUTTON,
	    WIDGET_PUSHBUTTON,
	    WIDGET_GRAFFITI,
	    WIDGET_SELECTOR_TRIGGER,
	    WIDGET_CHECKBOX,
	    WIDGET_LIST,
	    WIDGET_POPUP_TRIGGER,
	    WIDGET_SCROLLBAR,
	    WIDGET_TEXT_FIELD
	};

	class Widget;
    }
}

#include <string>
#include <map>
#include <iostream>
#include <gnome-xml/tree.h>
#include <sigc++/basic_signal.h>

#include "form-res.h"
#include "form.h"
#include "canvasitem.h"

#include "property.h"

namespace Guikachu
{
    namespace Widgets
    {
	class Widget: public SigC::Object
	{
	protected:
	    typedef map<GUI::FormEditor::Form*,
		        GUI::FormEditor::CanvasItem*>   canvas_item_map_t;
	    
	    Resources::Form            *owner;
	    mutable Gtk::Widget       *editor;
	    mutable canvas_item_map_t  canvas_items;
	    
	    Widget (Resources::Form *owner, const string& id);
	    
	public:
	    virtual ~Widget ();
	    
	    virtual Type get_type () const = 0;

	    // Notification
	    SigC::Signal0<void> changed;
	    
	    // Common properties
	    ID            id;
	    Property<int> x;
	    Property<int> y;

	    // Preview-related methods
	    GUI::FormEditor::CanvasItem *get_canvas_item (GUI::FormEditor::Form *form);
	    Gtk::Widget                 *get_editor      ();

	    virtual Gtk::Widget                 *create_editor      () = 0;
	    virtual GUI::FormEditor::CanvasItem *create_canvas_item (GUI::FormEditor::Form *form) = 0;
	    
	    Resources::Form *get_form () const { return owner; };

	    SigC::Signal1<void, bool> selected;
	    SigC::Signal0<void>       request_edit;
	    
	private:
	    // Persistance
	    virtual bool load (StorageNode &node) = 0;
	    virtual void save (StorageNode &node) const = 0;
	    virtual void save_rcp (ostream &ostr) const = 0;
	    friend ostream& operator<< (ostream &ostr, const Widget *res);
	    
	    friend class Resources::Form;
	};
	
	ostream& operator<< (ostream &ostr, const Widget* res);
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_WIDGET_H */
