//$Id: graffiti.cc,v 1.7 2001/09/18 22:28:47 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "graffiti.h"
#include "graffiti-canvas.h"

#include <gnome-xml/xmlmemory.h>

using Guikachu::Widgets::Graffiti;
using namespace Guikachu::GUI::FormEditor;

Graffiti::Graffiti (Resources::Form *owner,
		    const string& id):
    Widget (owner, id)
{
    editor = new GraffitiProperties (this);
}

Graffiti::~Graffiti ()
{
    delete editor;
}

Gtk::Widget *Graffiti::create_editor ()
{
    return editor->get_editor ();
}

CanvasItem* Graffiti::create_canvas_item (GUI::FormEditor::Form *form)
{
    return new GraffitiCanvasItem (this, form);
}

bool Graffiti::load (StorageNode &node)
{
    for (StorageNode curr_node  = node.children ();
	 curr_node; curr_node++)
    {
	if (curr_node.name () == "pos")
	{
	    x = curr_node.get_prop<int> ("x");
	    y = curr_node.get_prop<int> ("y");
	}
	else
	    g_warning ("Error parsing `graffiti' widget: "
		       "unexpected element `%s'",
		       curr_node.name ().c_str ());
    }

    changed ();

    return true;
}

void Graffiti::save (StorageNode &node) const
{
    StorageNode my_node;

    /* Position */
    my_node = StorageNode (node).add_node ("pos");
    my_node.set_prop ("x", x);
    my_node.set_prop ("y", y);
}

void Graffiti::save_rcp (ostream &ostr) const
{
    ostr << "  GRAFFITISTATEINDICATOR";
    ostr << " AT (" << x << " " << y << ")";
    ostr << endl;
}

