//$Id: treeitem.cc,v 1.2 2001/02/24 16:04:14 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "treeitem.h"

#include <gnome--/app-helper.h>
#include <list>

using namespace Guikachu;
using namespace Gnome;

GUI::TreeItem::TreeItem (Resources::Resource *res_):
    Gtk::TreeItem (res_->get_id ()),
    res (res_)
{
    button_press_event.connect (slot (this, &GUI::TreeItem::clicked_cb));
    res->changed.connect (slot (this, &GUI::TreeItem::resource_changed_cb));

    list <UI::Info> popup_menu_list;
    popup_menu_list.push_back (
	UI::Item (UI::Icon (GNOME_STOCK_PIXMAP_TRASH),
		  _("Remove"),
		  SigC::slot (this, &GUI::TreeItem::menu_remove_cb)));
    UI::fill (popup_menu, popup_menu_list, *(popup_menu.get_accel_group ()));
}

int GUI::TreeItem::clicked_cb (GdkEventButton *e)
{
    if (e->type == GDK_2BUTTON_PRESS && e->button == 1)
	res->show_ui ();

    if (e->button == 3)
	popup_menu.popup (e->button, e->time);
    
    return false;
    
}

void GUI::TreeItem::resource_changed_cb ()
{
    remove ();
    add_label (res->get_id ());
}

void GUI::TreeItem::menu_remove_cb ()
{
    ResourceManager::remove_resource (res);
}

