//$Id: string-win.cc,v 1.2 2001/02/24 16:04:14 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "string-win.h"

#include <gtk--.h>
#include <sigc++/retbind.h>

using namespace Guikachu;

GUI::StringWindow::StringWindow (Guikachu::Resources::String *res_):
    res (res_)
{
    gui = glade_xml_new (GLADEDIR "/guikachu.glade", NULL);

    window = Gtk::wrap (GTK_WINDOW (glade_xml_get_widget (gui, "res_string")));
    window->delete_event.connect (SigC::slot (this, &StringWindow::delete_event_impl));
    
    id_entry = Gtk::wrap (GTK_ENTRY (glade_xml_get_widget (gui, "str_name")));
    text_entry = Gtk::wrap (GTK_TEXT (glade_xml_get_widget (gui, "str_text")));
    
    id_entry->activate.connect (SigC::bind (
	SigC::slot (this, &StringWindow::id_entry_cb), (GdkEventFocus*) 0));
    id_entry->focus_out_event.connect (SigC::retbind (
	SigC::slot (this, &StringWindow::id_entry_cb), 0));

    text_entry->changed.connect (slot (this, &StringWindow::text_entry_cb));
    text_entry->set_word_wrap (true);
    
    block_text_entry_cb = false;

    res->changed.connect (slot (this, &StringWindow::update));
    update ();
}

GUI::StringWindow::~StringWindow ()
{
    window->destroy ();
    gtk_object_unref (GTK_OBJECT (gui));
}

int GUI::StringWindow::delete_event_impl (GdkEventAny *e)
{
    window->hide ();
    return true;
}

void GUI::StringWindow::show ()
{
    window->show_all ();
}

void GUI::StringWindow::update ()
{
    window->set_title ("String: " + res->get_id ());

    id_entry->set_text (res->get_id ());

    block_text_entry_cb = true;

    if (text_entry->get_length())
	text_entry->delete_text (0, text_entry->get_length ());
    text_entry->insert (res->get_text ());

    block_text_entry_cb = false;
}

void GUI::StringWindow::id_entry_cb (GdkEventFocus *e)
{
    res->set_id (id_entry->get_text ());
}

void GUI::StringWindow::text_entry_cb ()
{
    if (block_text_entry_cb)
    {
	return;
    }

    res->set_text (text_entry->get_chars (0, text_entry->get_length ()));
}
