//$Id: resource-manager.h,v 1.3 2001/02/25 19:10:11 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_RESOURCE_MANAGER_H
#define GUIKACHU_RESOURCE_MANAGER_H

namespace Guikachu
{
    class ResourceManager;
}


#include "resource.h"
#include "string-case.h"
#include <map>
#include <set>

#include "mainwin.h"

namespace Guikachu
{
    class ResourceManager: public SigC::Object
    {
	static map<string_case, Resources::Resource*> resource_map;
	static set<string_case> id_set;
	static GUI::MainWin* main_win; /* FIXME: support more than one
					  live view */

	static bool dirty;
    public:
	static void set_main_win (GUI::MainWin *main_win_);
	
	static Resources::Resource* create_resource (Resources::Type type,
						     const string& id);
	static bool register_resource (const string& id);
	static void remove_resource (const string& id);
	static void remove_resource (Resources::Resource* resource);
	static bool rename_resource (const string& old_id,
				     const string& new_id);

	static string create_id (const string& prefix);
	
	// Persistance
	static void reset ();
	static bool is_dirty ();
	static void load (const string& filename);
	static void save (const string& filename);
	static void export_rcp (const string& filename); 

    private:
	static void resource_changed_cb ();
	static Resources::Resource* load_resource (xmlDocPtr doc,
						   xmlNodePtr node);
    };
}

#endif /* !GUIKACHU_RESOURCE_MANAGER_H */
