//$Id: resource-manager-io.cc,v 1.2 2001/02/24 16:04:14 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "resource-manager.h"

#include <fstream>
#include <gnome-xml/parser.h>

using namespace Guikachu;

void ResourceManager::reset ()
{
    map<string_case, Resources::Resource*>::iterator i;
    
    for (i = resource_map.begin ();
	 i != resource_map.end ();
	 i++)
    {
	remove_resource (i->second);
    }

    dirty = false;
}

void ResourceManager::load (const string& filename)
{
    reset ();
    
    xmlDocPtr doc;
    xmlNodePtr root_node, curr_node;

    doc = xmlParseFile (filename.c_str ());
    root_node = xmlDocGetRootElement (doc);
    
    if (strcmp ((char*)root_node->name, "guikachu"))
    {
        GUI::show_error ("Document of the wrong type, root node != guikachu\n");
        xmlFreeDoc(doc);
        return;
    }

    /*
     * Walk the tree
     */
    for (curr_node = root_node->xmlChildrenNode;
         curr_node != NULL;
         curr_node = curr_node->next)
	load_resource (doc, curr_node);

    dirty = false;
}

Resources::Resource* ResourceManager::load_resource (xmlDocPtr doc,
						     xmlNodePtr node)
{
    Resources::Resource *resource = 0;
    
    char *node_name = (char*)node->name;
    char *id = (char*)xmlGetProp (node, (xmlChar*)"id");

    if (!id)
	return NULL;
    
    
    if (!strcmp (node_name, "string"))
	resource = create_resource (Resources::RESOURCE_STRING, id);
    else if (!strcmp (node_name, "dialog"))
	resource = create_resource (Resources::RESOURCE_DIALOG, id);
    else if (!strcmp (node_name, "menu"))
	resource = create_resource (Resources::RESOURCE_MENU, id);
    else
	g_warning ("Unknown resource type `%s'", node_name);

    if (resource)
	resource->load (doc, node);
    
    return resource;
}

void ResourceManager::save (const string& filename)
{
    xmlDocPtr doc = xmlNewDoc ((xmlChar*)"1.0");
    xmlNodePtr root = xmlNewNode (NULL, (xmlChar*)"guikachu");
    xmlNodePtr node = 0;
    
    xmlDocSetRootElement (doc, root);
	
    for (map<string_case, Resources::Resource*>::iterator i = resource_map.begin ();
	 i != resource_map.end ();
	 i++)
    {
	xmlChar *curr_node_name = 0;

	switch (i->second->get_type ())
	{
	case Resources::RESOURCE_STRING:
	    curr_node_name = (xmlChar*) "string";
	    break;
	case Resources::RESOURCE_DIALOG:
	    curr_node_name = (xmlChar*) "dialog";
	    break;
	case Resources::RESOURCE_MENU:
	    curr_node_name = (xmlChar*) "menu";
	    break;
	case Resources::RESOURCE_FORM:
	    curr_node_name = (xmlChar*) "form";
	    break;
	}
	
	node = xmlNewChild (root, NULL, curr_node_name, NULL);
	xmlSetProp (node, (xmlChar*)"id", (xmlChar*)i->second->get_id ().c_str ());
	i->second->save (node);
    }
    
    xmlSaveFile (filename.c_str(), doc);

    dirty = false;
}

void ResourceManager::export_rcp (const string& filename)
{
    ofstream fout (filename.c_str ());

    for (map<string_case, Resources::Resource*>::iterator i = resource_map.begin ();
	 i != resource_map.end ();
	 i++)
    {
	fout << i->second;
    }
    
    fout.close ();
}
