//$Id: menu-res.cc,v 1.3 2001/02/25 19:10:11 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "menu-res.h"

using namespace Guikachu;
using namespace Guikachu::Resources;

Menu::Menu (const string& id_)
{
    id = id_;
    gui = new GUI::MenuWindow (this);
}

Menu::~Menu ()
{
    delete gui;
}

void Menu::show_ui ()
{
    gui->show ();
}

static bool register_menu (const vector<Submenu>& menu)
{
    bool success = true;
    
    for (vector<Submenu>::const_iterator i = menu.begin ();
	 i != menu.end (); i++)
    {
	for (vector<MenuItem>::const_iterator j = i->items.begin ();
	     j != i->items.end (); j++)
	{
	    if (!j->separator)
		if (!ResourceManager::register_resource (j->id))
		    success = false;
	}
    }

    return success;
}

static void deregister_menu (const vector<Submenu>& menu)
{
    for (vector<Submenu>::const_iterator i = menu.begin ();
	 i != menu.end (); i++)
    {
	for (vector<MenuItem>::const_iterator j = i->items.begin ();
	     j != i->items.end (); j++)
	{
	    if (!j->separator)
		ResourceManager::remove_resource (j->id);
	}
    }
}

void Menu::set_submenus (const vector<Submenu>& new_menu)
{
    vector<Submenu> old_submenus = submenus;
    
    deregister_menu (submenus);    
    if (!register_menu (new_menu))
    {
	deregister_menu (new_menu);
	register_menu (submenus);
    } else {
	submenus = new_menu;
    }

    changed ();
}

bool Menu::load (xmlDocPtr doc,
		 xmlNodePtr node)
{
#define XML_HAS_NAME(node,val) (!strcmp ((char*)node->name, val))
    
    for (xmlNodePtr curr_node  = node->xmlChildrenNode;
	 curr_node != NULL;
	 curr_node  = curr_node->next)
    {
	if (XML_HAS_NAME (curr_node, "submenu"))
	{
	    Submenu submenu;
	    gchar *xml_label = (gchar*)xmlGetProp (curr_node, (xmlChar*)"label");
	    
	    if (!xml_label)
		break;

	    submenu.label = xml_label;
	    g_free (xml_label);
	    
	    for (xmlNodePtr sub_node = curr_node->xmlChildrenNode;
		 sub_node != NULL;
		 sub_node = sub_node->next)
	    {
		MenuItem menu_item;
		
		if (XML_HAS_NAME (sub_node, "menuitem"))
		{
		    gchar *xml_id = (gchar*)xmlGetProp (sub_node, (xmlChar*)"id");
		    gchar *xml_label = (gchar*)xmlGetProp (sub_node, (xmlChar*)"label");
		    gchar *xml_shortcut = (gchar*)xmlGetProp (sub_node, (xmlChar*)"shortcut");

		    if (!xml_label || !xml_id)
			break;

		    menu_item.separator = false;

		    menu_item.id = xml_id;
		    g_free (xml_id);

		    menu_item.label = xml_label;
		    g_free (xml_label);

		    if (xml_shortcut)
		    {
			menu_item.shortcut = xml_shortcut[0];
			g_free (xml_shortcut);
		    } else {
			menu_item.shortcut = 0;
		    }

		    submenu.items.push_back (menu_item);
		}
		else if (XML_HAS_NAME (sub_node, "separator"))
		{
		    menu_item.separator = true;

		    submenu.items.push_back (menu_item);
		}
		else
		    g_warning ("Error parsing `menu' resource: "
			       "unexpected element `%s/%s'",
			       curr_node->name, sub_node->name);
	    }

	    submenus.push_back (submenu);
	}	    
	else
	    g_warning ("Error parsing `menu' resource: "
		       "unexpected element `%s'", curr_node->name);

    }
    
    changed ();
    
    return true;
}

void Menu::save (xmlNodePtr node) const
{
    xmlNodePtr submenu_node, item_node;
    
    for (vector<Submenu>::const_iterator i = submenus.begin ();
	 i != submenus.end (); i++)
    {
	submenu_node = xmlNewChild (node, NULL, (xmlChar*) "submenu", NULL);
	xmlSetProp (submenu_node, (xmlChar*) "label",
		    (xmlChar*) i->label.c_str ());

	for (vector<MenuItem>::const_iterator j = i->items.begin ();
	     j != i->items.end (); j++)
	{
	    if (j->separator)
	    {
		item_node = xmlNewChild (submenu_node, NULL, (xmlChar*) "separator", NULL);
	    } else {
		item_node = xmlNewChild (submenu_node, NULL, (xmlChar*) "menuitem", NULL);
		xmlSetProp (item_node, (xmlChar*) "id",
			    (xmlChar*) j->id.c_str ());
		xmlSetProp (item_node, (xmlChar*) "label",
			    (xmlChar*) j->label.c_str ());
		if (j->shortcut)
		{
		    gchar *shortcut_str = g_strdup_printf ("%c", j->shortcut);
		    xmlSetProp (item_node, (xmlChar*) "shortcut",
				(xmlChar*) shortcut_str);
		    g_free (shortcut_str);    
		}
	    }
	}
    }
}

void Menu::save_rcp (ostream &ostr) const
{
    ostr << "MENU ID " << id << endl;

    ostr << "BEGIN" << endl;

    for (vector<Submenu>::const_iterator i = submenus.begin ();
	 i != submenus.end (); i++)
    {
	ostr << "  PULLDOWN \"" << i->label << "\"" << endl;
	
	ostr << "  BEGIN" << endl;
	for (vector<MenuItem>::const_iterator j = i->items.begin ();
	     j != i->items.end (); j++)
	{
	    if (j->separator)
		ostr << "    MENUITEM SEPARATOR" << endl;
	    else
	    {
		ostr << "    MENUITEM \"" << j->label << "\" ID " << j->id;
		if (j->shortcut)
		    ostr << " \"" << j->shortcut << "\"";
		ostr << endl;
	    }
	}
	ostr << "  END" << endl;
    }
    
    ostr << "END" << endl;
}
