//$Id: mainwin.cc,v 1.3 2001/02/24 16:04:14 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "mainwin.h"

#include <gtk--.h>
#include <gnome--/dialog.h>
#include <gnome--/about.h>
#include <glade/glade.h>

#include <list>

#include "resource-manager.h"

#include "treeitem.h"
#include "add-resource.h"

#include <fstream>
#include <sigc++/rettype.h>

using namespace Gnome;
using namespace Guikachu;

GUI::MainWin::MainWin ():
    Gnome::App ("Guikachu", "Guikachu"),
    filename (""),
    in_exit (false)
{
    /* Create status bar */
    set_statusbar (*manage (new Gtk::Statusbar ()));
    
    /* Create the menu */
    list <UI::Info> menubar;

    /* File menu */
    list <UI::Info> m_file;
    m_file.push_back (MenuItems::New    (_("New project"), _("Create a new project"),
					 SigC::slot (this, &MainWin::new_cb)));
    m_file.push_back (MenuItems::Open   (SigC::slot (this, &MainWin::load_cb)));
    m_file.push_back (MenuItems::Save   (SigC::slot (this, &MainWin::save_cb)));
    m_file.push_back (MenuItems::SaveAs (SigC::slot (this, &MainWin::save_as_cb)));
    m_file.push_back (UI::Item          (UI::Icon (GNOME_STOCK_PIXMAP_CONVERT),
					 _("Export RCP..."),
					 SigC::slot (this, &MainWin::export_cb),
					 _("Create an RCP file for compilation")));
    m_file.push_back (UI::Separator     ());
    m_file.push_back (MenuItems::Exit   (SigC::bind (
	SigC::rettype<void>(delete_event.slot()),
	(GdkEventAny*)0)));
    menubar.push_back (Menus::File (m_file));

    /* Help menu */
    list <UI::Info> m_help;
    m_help.push_back (MenuItems::About (SigC::slot (&show_about)));
    menubar.push_back (Menus::Help (m_help));
    
    create_menus (menubar);
    install_menu_hints ();

    /* Create the tool bar */
    list <UI::Info> toolbar;
    toolbar.push_back (UI::Item (UI::Icon (GNOME_STOCK_PIXMAP_ADD),
				 _("Add"),
				 SigC::slot (this, &MainWin::add_cb),
				 _("Add new component to current project")));
    toolbar.push_back (UI::Separator ());
    toolbar.push_back (UI::Item (UI::Icon (GNOME_STOCK_PIXMAP_NEW),
				 _("New"),
				 SigC::slot (this, &MainWin::new_cb),
				 _("New project")));
    toolbar.push_back (UI::Item (UI::Icon (GNOME_STOCK_PIXMAP_OPEN),
				 _("Open"),
				 SigC::slot (this, &MainWin::load_cb),
				 _("Open project")));
    toolbar.push_back (UI::Item (UI::Icon (GNOME_STOCK_PIXMAP_SAVE),
				 _("Save"),
				 SigC::slot (this, &MainWin::save_cb),
				 _("Save project")));

    create_toolbar (toolbar);
    
    set_contents (main_tree);
    
    set_usize (300, 300);

    /* Create subtrees */
    create_tree_for_type (Resources::RESOURCE_DIALOG, _("Dialogs"));
    create_tree_for_type (Resources::RESOURCE_FORM, _("Forms"));
    create_tree_for_type (Resources::RESOURCE_MENU, _("Menus"));
    create_tree_for_type (Resources::RESOURCE_STRING, _("Strings"));
    
    /* Register ourselves with the Resource Manager */
    ResourceManager::set_main_win (this);

    update_title ();
}

void GUI::MainWin::add_resource (Resources::Resource *res)
{
    TreeItem *item = new GUI::TreeItem (res);
    item->show ();

    Gtk::TreeItem *subtree_item = subtrees.find (res->get_type ())->second;
    
    if (!subtree_item->get_subtree ())
    {
	subtree_item->set_subtree (*manage (new Gtk::Tree ()));
    }
    
    subtree_item->get_subtree ()->tree ().push_back (*manage (item));
    treeitems.insert (treeitem_map::value_type (res, item));
}

void GUI::MainWin::remove_resource (Resources::Resource *res)
{
    treeitem_map::iterator treeitem_entry =
	treeitems.find (res);

    if (treeitem_entry != treeitems.end ())
    {
	Gtk::TreeItem *subtree_item = subtrees.find (res->get_type ())->second;
	Gtk::Tree_Helpers::ItemList subtree_list = subtree_item->get_subtree ()->tree ();
	
	subtree_list.remove (treeitem_entry->second);
    }
}

void GUI::MainWin::create_tree_for_type (Resources::Type type,
					 const string& category_name)
{
    Gtk::TreeItem *subtree_item = new Gtk::TreeItem (category_name);
    pair<subtree_map::iterator, bool> success;
    
    success = subtrees.insert (subtree_map::value_type (type, subtree_item));
    
    if (!success.second)
    {
	delete subtree_item;

	return;
    }

    subtree_item->show ();
    main_tree.tree ().push_back (*manage (subtree_item));
}

void GUI::MainWin::add_cb ()
{
    AddResourceWin add_win;

    add_win.run ();
}

void GUI::MainWin::update_title ()
{
    gchar *title_buf;

    if (filename != "")
	title_buf = g_strdup_printf (_("Guikachu: %s"), g_basename (filename.c_str ()));
    else
	title_buf = g_strdup_printf (_("Guikachu: %s"), "<none>");
	
    set_title (title_buf);

    g_free (title_buf);
}

void GUI::show_about ()
{
    list<string> authors;
    authors.push_back ("Gerg rdi <cactus@cactus.rulez.org>");

    Gnome::About *about = new Gnome::About ("Guikachu", "0.1",
					    "(C) 2001 Gerg rdi",
					    authors,
					    "PalmOS resource file editor");
    about->run ();  
}

void GUI::show_error (const string& message)
{
    Gnome::Dialog *dialog = Gnome::Dialogs::error (message);
    dialog->run ();  
}
