/* Generated by GOB (v1.0.7) on Sun Apr 15 13:00:28 2001
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 3 "bonobo-media-vorbis.gob"

 /* bonobo-media-vorbis: Ogg Vorbis player using the Bonobo:Meida interfaces
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Copyright (c) 2001  Ali Abdin  <aliabdin@aucegypt.edu> and
 *                     RDI Gerg <cactus@cactus.rulez.org>
 */

#line 30 "bonobo-media-vorbis.c"
#define GOB_VERSION_MAJOR 1
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 7

#include <string.h> /* memset() */

#include "bonobo-media-vorbis.h"

#include "bonobo-media-vorbis-private.h"


#line 35 "bonobo-media-vorbis.gob"

#include <bonobo/bonobo-exception.h>
#include <pthread.h>
#include <esd.h>	

#include "bonobo-media-vorbis-video.h"
#include <bonobo-media/bonobo-media-audio.h>
	
#include <bonobo-media/bonobo-media-stream-private.h>

#define VORBIS_ENTER(self) pthread_mutex_lock   (&(self->_priv->vorbis_mutex))
#define VORBIS_EXIT(self)  pthread_mutex_unlock (&(self->_priv->vorbis_mutex))

#line 56 "bonobo-media-vorbis.c"
/* self casting macros */
#define SELF(x) BONOBO_MEDIA_VORBIS(x)
#define SELF_CONST(x) BONOBO_MEDIA_VORBIS_CONST(x)
#define IS_SELF(x) BONOBO_IS_MEDIA_VORBIS(x)
#define SELF_CLASS(x) BONOBO_MEDIA_VORBIS_CLASS(x)

#define SELF_GET_CLASS(x) BONOBO_MEDIA_VORBIS_GET_CLASS(x)

/* self typedefs */
typedef BonoboMediaVorbis Self;
typedef BonoboMediaVorbisClass SelfClass;

/* GTK_CLASS_TYPE for 1.2<->1.3/2.0 GTK+ compatibility */
#ifndef GTK_CLASS_TYPE
#define GTK_CLASS_TYPE(x) (GTK_OBJECT_CLASS(x)->type)
#endif /* GTK_CLASS_TYPE */

/* here are local prototypes */
static void bonobo_media_vorbis_init (BonoboMediaVorbis * o) G_GNUC_UNUSED;
static void bonobo_media_vorbis_class_init (BonoboMediaVorbisClass * c) G_GNUC_UNUSED;
static gboolean bonobo_media_vorbis_update_position (BonoboMediaVorbis * self) G_GNUC_UNUSED;
static gfloat ___2_bonobo_media_vorbis_get_pos_per_sec (BonoboMediaStream * media_stream, CORBA_Environment * ev) G_GNUC_UNUSED;
static gint ___3_bonobo_media_vorbis_get_length (BonoboMediaStream * media_stream, CORBA_Environment * ev) G_GNUC_UNUSED;
static void ___4_bonobo_media_vorbis_seek (BonoboMediaStream * media_stream, gint pos, CORBA_Environment * ev) G_GNUC_UNUSED;
static void bonobo_media_vorbis_audio_init (BonoboMediaVorbis * self) G_GNUC_UNUSED;
static void * bonobo_media_vorbis_player_func (BonoboMediaVorbis * self) G_GNUC_UNUSED;
static void bonobo_media_vorbis_audio_cleanup (BonoboMediaVorbis * self) G_GNUC_UNUSED;
static void ___8_bonobo_media_vorbis_play (BonoboMediaStream * media_stream, CORBA_Environment * ev) G_GNUC_UNUSED;
static void ___9_bonobo_media_vorbis_stop (BonoboMediaStream * media_stream, CORBA_Environment * ev) G_GNUC_UNUSED;
static void bonobo_media_vorbis_volume_cb (GtkObject * obj, gfloat vol, BonoboMediaVorbis * self) G_GNUC_UNUSED;
static void bonobo_media_vorbis_speaker_cb (GtkObject * obj, BonoboMediaVorbis * self) G_GNUC_UNUSED;
static void bonobo_media_vorbis_read_file_info (BonoboMediaVorbis * self) G_GNUC_UNUSED;
static void bonobo_media_vorbis_construct (BonoboMediaVorbis * self) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static BonoboMediaStreamClass *parent_class = NULL;

GtkType
bonobo_media_vorbis_get_type (void)
{
	static GtkType type = 0;

	if (type == 0) {
		static const GtkTypeInfo info = {
			"BonoboMediaVorbis",
			sizeof (BonoboMediaVorbis),
			sizeof (BonoboMediaVorbisClass),
			(GtkClassInitFunc) bonobo_media_vorbis_class_init,
			(GtkObjectInitFunc) bonobo_media_vorbis_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		type = gtk_type_unique (bonobo_media_stream_get_type(), &info);
	}

	return type;
}

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define update_position(args...) bonobo_media_vorbis_update_position(args)
#define audio_init(args...) bonobo_media_vorbis_audio_init(args)
#define player_func(args...) bonobo_media_vorbis_player_func(args)
#define audio_cleanup(args...) bonobo_media_vorbis_audio_cleanup(args)
#define volume_cb(args...) bonobo_media_vorbis_volume_cb(args)
#define speaker_cb(args...) bonobo_media_vorbis_speaker_cb(args)
#define read_file_info(args...) bonobo_media_vorbis_read_file_info(args)
#define PersistFile_load(args...) bonobo_media_vorbis_PersistFile_load(args)
#define PersistFile_save(args...) bonobo_media_vorbis_PersistFile_save(args)
#define load_file(args...) bonobo_media_vorbis_load_file(args)
#define construct(args...) bonobo_media_vorbis_construct(args)
#define new_from_file(args...) bonobo_media_vorbis_new_from_file(args)
#define new() bonobo_media_vorbis_new()
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static gboolean (* const update_position) (BonoboMediaVorbis * self) = bonobo_media_vorbis_update_position;
static void (* const audio_init) (BonoboMediaVorbis * self) = bonobo_media_vorbis_audio_init;
static void * (* const player_func) (BonoboMediaVorbis * self) = bonobo_media_vorbis_player_func;
static void (* const audio_cleanup) (BonoboMediaVorbis * self) = bonobo_media_vorbis_audio_cleanup;
static void (* const volume_cb) (GtkObject * obj, gfloat vol, BonoboMediaVorbis * self) = bonobo_media_vorbis_volume_cb;
static void (* const speaker_cb) (GtkObject * obj, BonoboMediaVorbis * self) = bonobo_media_vorbis_speaker_cb;
static void (* const read_file_info) (BonoboMediaVorbis * self) = bonobo_media_vorbis_read_file_info;
static gint (* const PersistFile_load) (BonoboPersistFile * pf, const CORBA_char * filename, CORBA_Environment * ev, BonoboMediaVorbis * self) = bonobo_media_vorbis_PersistFile_load;
static gint (* const PersistFile_save) (BonoboPersistFile * pf, const CORBA_char * filename, CORBA_Environment * ev, BonoboMediaVorbis * self) = bonobo_media_vorbis_PersistFile_save;
static void (* const load_file) (BonoboMediaVorbis * self, const gchar * filename) = bonobo_media_vorbis_load_file;
static void (* const construct) (BonoboMediaVorbis * self) = bonobo_media_vorbis_construct;
static BonoboMediaVorbis * (* const new_from_file) (const gchar * filename) = bonobo_media_vorbis_new_from_file;
static BonoboMediaVorbis * (* const new) (void) = bonobo_media_vorbis_new;

/* a macro for creating a new object of our type */
#define GET_NEW ((BonoboMediaVorbis *)gtk_type_new(bonobo_media_vorbis_get_type()))


static void
___destroy(GtkObject *obj_self)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::destroy"
	BonoboMediaVorbis *self = BONOBO_MEDIA_VORBIS (obj_self);
	if(GTK_OBJECT_CLASS(parent_class)->destroy) \
		(* GTK_OBJECT_CLASS(parent_class)->destroy)(obj_self);
#line 54 "bonobo-media-vorbis.gob"
	if(self->_priv->vorbis_file) { ((*(void (*)(void *))g_free)) (self->_priv->vorbis_file); self->_priv->vorbis_file = NULL; }
#line 162 "bonobo-media-vorbis.c"
#line 55 "bonobo-media-vorbis.gob"
	if(self->_priv->fileinfo) { ((*(void (*)(void *))g_free)) (self->_priv->fileinfo); self->_priv->fileinfo = NULL; }
#line 165 "bonobo-media-vorbis.c"
#define VAR (self->_priv->timeout_id)
	{
#line 60 "bonobo-media-vorbis.gob"
	
			if (VAR)
				gtk_timeout_remove (VAR);
		}
#line 173 "bonobo-media-vorbis.c"
	memset(&VAR, 0, sizeof(VAR));
#undef VAR
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__


#ifdef G_OBJECT_CLASS
static void
___finalize(GObject *obj_self)
#else /* !G_OBJECT_CLASS */
static void
___finalize(GtkObject *obj_self)
#endif /* G_OBJECT_CLASS */
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::finalize"
	BonoboMediaVorbis *self = BONOBO_MEDIA_VORBIS (obj_self);
	gpointer priv = self->_priv;
#ifdef G_OBJECT_CLASS
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#else /* !G_OBJECT_CLASS */
	if(GTK_OBJECT_CLASS(parent_class)->finalize) \
		(* GTK_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#endif /* G_OBJECT_CLASS */
	g_free(priv);
}
#undef __GOB_FUNCTION__

static void 
bonobo_media_vorbis_init (BonoboMediaVorbis * o)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::init"
	o->_priv = g_new0 (BonoboMediaVorbisPrivate, 1);
#line 35 "bonobo-media-vorbis.gob"
	o->_priv->vorbis_file = 0;
#line 211 "bonobo-media-vorbis.c"
#line 35 "bonobo-media-vorbis.gob"
	o->_priv->fileinfo = 0;
#line 214 "bonobo-media-vorbis.c"
#line 60 "bonobo-media-vorbis.gob"
	o->_priv->timeout_id = 0;
#line 217 "bonobo-media-vorbis.c"
#line 112 "bonobo-media-vorbis.gob"
	o->_priv->playing = FALSE;
#line 220 "bonobo-media-vorbis.c"
#line 112 "bonobo-media-vorbis.gob"
	o->_priv->esd_channel = -1;
#line 223 "bonobo-media-vorbis.c"
#line 112 "bonobo-media-vorbis.gob"
	o->_priv->esd_fd = -1;
#line 226 "bonobo-media-vorbis.c"
	return;
	o = NULL;
}
#undef __GOB_FUNCTION__
static void 
bonobo_media_vorbis_class_init (BonoboMediaVorbisClass * c)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::class_init"
	GtkObjectClass *gtk_object_class = (GtkObjectClass*) c;
#ifdef G_OBJECT_CLASS
	GObjectClass *g_object_class = (GObjectClass*) c;
#endif /* G_OBJECT_CLASS */
	BonoboMediaStreamClass *bonobo_media_stream_class = (BonoboMediaStreamClass *)c;

	parent_class = gtk_type_class (bonobo_media_stream_get_type ());

#line 84 "bonobo-media-vorbis.gob"
	bonobo_media_stream_class->get_pos_per_sec = ___2_bonobo_media_vorbis_get_pos_per_sec;
#line 101 "bonobo-media-vorbis.gob"
	bonobo_media_stream_class->get_length = ___3_bonobo_media_vorbis_get_length;
#line 108 "bonobo-media-vorbis.gob"
	bonobo_media_stream_class->seek = ___4_bonobo_media_vorbis_seek;
#line 229 "bonobo-media-vorbis.gob"
	bonobo_media_stream_class->play = ___8_bonobo_media_vorbis_play;
#line 246 "bonobo-media-vorbis.gob"
	bonobo_media_stream_class->stop = ___9_bonobo_media_vorbis_stop;
#line 253 "bonobo-media-vorbis.c"
	gtk_object_class->destroy = ___destroy;
#ifdef G_OBJECT_CLASS
	g_object_class->finalize = ___finalize;
#else /* !G_OBJECT_CLASS */
	gtk_object_class->finalize = ___finalize;
#endif /* G_OBJECT_CLASS */
	return;
	c = NULL;
	gtk_object_class = NULL;
#ifdef G_OBJECT_CLASS
	g_object_class = NULL;
#endif /* G_OBJECT_CLASS */
}
#undef __GOB_FUNCTION__



#line 65 "bonobo-media-vorbis.gob"
static gboolean 
bonobo_media_vorbis_update_position (BonoboMediaVorbis * self)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::update_position"
#line 65 "bonobo-media-vorbis.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 65 "bonobo-media-vorbis.gob"
	g_return_val_if_fail (BONOBO_IS_MEDIA_VORBIS (self), (gboolean )0);
#line 280 "bonobo-media-vorbis.c"
{
#line 66 "bonobo-media-vorbis.gob"
	
			gint current_time;

			VORBIS_ENTER (self);
			current_time = (int)ov_pcm_tell (self->_priv->vorbis_file);
			VORBIS_EXIT (self);
			
			bonobo_media_stream_send_pos_notification (
				BONOBO_MEDIA_STREAM (self),
				current_time);
				
			if (current_time == self->_priv->length)
				bonobo_media_stream_send_end_notification (
					BONOBO_MEDIA_STREAM (self));

			return TRUE;
		}}
#line 300 "bonobo-media-vorbis.c"
#undef __GOB_FUNCTION__

#line 84 "bonobo-media-vorbis.gob"
static gfloat 
___2_bonobo_media_vorbis_get_pos_per_sec (BonoboMediaStream * media_stream, CORBA_Environment * ev)
#line 306 "bonobo-media-vorbis.c"
#define PARENT_HANDLER(___media_stream,___ev) \
	((BONOBO_MEDIA_STREAM_CLASS(parent_class)->get_pos_per_sec)? \
		(* BONOBO_MEDIA_STREAM_CLASS(parent_class)->get_pos_per_sec)(___media_stream,___ev): \
		((gfloat )0))
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::get_pos_per_sec"
{
#line 87 "bonobo-media-vorbis.gob"
	
			Self *self = SELF (media_stream);
			gfloat ratio;

			/* Since position is in decoded values (to
			   avoid problems with variable bit-rate
			   streams), ratio is effectively the same as
			   the output sampling rate */
			ratio = self->_priv->length /
				ov_time_total (self->_priv->vorbis_file, -1);

			return ratio;
		}}
#line 328 "bonobo-media-vorbis.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 101 "bonobo-media-vorbis.gob"
static gint 
___3_bonobo_media_vorbis_get_length (BonoboMediaStream * media_stream, CORBA_Environment * ev)
#line 335 "bonobo-media-vorbis.c"
#define PARENT_HANDLER(___media_stream,___ev) \
	((BONOBO_MEDIA_STREAM_CLASS(parent_class)->get_length)? \
		(* BONOBO_MEDIA_STREAM_CLASS(parent_class)->get_length)(___media_stream,___ev): \
		((gint )0))
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::get_length"
{
#line 104 "bonobo-media-vorbis.gob"
	
			return SELF (media_stream)->_priv->length;
		}}
#line 347 "bonobo-media-vorbis.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 108 "bonobo-media-vorbis.gob"
static void 
___4_bonobo_media_vorbis_seek (BonoboMediaStream * media_stream, gint pos, CORBA_Environment * ev)
#line 354 "bonobo-media-vorbis.c"
#define PARENT_HANDLER(___media_stream,___pos,___ev) \
	{ if(BONOBO_MEDIA_STREAM_CLASS(parent_class)->seek) \
		(* BONOBO_MEDIA_STREAM_CLASS(parent_class)->seek)(___media_stream,___pos,___ev); }
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::seek"
{
#line 112 "bonobo-media-vorbis.gob"
	
			gint seek_success;
			BonoboMediaVorbis *self = SELF (media_stream);

			if (pos < 0 || pos > self->_priv->length) {
				CORBA_exception_set (ev, CORBA_USER_EXCEPTION,
						     ex_Bonobo_Media_Stream_InvalidPosition,
						     NULL);
				return;
			}

			VORBIS_ENTER (self);
			seek_success = ov_pcm_seek (self->_priv->vorbis_file, pos);
			VORBIS_EXIT (self);
			
			if (!seek_success) {
				CORBA_exception_set (ev, CORBA_USER_EXCEPTION,
						     ex_Bonobo_Media_Stream_InvalidPosition,
						     NULL);
				return;
			}
			update_position (self);
		}}
#line 385 "bonobo-media-vorbis.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 145 "bonobo-media-vorbis.gob"
static void 
bonobo_media_vorbis_audio_init (BonoboMediaVorbis * self)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::audio_init"
#line 145 "bonobo-media-vorbis.gob"
	g_return_if_fail (self != NULL);
#line 145 "bonobo-media-vorbis.gob"
	g_return_if_fail (BONOBO_IS_MEDIA_VORBIS (self));
#line 398 "bonobo-media-vorbis.c"
{
#line 146 "bonobo-media-vorbis.gob"
	
			esd_format_t esd_format = ESD_STREAM | ESD_PLAY;
			gchar *esd_speaker;
			
			g_return_if_fail (self->_priv->fileinfo);
			g_return_if_fail (self->_priv->esd_fd == -1);
			
			gtk_object_get (GTK_OBJECT (self->_priv->audio),
					BONOBO_MEDIA_AUDIO_GET_ARG_ESD_SPEAKER (&esd_speaker),
					0);
			
			self->_priv->esd_channel = esd_open_sound (esd_speaker);
			
			esd_format |= ESD_BITS16;
			if (self->_priv->fileinfo->channels == 1)
				esd_format |= ESD_MONO;
			else
				esd_format |= ESD_STEREO;
			
			self->_priv->esd_fd = esd_play_stream
				(esd_format, self->_priv->fileinfo->rate,
				 esd_speaker,
				 "bonobo-media-vorbis");
		}}
#line 425 "bonobo-media-vorbis.c"
#undef __GOB_FUNCTION__

#line 171 "bonobo-media-vorbis.gob"
static void * 
bonobo_media_vorbis_player_func (BonoboMediaVorbis * self)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::player_func"
#line 171 "bonobo-media-vorbis.gob"
	g_return_val_if_fail (self != NULL, (void * )0);
#line 171 "bonobo-media-vorbis.gob"
	g_return_val_if_fail (BONOBO_IS_MEDIA_VORBIS (self), (void * )0);
#line 437 "bonobo-media-vorbis.c"
{
#line 172 "bonobo-media-vorbis.gob"
	
			/* Do some audio output */
			int ret = 1;
			char buffer[4096];
			int section = -1;

			pthread_cleanup_push ((void (*)(void*))audio_cleanup, self);
			
			if (!self->_priv->fileinfo)
				pthread_exit (0);

			for (;;)
			{
				if (!self->_priv->playing)
				{
					pthread_mutex_lock (&(self->_priv->player_mutex));
					pthread_cond_wait (&(self->_priv->playing_cond),
							   &(self->_priv->player_mutex));
					pthread_mutex_unlock (&(self->_priv->player_mutex));
				}
				
				if (self->_priv->playing)
				{
					VORBIS_ENTER (self);

					ret = ov_read (self->_priv->vorbis_file,
						       buffer, sizeof (buffer),
						       0, 2, 1,
						       &section);
					if (ret > 0)
						write (self->_priv->esd_fd, buffer, ret);
					else
						self->_priv->playing = FALSE;

					VORBIS_EXIT (self);
				}
			}	

			pthread_cleanup_pop (TRUE);
			pthread_exit (0);
		}}
#line 481 "bonobo-media-vorbis.c"
#undef __GOB_FUNCTION__

#line 214 "bonobo-media-vorbis.gob"
static void 
bonobo_media_vorbis_audio_cleanup (BonoboMediaVorbis * self)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::audio_cleanup"
#line 214 "bonobo-media-vorbis.gob"
	g_return_if_fail (self != NULL);
#line 214 "bonobo-media-vorbis.gob"
	g_return_if_fail (BONOBO_IS_MEDIA_VORBIS (self));
#line 493 "bonobo-media-vorbis.c"
{
#line 215 "bonobo-media-vorbis.gob"
	
			if (self->_priv->esd_fd != -1)
			{
				close (self->_priv->esd_fd);
				self->_priv->esd_fd = -1;
			}
			
			if (self->_priv->esd_channel != -1)
			{
				esd_close (self->_priv->esd_channel);
				self->_priv->esd_channel = -1;
			}
		}}
#line 509 "bonobo-media-vorbis.c"
#undef __GOB_FUNCTION__

#line 229 "bonobo-media-vorbis.gob"
static void 
___8_bonobo_media_vorbis_play (BonoboMediaStream * media_stream, CORBA_Environment * ev)
#line 515 "bonobo-media-vorbis.c"
#define PARENT_HANDLER(___media_stream,___ev) \
	{ if(BONOBO_MEDIA_STREAM_CLASS(parent_class)->play) \
		(* BONOBO_MEDIA_STREAM_CLASS(parent_class)->play)(___media_stream,___ev); }
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::play"
{
#line 232 "bonobo-media-vorbis.gob"
	
			BonoboMediaVorbis *self = SELF (media_stream);
			
			self->_priv->playing = TRUE;
			bonobo_media_stream_send_play_notification (
				BONOBO_MEDIA_STREAM (self));
			
			pthread_cond_signal (&(self->_priv->playing_cond));
			 
			if (!self->_priv->timeout_id)
				self->_priv->timeout_id = 
					gtk_timeout_add (100, (GtkFunction)update_position, self);
		}}
#line 536 "bonobo-media-vorbis.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 246 "bonobo-media-vorbis.gob"
static void 
___9_bonobo_media_vorbis_stop (BonoboMediaStream * media_stream, CORBA_Environment * ev)
#line 543 "bonobo-media-vorbis.c"
#define PARENT_HANDLER(___media_stream,___ev) \
	{ if(BONOBO_MEDIA_STREAM_CLASS(parent_class)->stop) \
		(* BONOBO_MEDIA_STREAM_CLASS(parent_class)->stop)(___media_stream,___ev); }
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::stop"
{
#line 249 "bonobo-media-vorbis.gob"
	
			BonoboMediaVorbis *self = SELF (media_stream);
			
			self->_priv->playing = FALSE;
			bonobo_media_stream_send_stop_notification (
				BONOBO_MEDIA_STREAM (self));
			
			if (self->_priv->timeout_id)
				gtk_timeout_remove (self->_priv->timeout_id);
				
			self->_priv->timeout_id = 0;
		}}
#line 563 "bonobo-media-vorbis.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 262 "bonobo-media-vorbis.gob"
static void 
bonobo_media_vorbis_volume_cb (GtkObject * obj, gfloat vol, BonoboMediaVorbis * self)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::volume_cb"
#line 262 "bonobo-media-vorbis.gob"
	g_return_if_fail (self != NULL);
#line 262 "bonobo-media-vorbis.gob"
	g_return_if_fail (BONOBO_IS_MEDIA_VORBIS (self));
#line 576 "bonobo-media-vorbis.c"
{
#line 264 "bonobo-media-vorbis.gob"
	
			printf ("Volume changed to %f\n", vol);
		}}
#line 582 "bonobo-media-vorbis.c"
#undef __GOB_FUNCTION__

#line 268 "bonobo-media-vorbis.gob"
static void 
bonobo_media_vorbis_speaker_cb (GtkObject * obj, BonoboMediaVorbis * self)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::speaker_cb"
#line 268 "bonobo-media-vorbis.gob"
	g_return_if_fail (self != NULL);
#line 268 "bonobo-media-vorbis.gob"
	g_return_if_fail (BONOBO_IS_MEDIA_VORBIS (self));
#line 594 "bonobo-media-vorbis.c"
{
#line 270 "bonobo-media-vorbis.gob"
	
			audio_cleanup (self);
			audio_init (self);
		}}
#line 601 "bonobo-media-vorbis.c"
#undef __GOB_FUNCTION__

#line 275 "bonobo-media-vorbis.gob"
static void 
bonobo_media_vorbis_read_file_info (BonoboMediaVorbis * self)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::read_file_info"
#line 275 "bonobo-media-vorbis.gob"
	g_return_if_fail (self != NULL);
#line 275 "bonobo-media-vorbis.gob"
	g_return_if_fail (BONOBO_IS_MEDIA_VORBIS (self));
#line 613 "bonobo-media-vorbis.c"
{
#line 276 "bonobo-media-vorbis.gob"
		
			self->_priv->length = (int)ov_pcm_total(self->_priv->vorbis_file,-1);
			self->_priv->fileinfo = ov_info (self->_priv->vorbis_file, -1);
		}}
#line 620 "bonobo-media-vorbis.c"
#undef __GOB_FUNCTION__

#line 281 "bonobo-media-vorbis.gob"
gint 
bonobo_media_vorbis_PersistFile_load (BonoboPersistFile * pf, const CORBA_char * filename, CORBA_Environment * ev, BonoboMediaVorbis * self)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::PersistFile_load"
#line 281 "bonobo-media-vorbis.gob"
	g_return_val_if_fail (self != NULL, (gint )0);
#line 281 "bonobo-media-vorbis.gob"
	g_return_val_if_fail (BONOBO_IS_MEDIA_VORBIS (self), (gint )0);
#line 632 "bonobo-media-vorbis.c"
{
#line 285 "bonobo-media-vorbis.gob"
	
			load_file (self, filename);
			
			return 0;
		}}
#line 640 "bonobo-media-vorbis.c"
#undef __GOB_FUNCTION__

#line 291 "bonobo-media-vorbis.gob"
gint 
bonobo_media_vorbis_PersistFile_save (BonoboPersistFile * pf, const CORBA_char * filename, CORBA_Environment * ev, BonoboMediaVorbis * self)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::PersistFile_save"
#line 291 "bonobo-media-vorbis.gob"
	g_return_val_if_fail (self != NULL, (gint )0);
#line 291 "bonobo-media-vorbis.gob"
	g_return_val_if_fail (BONOBO_IS_MEDIA_VORBIS (self), (gint )0);
#line 652 "bonobo-media-vorbis.c"
{
#line 295 "bonobo-media-vorbis.gob"
	
			CORBA_exception_set (ev, CORBA_USER_EXCEPTION,
					     ex_Bonobo_NotSupported, NULL);
			return 0;
		}}
#line 660 "bonobo-media-vorbis.c"
#undef __GOB_FUNCTION__

#line 301 "bonobo-media-vorbis.gob"
void 
bonobo_media_vorbis_load_file (BonoboMediaVorbis * self, const gchar * filename)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::load_file"
#line 301 "bonobo-media-vorbis.gob"
	g_return_if_fail (self != NULL);
#line 301 "bonobo-media-vorbis.gob"
	g_return_if_fail (BONOBO_IS_MEDIA_VORBIS (self));
#line 672 "bonobo-media-vorbis.c"
{
#line 302 "bonobo-media-vorbis.gob"
	
			FILE *thefile;
			gint open_succ;
			
			if (self->_priv->timeout_id)
				gtk_timeout_remove (self->_priv->timeout_id);
			if (&self->_priv->vorbis_file)
				ov_clear (self->_priv->vorbis_file);
			
			if (!self->_priv->vorbis_file)
				self->_priv->vorbis_file = g_new (OggVorbis_File, 1);

			thefile = fopen (filename, "rb");
			open_succ = ov_open (thefile, self->_priv->vorbis_file, NULL, 0);
			if (open_succ < 0) {
         	       		/* This is unpredictable - We should return an
				 * exception or something*/
                		fclose(thefile);
                		g_assert ("Ack! We passed a non-Ogg Vorbis file!!!");
			}

			read_file_info (self);

			pthread_cancel (self->_priv->player_thread);
			pthread_create (&(self->_priv->player_thread), NULL,
					(void * (*)(void*))player_func,
					self);
		}}
#line 703 "bonobo-media-vorbis.c"
#undef __GOB_FUNCTION__

#line 331 "bonobo-media-vorbis.gob"
static void 
bonobo_media_vorbis_construct (BonoboMediaVorbis * self)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::construct"
#line 331 "bonobo-media-vorbis.gob"
	g_return_if_fail (self != NULL);
#line 331 "bonobo-media-vorbis.gob"
	g_return_if_fail (BONOBO_IS_MEDIA_VORBIS (self));
#line 715 "bonobo-media-vorbis.c"
{
#line 332 "bonobo-media-vorbis.gob"
	
			Bonobo_Media_Stream corba_stream;
			BonoboMediaAudio  *audio;
			BonoboPersistFile *pf;
			BonoboMediaVideo  *video;
			
			corba_stream = bonobo_media_stream_corba_object_create (BONOBO_OBJECT (self));

			audio = bonobo_media_audio_new ();
			gtk_signal_connect
				(GTK_OBJECT (audio), "volume_changed", 
				 (GtkSignalFunc) bonobo_media_vorbis_volume_cb, self);
			gtk_signal_connect
				(GTK_OBJECT (audio), "speaker_changed", 
				 GTK_SIGNAL_FUNC (bonobo_media_vorbis_speaker_cb), self);
			bonobo_object_add_interface (BONOBO_OBJECT (self),
						     BONOBO_OBJECT (audio));
			self->_priv->audio = audio;
			
			pf = bonobo_persist_file_new
				((BonoboPersistFileIOFn) PersistFile_load,
				 (BonoboPersistFileIOFn) PersistFile_save,
				 self);
			bonobo_object_add_interface (BONOBO_OBJECT (self),
						     BONOBO_OBJECT (pf));
			
			video = bonobo_media_vorbis_video_new ();
			bonobo_object_add_interface (BONOBO_OBJECT (self),
						     BONOBO_OBJECT (video));

			pthread_mutex_init (&(self->_priv->vorbis_mutex), NULL);
			pthread_mutex_init (&(self->_priv->player_mutex), NULL);

			pthread_cond_init (&(self->_priv->playing_cond), NULL);
			
			bonobo_media_stream_construct (BONOBO_MEDIA_STREAM (self), corba_stream);
		}}
#line 755 "bonobo-media-vorbis.c"
#undef __GOB_FUNCTION__

#line 370 "bonobo-media-vorbis.gob"
BonoboMediaVorbis * 
bonobo_media_vorbis_new_from_file (const gchar * filename)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::new_from_file"
#line 763 "bonobo-media-vorbis.c"
{
#line 371 "bonobo-media-vorbis.gob"
	
			Self *self;

			self = bonobo_media_vorbis_new ();

			construct (self);
			load_file (self, filename);

			return self;
		}}
#line 776 "bonobo-media-vorbis.c"
#undef __GOB_FUNCTION__

#line 382 "bonobo-media-vorbis.gob"
BonoboMediaVorbis * 
bonobo_media_vorbis_new (void)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Vorbis::new"
#line 784 "bonobo-media-vorbis.c"
{
#line 383 "bonobo-media-vorbis.gob"
	
			Self *self;
			
			self = GET_NEW;
			
			construct (self);

			return self;
		}}
#line 796 "bonobo-media-vorbis.c"
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___bonobo_media_vorbis_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))update_position)();
	((void (*)(void))audio_init)();
	((void (*)(void))player_func)();
	((void (*)(void))audio_cleanup)();
	((void (*)(void))volume_cb)();
	((void (*)(void))speaker_cb)();
	((void (*)(void))read_file_info)();
	((void (*)(void))PersistFile_load)();
	((void (*)(void))PersistFile_save)();
	((void (*)(void))load_file)();
	((void (*)(void))construct)();
	((void (*)(void))new_from_file)();
	((void (*)(void))new)();
	___bonobo_media_vorbis_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

