/* Generated by GOB (v1.0.9) on Wed Apr 25 22:02:11 2001
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 3 "media-player-stream.gob"

/* $Id: media-player-control.gob,v 1.6 2001/01/22 17:24:43 cactus Exp $
 *
 * media-player-control: A Bonobo control implementing a simple user
 * interface for playback of Bonobo media streams
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (c) 2000-2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 */

#line 34 "media-player-stream.c"
#define GOB_VERSION_MAJOR 1
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 9

#include <string.h> /* memset() */

#include "media-player-stream.h"

#include "media-player-stream-private.h"


#line 33 "media-player-stream.gob"

#include <libgnome/libgnome.h>
#include <liboaf/liboaf.h>

#include <bonobo/bonobo-widget.h>
#include <bonobo/bonobo-arg.h>
#include <libgnomeui/libgnomeui.h>

#include "play.xpm"
#include "pause.xpm"
#include "stop.xpm"

#line 59 "media-player-stream.c"
/* self casting macros */
#define SELF(x) MEDIA_PLAYER_STREAM(x)
#define SELF_CONST(x) MEDIA_PLAYER_STREAM_CONST(x)
#define IS_SELF(x) MEDIA_IS_PLAYER_STREAM(x)
#define SELF_CLASS(x) MEDIA_PLAYER_STREAM_CLASS(x)

#define SELF_GET_CLASS(x) MEDIA_PLAYER_STREAM_GET_CLASS(x)

/* self typedefs */
typedef MediaPlayerStream Self;
typedef MediaPlayerStreamClass SelfClass;

/* GTK_CLASS_TYPE for 1.2<->1.3/2.0 GTK+ compatibility */
#ifndef GTK_CLASS_TYPE
#define GTK_CLASS_TYPE(x) (GTK_OBJECT_CLASS(x)->type)
#endif /* GTK_CLASS_TYPE */

/* here are local prototypes */
static void media_player_stream_init (MediaPlayerStream * o) G_GNUC_UNUSED;
static void media_player_stream_class_init (MediaPlayerStreamClass * c) G_GNUC_UNUSED;
static void media_player_stream_update (MediaPlayerStream * self) G_GNUC_UNUSED;
static void media_player_stream_update_length (MediaPlayerStream * self) G_GNUC_UNUSED;
static void media_player_stream_register_listener (MediaPlayerStream * self) G_GNUC_UNUSED;
static void media_player_stream_listener_cb (BonoboListener * listener, char * event_name, BonoboArg * event_data, CORBA_Environment * ev, Self * self) G_GNUC_UNUSED;
static void media_player_stream_position_cb (MediaPlayerStream * self, int pos) G_GNUC_UNUSED;
static gint media_player_stream_scale_press_cb (GtkObject * caller, GdkEvent * event, Self * self) G_GNUC_UNUSED;
static gint media_player_stream_scale_release_cb (GtkObject * caller, GdkEvent * event, Self * self) G_GNUC_UNUSED;
static void media_player_stream_seek (MediaPlayerStream * self, gint pos) G_GNUC_UNUSED;
static void media_player_stream_play_cb (GtkObject * caller, Self * self) G_GNUC_UNUSED;
static void media_player_stream_pause_cb (GtkObject * caller, Self * self) G_GNUC_UNUSED;
static void media_player_stream_stop_cb (GtkObject * caller, Self * self) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GtkVBoxClass *parent_class = NULL;

GtkType
media_player_stream_get_type (void)
{
	static GtkType type = 0;

	if (type == 0) {
		static const GtkTypeInfo info = {
			"MediaPlayerStream",
			sizeof (MediaPlayerStream),
			sizeof (MediaPlayerStreamClass),
			(GtkClassInitFunc) media_player_stream_class_init,
			(GtkObjectInitFunc) media_player_stream_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		type = gtk_type_unique (gtk_vbox_get_type(), &info);
	}

	return type;
}

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define set_stream(args...) media_player_stream_set_stream(args)
#define update(args...) media_player_stream_update(args)
#define update_length(args...) media_player_stream_update_length(args)
#define register_listener(args...) media_player_stream_register_listener(args)
#define listener_cb(args...) media_player_stream_listener_cb(args)
#define position_cb(args...) media_player_stream_position_cb(args)
#define scale_press_cb(args...) media_player_stream_scale_press_cb(args)
#define scale_release_cb(args...) media_player_stream_scale_release_cb(args)
#define seek(args...) media_player_stream_seek(args)
#define play_cb(args...) media_player_stream_play_cb(args)
#define pause_cb(args...) media_player_stream_pause_cb(args)
#define stop_cb(args...) media_player_stream_stop_cb(args)
#define construct(args...) media_player_stream_construct(args)
#define new() media_player_stream_new()
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static void (* const set_stream) (MediaPlayerStream * self, Bonobo_Media_Stream media_stream) = media_player_stream_set_stream;
static void (* const update) (MediaPlayerStream * self) = media_player_stream_update;
static void (* const update_length) (MediaPlayerStream * self) = media_player_stream_update_length;
static void (* const register_listener) (MediaPlayerStream * self) = media_player_stream_register_listener;
static void (* const listener_cb) (BonoboListener * listener, char * event_name, BonoboArg * event_data, CORBA_Environment * ev, Self * self) = media_player_stream_listener_cb;
static void (* const position_cb) (MediaPlayerStream * self, int pos) = media_player_stream_position_cb;
static gint (* const scale_press_cb) (GtkObject * caller, GdkEvent * event, Self * self) = media_player_stream_scale_press_cb;
static gint (* const scale_release_cb) (GtkObject * caller, GdkEvent * event, Self * self) = media_player_stream_scale_release_cb;
static void (* const seek) (MediaPlayerStream * self, gint pos) = media_player_stream_seek;
static void (* const play_cb) (GtkObject * caller, Self * self) = media_player_stream_play_cb;
static void (* const pause_cb) (GtkObject * caller, Self * self) = media_player_stream_pause_cb;
static void (* const stop_cb) (GtkObject * caller, Self * self) = media_player_stream_stop_cb;
static void (* const construct) (MediaPlayerStream * self) = media_player_stream_construct;
static GtkWidget * (* const new) (void) = media_player_stream_new;

/* a macro for creating a new object of our type */
#define GET_NEW ((MediaPlayerStream *)gtk_type_new(media_player_stream_get_type()))


static void
___destroy(GtkObject *obj_self)
{
#define __GOB_FUNCTION__ "Media:Player:Stream::destroy"
	MediaPlayerStream *self = MEDIA_PLAYER_STREAM (obj_self);
	if(GTK_OBJECT_CLASS(parent_class)->destroy) \
		(* GTK_OBJECT_CLASS(parent_class)->destroy)(obj_self);
#define VAR (self->_priv->stream)
	{
#line 51 "media-player-stream.gob"
	
	    CORBA_Environment ev;
	    
	    if (VAR != CORBA_OBJECT_NIL)
	    {
		CORBA_exception_init (&ev);
		Bonobo_Unknown_unref (VAR, &ev);
				CORBA_exception_free (&ev);
	    }
	}
#line 176 "media-player-stream.c"
	memset(&VAR, 0, sizeof(VAR));
#undef VAR
#define VAR (self->_priv->listener)
	{
#line 63 "media-player-stream.gob"
	
	if (VAR)
	    bonobo_object_unref (BONOBO_OBJECT (VAR));
    }
#line 186 "media-player-stream.c"
	memset(&VAR, 0, sizeof(VAR));
#undef VAR
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__


#ifdef G_OBJECT_CLASS
static void
___finalize(GObject *obj_self)
#else /* !G_OBJECT_CLASS */
static void
___finalize(GtkObject *obj_self)
#endif /* G_OBJECT_CLASS */
{
#define __GOB_FUNCTION__ "Media:Player:Stream::finalize"
	MediaPlayerStream *self = MEDIA_PLAYER_STREAM (obj_self);
	gpointer priv = self->_priv;
#ifdef G_OBJECT_CLASS
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#else /* !G_OBJECT_CLASS */
	if(GTK_OBJECT_CLASS(parent_class)->finalize) \
		(* GTK_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#endif /* G_OBJECT_CLASS */
	g_free(priv);
}
#undef __GOB_FUNCTION__

static void 
media_player_stream_init (MediaPlayerStream * o)
{
#define __GOB_FUNCTION__ "Media:Player:Stream::init"
	o->_priv = g_new0 (MediaPlayerStreamPrivate, 1);
#line 33 "media-player-stream.gob"
	o->_priv->playing = FALSE;
#line 224 "media-player-stream.c"
#line 51 "media-player-stream.gob"
	o->_priv->stream = CORBA_OBJECT_NIL;
#line 227 "media-player-stream.c"
#line 63 "media-player-stream.gob"
	o->_priv->listener = 0;
#line 230 "media-player-stream.c"
#line 200 "media-player-stream.gob"
	o->_priv->scale_dragging = FALSE;
#line 233 "media-player-stream.c"
	return;
	o = NULL;
}
#undef __GOB_FUNCTION__
static void 
media_player_stream_class_init (MediaPlayerStreamClass * c)
{
#define __GOB_FUNCTION__ "Media:Player:Stream::class_init"
	GtkObjectClass *gtk_object_class = (GtkObjectClass*) c;
#ifdef G_OBJECT_CLASS
	GObjectClass *g_object_class = (GObjectClass*) c;
#endif /* G_OBJECT_CLASS */

	parent_class = gtk_type_class (gtk_vbox_get_type ());

	gtk_object_class->destroy = ___destroy;
#ifdef G_OBJECT_CLASS
	g_object_class->finalize = ___finalize;
#else /* !G_OBJECT_CLASS */
	gtk_object_class->finalize = ___finalize;
#endif /* G_OBJECT_CLASS */
	return;
	c = NULL;
	gtk_object_class = NULL;
#ifdef G_OBJECT_CLASS
	g_object_class = NULL;
#endif /* G_OBJECT_CLASS */
}
#undef __GOB_FUNCTION__



#line 71 "media-player-stream.gob"
void 
media_player_stream_set_stream (MediaPlayerStream * self, Bonobo_Media_Stream media_stream)
#line 269 "media-player-stream.c"
{
#define __GOB_FUNCTION__ "Media:Player:Stream::set_stream"
#line 71 "media-player-stream.gob"
	g_return_if_fail (self != NULL);
#line 71 "media-player-stream.gob"
	g_return_if_fail (MEDIA_IS_PLAYER_STREAM (self));
#line 276 "media-player-stream.c"
{
#line 72 "media-player-stream.gob"
	
	    CORBA_Environment ev;
	    
	    if (self->_priv->stream != CORBA_OBJECT_NIL)
	    {
		CORBA_exception_init (&ev);
		Bonobo_Unknown_unref (self->_priv->stream, &ev);
		CORBA_exception_free (&ev);
	    }
	    
	    self->_priv->stream = media_stream;
	    
	    if (media_stream != CORBA_OBJECT_NIL)
	    {
		CORBA_exception_init (&ev);
		Bonobo_Unknown_ref (media_stream, &ev);
		CORBA_exception_free (&ev);
	    }
	    
	    update (self);
	}}
#line 300 "media-player-stream.c"
#undef __GOB_FUNCTION__

#line 100 "media-player-stream.gob"
static void 
media_player_stream_update (MediaPlayerStream * self)
#line 306 "media-player-stream.c"
{
#define __GOB_FUNCTION__ "Media:Player:Stream::update"
#line 100 "media-player-stream.gob"
	g_return_if_fail (self != NULL);
#line 100 "media-player-stream.gob"
	g_return_if_fail (MEDIA_IS_PLAYER_STREAM (self));
#line 313 "media-player-stream.c"
{
#line 101 "media-player-stream.gob"
	
	    Bonobo_Media_Stream stream = self->_priv->stream;
	    
	    if (stream == CORBA_OBJECT_NIL)
	    {
		gtk_widget_set_sensitive (self->_priv->scale, FALSE);
		gtk_widget_set_sensitive (self->_priv->play_btn, FALSE);
		gtk_widget_set_sensitive (self->_priv->pause_btn, FALSE);
		gtk_widget_set_sensitive (self->_priv->stop_btn, FALSE);
		
		return;
	    }
	    
	    /* Do updating here */
	    
	    /* Enable controls */
	    gtk_widget_set_sensitive (self->_priv->play_btn, TRUE);
	    gtk_widget_set_sensitive (self->_priv->pause_btn, TRUE);
	    gtk_widget_set_sensitive (self->_priv->stop_btn, TRUE);
	    
	    update_length (self);
	    
	    register_listener (self);

	    {
		CORBA_Environment ev;
		Bonobo_Media_Video video;
		Bonobo_Control control;
		GtkWidget *window, *widget;
		
		CORBA_exception_init (&ev);
		video = Bonobo_Unknown_queryInterface (stream,
						       "IDL:Bonobo/Media/Video:1.0", &ev);
		control = Bonobo_Media_Video_getVideoControl (video, &ev);
		CORBA_exception_free (&ev);

		window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
		widget = bonobo_widget_new_control_from_objref (
		    control, 0);
		gtk_widget_show (widget);
		gtk_container_add (GTK_CONTAINER (window), widget);
		gtk_widget_show (window);
	    }
	}}
#line 360 "media-player-stream.c"
#undef __GOB_FUNCTION__

#line 146 "media-player-stream.gob"
static void 
media_player_stream_update_length (MediaPlayerStream * self)
#line 366 "media-player-stream.c"
{
#define __GOB_FUNCTION__ "Media:Player:Stream::update_length"
#line 146 "media-player-stream.gob"
	g_return_if_fail (self != NULL);
#line 146 "media-player-stream.gob"
	g_return_if_fail (MEDIA_IS_PLAYER_STREAM (self));
#line 373 "media-player-stream.c"
{
#line 147 "media-player-stream.gob"
	
		CORBA_Environment   ev;
		Bonobo_Media_Stream stream = self->_priv->stream;
		int length;
		
		/* Get stream length */
		CORBA_exception_init (&ev);
		length = Bonobo_Media_Stream_getLength (stream, &ev);
		if (ev._major == CORBA_USER_EXCEPTION &&
		    !strcmp (ev._repo_id, ex_Bonobo_Media_Stream_NotSupported))
		    length = 0;
		CORBA_exception_free (&ev);
		
		self->_priv->scale_adj->upper          = length;
//                        self->_priv->scale_adj->step_increment = 1.0 * ratio;
//                        self->_priv->scale_adj->page_increment = 10.0 * ratio;
		gtk_adjustment_changed (self->_priv->scale_adj);
		gtk_widget_set_sensitive (self->_priv->scale,
					  length != 0);
	    }}
#line 396 "media-player-stream.c"
#undef __GOB_FUNCTION__

#line 168 "media-player-stream.gob"
static void 
media_player_stream_register_listener (MediaPlayerStream * self)
#line 402 "media-player-stream.c"
{
#define __GOB_FUNCTION__ "Media:Player:Stream::register_listener"
#line 168 "media-player-stream.gob"
	g_return_if_fail (self != NULL);
#line 168 "media-player-stream.gob"
	g_return_if_fail (MEDIA_IS_PLAYER_STREAM (self));
#line 409 "media-player-stream.c"
{
#line 169 "media-player-stream.gob"
	
		CORBA_Environment ev;
		Bonobo_EventSource  event_source;
		Bonobo_Media_Stream stream = self->_priv->stream;
		
		/* Set up the listener */
		CORBA_exception_init (&ev);
		event_source = Bonobo_Unknown_queryInterface (
		    stream, "IDL:Bonobo/EventSource:1.0",
		    &ev);
		if (ev._major == CORBA_NO_EXCEPTION &&
		    event_source != CORBA_OBJECT_NIL)
		{
		    Bonobo_Listener corba_listener;
		    
		    corba_listener = bonobo_object_corba_objref
			(BONOBO_OBJECT (self->_priv->listener));                                
		    Bonobo_EventSource_addListener (event_source, corba_listener, &ev);
		    
		    Bonobo_Unknown_unref (event_source, &ev);
		}
		
		CORBA_exception_free (&ev);
	    }}
#line 436 "media-player-stream.c"
#undef __GOB_FUNCTION__

#line 194 "media-player-stream.gob"
static void 
media_player_stream_listener_cb (BonoboListener * listener, char * event_name, BonoboArg * event_data, CORBA_Environment * ev, Self * self)
#line 442 "media-player-stream.c"
{
#define __GOB_FUNCTION__ "Media:Player:Stream::listener_cb"
#line 194 "media-player-stream.gob"
	g_return_if_fail (self != NULL);
#line 194 "media-player-stream.gob"
	g_return_if_fail (IS_SELF (self));
#line 449 "media-player-stream.c"
{
#line 200 "media-player-stream.gob"
	
		if (!strcmp (event_name,
			     bonobo_event_make_name ("Bonobo/Media/Stream",
						     "position_notify", 0)))
		{
		    position_cb (self,
				 BONOBO_ARG_GET_LONG (event_data));
		}
		
		if (!strcmp (event_name,
			     bonobo_event_make_name ("Bonobo/Media/Stream",
						     "play_notify", 0)))
		{
		    self->_priv->playing = TRUE;
		}
		if (!strcmp (event_name,
			     bonobo_event_make_name ("Bonobo/Media/Stream",
						     "stop_notify", 0)))
		{
		    self->_priv->playing = FALSE;
		}
	    }}
#line 474 "media-player-stream.c"
#undef __GOB_FUNCTION__

#line 225 "media-player-stream.gob"
static void 
media_player_stream_position_cb (MediaPlayerStream * self, int pos)
#line 480 "media-player-stream.c"
{
#define __GOB_FUNCTION__ "Media:Player:Stream::position_cb"
#line 225 "media-player-stream.gob"
	g_return_if_fail (self != NULL);
#line 225 "media-player-stream.gob"
	g_return_if_fail (MEDIA_IS_PLAYER_STREAM (self));
#line 487 "media-player-stream.c"
{
#line 226 "media-player-stream.gob"
	
		if (!self->_priv->scale_dragging)
		    gtk_adjustment_set_value (self->_priv->scale_adj, pos);
	    }}
#line 494 "media-player-stream.c"
#undef __GOB_FUNCTION__

#line 231 "media-player-stream.gob"
static gint 
media_player_stream_scale_press_cb (GtkObject * caller, GdkEvent * event, Self * self)
#line 500 "media-player-stream.c"
{
#define __GOB_FUNCTION__ "Media:Player:Stream::scale_press_cb"
#line 231 "media-player-stream.gob"
	g_return_val_if_fail (self != NULL, (gint )0);
#line 231 "media-player-stream.gob"
	g_return_val_if_fail (IS_SELF (self), (gint )0);
#line 507 "media-player-stream.c"
{
#line 234 "media-player-stream.gob"
	
		self->_priv->scale_dragging = TRUE;
		return FALSE;
	    }}
#line 514 "media-player-stream.c"
#undef __GOB_FUNCTION__

#line 239 "media-player-stream.gob"
static gint 
media_player_stream_scale_release_cb (GtkObject * caller, GdkEvent * event, Self * self)
#line 520 "media-player-stream.c"
{
#define __GOB_FUNCTION__ "Media:Player:Stream::scale_release_cb"
#line 239 "media-player-stream.gob"
	g_return_val_if_fail (self != NULL, (gint )0);
#line 239 "media-player-stream.gob"
	g_return_val_if_fail (IS_SELF (self), (gint )0);
#line 527 "media-player-stream.c"
{
#line 242 "media-player-stream.gob"
	
		int pos;
		
		self->_priv->scale_dragging = FALSE;
		
		pos = self->_priv->scale_adj->value;
		seek (self, pos);
		
		return FALSE;
	    }}
#line 540 "media-player-stream.c"
#undef __GOB_FUNCTION__

#line 253 "media-player-stream.gob"
static void 
media_player_stream_seek (MediaPlayerStream * self, gint pos)
#line 546 "media-player-stream.c"
{
#define __GOB_FUNCTION__ "Media:Player:Stream::seek"
#line 253 "media-player-stream.gob"
	g_return_if_fail (self != NULL);
#line 253 "media-player-stream.gob"
	g_return_if_fail (MEDIA_IS_PLAYER_STREAM (self));
#line 553 "media-player-stream.c"
{
#line 254 "media-player-stream.gob"
	
		CORBA_Environment ev;
		Bonobo_Media_Stream media_stream = self->_priv->stream;
		
		g_return_if_fail (media_stream != CORBA_OBJECT_NIL);
		
		CORBA_exception_init (&ev);
		Bonobo_Media_Stream_seek (media_stream, pos, &ev);
		CORBA_exception_free (&ev);
	    }}
#line 566 "media-player-stream.c"
#undef __GOB_FUNCTION__

#line 265 "media-player-stream.gob"
static void 
media_player_stream_play_cb (GtkObject * caller, Self * self)
#line 572 "media-player-stream.c"
{
#define __GOB_FUNCTION__ "Media:Player:Stream::play_cb"
#line 265 "media-player-stream.gob"
	g_return_if_fail (self != NULL);
#line 265 "media-player-stream.gob"
	g_return_if_fail (IS_SELF (self));
#line 579 "media-player-stream.c"
{
#line 267 "media-player-stream.gob"
	
		CORBA_Environment ev;
		Bonobo_Media_Stream media_stream = self->_priv->stream;
		
		g_return_if_fail (media_stream != CORBA_OBJECT_NIL);
		
		if (self->_priv->playing)
		    seek (self, 0);
		
		CORBA_exception_init (&ev);
		Bonobo_Media_Stream_play (media_stream, &ev);
		CORBA_exception_free (&ev);
	    }}
#line 595 "media-player-stream.c"
#undef __GOB_FUNCTION__

#line 281 "media-player-stream.gob"
static void 
media_player_stream_pause_cb (GtkObject * caller, Self * self)
#line 601 "media-player-stream.c"
{
#define __GOB_FUNCTION__ "Media:Player:Stream::pause_cb"
#line 281 "media-player-stream.gob"
	g_return_if_fail (self != NULL);
#line 281 "media-player-stream.gob"
	g_return_if_fail (IS_SELF (self));
#line 608 "media-player-stream.c"
{
#line 283 "media-player-stream.gob"
	
		CORBA_Environment ev;
		Bonobo_Media_Stream media_stream = self->_priv->stream;
		
		g_return_if_fail (media_stream != CORBA_OBJECT_NIL);
		
		if (self->_priv->playing)
		{
		    CORBA_exception_init (&ev);
		    Bonobo_Media_Stream_stop (media_stream, &ev);
		    CORBA_exception_free (&ev);
		} else {
		    play_cb (caller, self);
		}
	    }}
#line 626 "media-player-stream.c"
#undef __GOB_FUNCTION__

#line 299 "media-player-stream.gob"
static void 
media_player_stream_stop_cb (GtkObject * caller, Self * self)
#line 632 "media-player-stream.c"
{
#define __GOB_FUNCTION__ "Media:Player:Stream::stop_cb"
#line 299 "media-player-stream.gob"
	g_return_if_fail (self != NULL);
#line 299 "media-player-stream.gob"
	g_return_if_fail (IS_SELF (self));
#line 639 "media-player-stream.c"
{
#line 301 "media-player-stream.gob"
	
		CORBA_Environment ev;
		Bonobo_Media_Stream media_stream = self->_priv->stream;
		
		g_return_if_fail (media_stream != CORBA_OBJECT_NIL);
		
		CORBA_exception_init (&ev);
		Bonobo_Media_Stream_stop (media_stream, &ev);
		CORBA_exception_free (&ev);

		seek (self, 0);
	    }}
#line 654 "media-player-stream.c"
#undef __GOB_FUNCTION__

#line 314 "media-player-stream.gob"
void 
media_player_stream_construct (MediaPlayerStream * self)
#line 660 "media-player-stream.c"
{
#define __GOB_FUNCTION__ "Media:Player:Stream::construct"
#line 314 "media-player-stream.gob"
	g_return_if_fail (self != NULL);
#line 314 "media-player-stream.gob"
	g_return_if_fail (MEDIA_IS_PLAYER_STREAM (self));
#line 667 "media-player-stream.c"
{
#line 315 "media-player-stream.gob"
	
		GtkWidget     *hbox;
		GtkWidget     *button, *pixmap, *scale;
		GtkAdjustment *adj;
		
		/* Setting up an EventListener */
		self->_priv->listener = bonobo_listener_new (
		    (BonoboListenerCallbackFn)listener_cb, self);

		/* The position scale */
		adj = GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 0, 0, 0, 0));
		scale = gtk_hscale_new (adj);
		gtk_widget_set_sensitive (scale, FALSE);
		gtk_scale_set_digits (GTK_SCALE (scale), 0);
		gtk_scale_set_draw_value (GTK_SCALE (scale), FALSE);
		gtk_widget_set_usize (scale, 150, 0);
		
		gtk_signal_connect (GTK_OBJECT (scale), "button_press_event",
				    GTK_SIGNAL_FUNC (scale_press_cb), self);
		gtk_signal_connect (GTK_OBJECT (scale), "button_release_event",
				    GTK_SIGNAL_FUNC (scale_release_cb), self);
		self->_priv->scale_adj = adj;
		self->_priv->scale     = scale;

		gtk_widget_set_usize (scale, 300, 0);
		gtk_widget_show (scale);
		gtk_box_pack_start (GTK_BOX (self), scale,
				    FALSE, FALSE, 0);
		
		/* The HBox for holding the buttons */
		hbox = gtk_hbox_new (FALSE, 0);
		gtk_box_set_spacing (GTK_BOX (hbox), 0);
		
		gtk_box_pack_start (GTK_BOX (self), hbox,
				    FALSE, FALSE, 0);
		
		/* The Play button */
		button = gtk_button_new ();
		pixmap = gnome_pixmap_new_from_xpm_d (play_xpm);
		gtk_container_add (GTK_CONTAINER (button), pixmap);
		gtk_signal_connect (GTK_OBJECT (button), "clicked",
				    GTK_SIGNAL_FUNC (play_cb), self);
		gtk_widget_set_sensitive (button, FALSE);
		if (!gnome_preferences_get_toolbar_relief_btn ())
		    gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);
		gtk_widget_show (button);
		gtk_box_pack_start (GTK_BOX (hbox), button,
				    FALSE, FALSE, 0);
		self->_priv->play_btn = button;
		
		/* The Pause button */
		button = gtk_button_new ();
		pixmap = gnome_pixmap_new_from_xpm_d (pause_xpm);
		gtk_container_add (GTK_CONTAINER (button), pixmap);
		gtk_signal_connect (GTK_OBJECT (button), "clicked",
				    GTK_SIGNAL_FUNC (pause_cb), self);
		gtk_widget_set_sensitive (button, FALSE);
		if (!gnome_preferences_get_toolbar_relief_btn ())
		    gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);
		gtk_widget_show (button);
		gtk_box_pack_start (GTK_BOX (hbox), button,
				    FALSE, FALSE, 0);
		self->_priv->pause_btn = button;

		/* The Stop button */
		button = gtk_button_new ();
		pixmap = gnome_pixmap_new_from_xpm_d (stop_xpm);
		gtk_container_add (GTK_CONTAINER (button), pixmap);
		gtk_signal_connect (GTK_OBJECT (button), "clicked",
				    GTK_SIGNAL_FUNC (stop_cb), self);
		gtk_widget_set_sensitive (button, FALSE);
		if (!gnome_preferences_get_toolbar_relief_btn ())
		    gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);
		gtk_widget_show (button);
		gtk_box_pack_start (GTK_BOX (hbox), button,
				    FALSE, FALSE, 0);
		self->_priv->stop_btn = button;
		
	    }}
#line 749 "media-player-stream.c"
#undef __GOB_FUNCTION__

#line 395 "media-player-stream.gob"
GtkWidget * 
media_player_stream_new (void)
#line 755 "media-player-stream.c"
{
#define __GOB_FUNCTION__ "Media:Player:Stream::new"
{
#line 396 "media-player-stream.gob"
	
		Self *self;
		
		self = GET_NEW;
		construct (self);
		
		return GTK_WIDGET (self);
	    }}
#line 768 "media-player-stream.c"
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___media_player_stream_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))set_stream)();
	((void (*)(void))update)();
	((void (*)(void))update_length)();
	((void (*)(void))register_listener)();
	((void (*)(void))listener_cb)();
	((void (*)(void))position_cb)();
	((void (*)(void))scale_press_cb)();
	((void (*)(void))scale_release_cb)();
	((void (*)(void))seek)();
	((void (*)(void))play_cb)();
	((void (*)(void))pause_cb)();
	((void (*)(void))stop_cb)();
	((void (*)(void))construct)();
	((void (*)(void))new)();
	___media_player_stream_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

