/* Generated by GOB (v1.0.9) on Tue May  1 13:49:02 2001
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 3 "media-player-control.gob"

/* $Id: media-player-control.gob,v 1.6 2001/01/22 17:24:43 cactus Exp $
 *
 * media-player-control: A Bonobo control implementing a simple user
 * interface for playback of Bonobo media streams
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (c) 2000-2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 */

#line 34 "media-player-control.c"
#define GOB_VERSION_MAJOR 1
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 9

#include <string.h> /* memset() */

#include "media-player-control.h"

#include "media-player-control-private.h"


#line 34 "media-player-control.gob"

#include <libgnome/libgnome.h>
#include <liboaf/liboaf.h>

#line 51 "media-player-control.c"
/* self casting macros */
#define SELF(x) MEDIA_PLAYER_CONTROL(x)
#define SELF_CONST(x) MEDIA_PLAYER_CONTROL_CONST(x)
#define IS_SELF(x) MEDIA_IS_PLAYER_CONTROL(x)
#define SELF_CLASS(x) MEDIA_PLAYER_CONTROL_CLASS(x)

#define SELF_GET_CLASS(x) MEDIA_PLAYER_CONTROL_GET_CLASS(x)

/* self typedefs */
typedef MediaPlayerControl Self;
typedef MediaPlayerControlClass SelfClass;

/* GTK_CLASS_TYPE for 1.2<->1.3/2.0 GTK+ compatibility */
#ifndef GTK_CLASS_TYPE
#define GTK_CLASS_TYPE(x) (GTK_OBJECT_CLASS(x)->type)
#endif /* GTK_CLASS_TYPE */

/* here are local prototypes */
static void media_player_control_init (MediaPlayerControl * o) G_GNUC_UNUSED;
static void media_player_control_class_init (MediaPlayerControlClass * c) G_GNUC_UNUSED;
static void media_player_control_load_media_stream_from_stream (Bonobo_Media_Stream media_stream, Bonobo_Stream stream, gchar * mime_type) G_GNUC_UNUSED;
static Bonobo_Media_Stream media_player_control_media_stream_from_stream (Bonobo_Stream stream, gchar * mime_type) G_GNUC_UNUSED;
static void media_player_control_set_stream (MediaPlayerControl * self, Bonobo_Media_Stream media_stream) G_GNUC_UNUSED;
static gint media_player_control_PersistFile_load (BonoboPersistFile * pf, const CORBA_char * filename, CORBA_Environment * ev, MediaPlayerControl * self) G_GNUC_UNUSED;
static gint media_player_control_PersistStream_load (BonoboPersistStream * ps, const Bonobo_Stream stream, CORBA_char * type, MediaPlayerControl * self, CORBA_Environment * ev) G_GNUC_UNUSED;
static Bonobo_Unknown media_player_control_corba_object_create (BonoboObject * object) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static BonoboObjectClass *parent_class = NULL;

GtkType
media_player_control_get_type (void)
{
	static GtkType type = 0;

	if (type == 0) {
		static const GtkTypeInfo info = {
			"MediaPlayerControl",
			sizeof (MediaPlayerControl),
			sizeof (MediaPlayerControlClass),
			(GtkClassInitFunc) media_player_control_class_init,
			(GtkObjectInitFunc) media_player_control_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		type = gtk_type_unique (bonobo_object_get_type(), &info);
	}

	return type;
}

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define load_media_stream_from_stream(args...) media_player_control_load_media_stream_from_stream(args)
#define media_stream_from_stream(args...) media_player_control_media_stream_from_stream(args)
#define set_stream(args...) media_player_control_set_stream(args)
#define PersistFile_load(args...) media_player_control_PersistFile_load(args)
#define PersistStream_load(args...) media_player_control_PersistStream_load(args)
#define corba_object_create(args...) media_player_control_corba_object_create(args)
#define construct(args...) media_player_control_construct(args)
#define new() media_player_control_new()
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static void (* const load_media_stream_from_stream) (Bonobo_Media_Stream media_stream, Bonobo_Stream stream, gchar * mime_type) = media_player_control_load_media_stream_from_stream;
static Bonobo_Media_Stream (* const media_stream_from_stream) (Bonobo_Stream stream, gchar * mime_type) = media_player_control_media_stream_from_stream;
static void (* const set_stream) (MediaPlayerControl * self, Bonobo_Media_Stream media_stream) = media_player_control_set_stream;
static gint (* const PersistFile_load) (BonoboPersistFile * pf, const CORBA_char * filename, CORBA_Environment * ev, MediaPlayerControl * self) = media_player_control_PersistFile_load;
static gint (* const PersistStream_load) (BonoboPersistStream * ps, const Bonobo_Stream stream, CORBA_char * type, MediaPlayerControl * self, CORBA_Environment * ev) = media_player_control_PersistStream_load;
static Bonobo_Unknown (* const corba_object_create) (BonoboObject * object) = media_player_control_corba_object_create;
static void (* const construct) (MediaPlayerControl * self) = media_player_control_construct;
static BonoboObject * (* const new) (void) = media_player_control_new;

/* a macro for creating a new object of our type */
#define GET_NEW ((MediaPlayerControl *)gtk_type_new(media_player_control_get_type()))


static void
___destroy(GtkObject *obj_self)
{
#define __GOB_FUNCTION__ "Media:Player:Control::destroy"
	MediaPlayerControl *self = MEDIA_PLAYER_CONTROL (obj_self);
	if(GTK_OBJECT_CLASS(parent_class)->destroy) \
		(* GTK_OBJECT_CLASS(parent_class)->destroy)(obj_self);
#define VAR (self->_priv->stream)
	{
#line 44 "media-player-control.gob"
	
			CORBA_Environment ev;

			if (VAR != CORBA_OBJECT_NIL)
			{
				CORBA_exception_init (&ev);
				Bonobo_Unknown_unref (VAR, &ev);
				CORBA_exception_free (&ev);
			}
		}
#line 151 "media-player-control.c"
	memset(&VAR, 0, sizeof(VAR));
#undef VAR
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__


#ifdef G_OBJECT_CLASS
static void
___finalize(GObject *obj_self)
#else /* !G_OBJECT_CLASS */
static void
___finalize(GtkObject *obj_self)
#endif /* G_OBJECT_CLASS */
{
#define __GOB_FUNCTION__ "Media:Player:Control::finalize"
	MediaPlayerControl *self = MEDIA_PLAYER_CONTROL (obj_self);
	gpointer priv = self->_priv;
#ifdef G_OBJECT_CLASS
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#else /* !G_OBJECT_CLASS */
	if(GTK_OBJECT_CLASS(parent_class)->finalize) \
		(* GTK_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#endif /* G_OBJECT_CLASS */
	g_free(priv);
}
#undef __GOB_FUNCTION__

static void 
media_player_control_init (MediaPlayerControl * o)
{
#define __GOB_FUNCTION__ "Media:Player:Control::init"
	o->_priv = g_new0 (MediaPlayerControlPrivate, 1);
#line 44 "media-player-control.gob"
	o->_priv->stream = CORBA_OBJECT_NIL;
#line 189 "media-player-control.c"
	return;
	o = NULL;
}
#undef __GOB_FUNCTION__
static void 
media_player_control_class_init (MediaPlayerControlClass * c)
{
#define __GOB_FUNCTION__ "Media:Player:Control::class_init"
	GtkObjectClass *gtk_object_class = (GtkObjectClass*) c;
#ifdef G_OBJECT_CLASS
	GObjectClass *g_object_class = (GObjectClass*) c;
#endif /* G_OBJECT_CLASS */

	parent_class = gtk_type_class (bonobo_object_get_type ());

	gtk_object_class->destroy = ___destroy;
#ifdef G_OBJECT_CLASS
	g_object_class->finalize = ___finalize;
#else /* !G_OBJECT_CLASS */
	gtk_object_class->finalize = ___finalize;
#endif /* G_OBJECT_CLASS */
	return;
	c = NULL;
	gtk_object_class = NULL;
#ifdef G_OBJECT_CLASS
	g_object_class = NULL;
#endif /* G_OBJECT_CLASS */
}
#undef __GOB_FUNCTION__



#line 55 "media-player-control.gob"
static void 
media_player_control_load_media_stream_from_stream (Bonobo_Media_Stream media_stream, Bonobo_Stream stream, gchar * mime_type)
#line 225 "media-player-control.c"
{
#define __GOB_FUNCTION__ "Media:Player:Control::load_media_stream_from_stream"
{
#line 58 "media-player-control.gob"
	
			Bonobo_PersistStream   ps;
			CORBA_Environment      ev;
			
			CORBA_exception_init (&ev);
			ps = Bonobo_Unknown_queryInterface
				(media_stream, "IDL:Bonobo/PersistStream:1.0", &ev);
			Bonobo_PersistStream_load (ps, stream, mime_type, &ev);
			Bonobo_Unknown_unref (ps, &ev);
			CORBA_exception_free (&ev);
		}}
#line 241 "media-player-control.c"
#undef __GOB_FUNCTION__

#line 70 "media-player-control.gob"
static Bonobo_Media_Stream 
media_player_control_media_stream_from_stream (Bonobo_Stream stream, gchar * mime_type)
#line 247 "media-player-control.c"
{
#define __GOB_FUNCTION__ "Media:Player:Control::media_stream_from_stream"
{
#line 72 "media-player-control.gob"
	
			Bonobo_Unknown       object;
			Bonobo_Media_Stream  media_stream;
			gchar               *oaf_query;
			CORBA_Environment    ev;
			OAF_ActivationID     oaf_id;
			
			oaf_query = g_strdup_printf ("repo_ids.has('%s') AND "
						     "repo_ids.has('%s') AND "
						     "bonobo:supported_mime_types.has('%s')",
						     "IDL:Bonobo/Media/Stream:1.0",
						     "IDL:Bonobo/PersistStream:1.0",
						     mime_type);
			
			CORBA_exception_init (&ev);
			object = oaf_activate (oaf_query, NULL, 0, &oaf_id, &ev); // REF 1
			CORBA_exception_free (&ev);
			g_free (oaf_query);
			
			if (object == CORBA_OBJECT_NIL)
			{
				g_warning ("Handler for `%s' not found", mime_type);
				return CORBA_OBJECT_NIL;
			}
			
			CORBA_exception_init (&ev);
			media_stream = Bonobo_Unknown_queryInterface
				(object, "IDL:Bonobo/Media/Stream:1.0", &ev);
			CORBA_exception_free (&ev);
			
			CORBA_exception_init (&ev);
			Bonobo_Unknown_unref (object, &ev);
			CORBA_exception_free (&ev);

			load_media_stream_from_stream (media_stream,
						       stream, mime_type);
			
			return media_stream;
		}}
#line 291 "media-player-control.c"
#undef __GOB_FUNCTION__

#line 112 "media-player-control.gob"
static void 
media_player_control_set_stream (MediaPlayerControl * self, Bonobo_Media_Stream media_stream)
#line 297 "media-player-control.c"
{
#define __GOB_FUNCTION__ "Media:Player:Control::set_stream"
#line 112 "media-player-control.gob"
	g_return_if_fail (self != NULL);
#line 112 "media-player-control.gob"
	g_return_if_fail (MEDIA_IS_PLAYER_CONTROL (self));
#line 304 "media-player-control.c"
{
#line 113 "media-player-control.gob"
	
			CORBA_Environment ev;
			
			if (self->_priv->stream != CORBA_OBJECT_NIL)
			{
				CORBA_exception_init (&ev);
				Bonobo_Unknown_unref (self->_priv->stream, &ev);
				CORBA_exception_free (&ev);
				bonobo_media_control_release_stream (self->_priv->media_control);
				self->_priv->stream = CORBA_OBJECT_NIL;
			}
			
			bonobo_media_control_set_stream (
				self->_priv->media_control,
				media_stream);

			self->_priv->stream = media_stream;			
		}}
#line 325 "media-player-control.c"
#undef __GOB_FUNCTION__

#line 132 "media-player-control.gob"
static gint 
media_player_control_PersistFile_load (BonoboPersistFile * pf, const CORBA_char * filename, CORBA_Environment * ev, MediaPlayerControl * self)
#line 331 "media-player-control.c"
{
#define __GOB_FUNCTION__ "Media:Player:Control::PersistFile_load"
#line 132 "media-player-control.gob"
	g_return_val_if_fail (self != NULL, (gint )0);
#line 132 "media-player-control.gob"
	g_return_val_if_fail (MEDIA_IS_PLAYER_CONTROL (self), (gint )0);
#line 338 "media-player-control.c"
{
#line 136 "media-player-control.gob"
	
			Bonobo_Media_Stream media_stream;
			CORBA_Environment  my_ev;
			
			CORBA_exception_init (&my_ev);
			media_stream = bonobo_get_object
				(filename, "IDL:Bonobo/Media/Stream:1.0", &my_ev);
			CORBA_exception_free (&my_ev);
			
			if (media_stream == CORBA_OBJECT_NIL)
			{
				/* Try again with the "file:" moniker */
				gchar *moniker_str = g_strdup_printf ("file:%s", filename);
				
				CORBA_exception_init (&my_ev);
				media_stream = bonobo_get_object
					(moniker_str, "IDL:Bonobo/Media/Stream:1.0", &my_ev);
				CORBA_exception_free (&my_ev);
				
				g_free (moniker_str);
			}
			
			if (media_stream == CORBA_OBJECT_NIL)
			{
				CORBA_exception_set (ev, CORBA_USER_EXCEPTION,
						     ex_Bonobo_Persist_WrongDataType, NULL);
				
				return 0;
			}

			set_stream (self, media_stream);

			return 0;
		}}
#line 375 "media-player-control.c"
#undef __GOB_FUNCTION__

#line 171 "media-player-control.gob"
static gint 
media_player_control_PersistStream_load (BonoboPersistStream * ps, const Bonobo_Stream stream, CORBA_char * type, MediaPlayerControl * self, CORBA_Environment * ev)
#line 381 "media-player-control.c"
{
#define __GOB_FUNCTION__ "Media:Player:Control::PersistStream_load"
#line 171 "media-player-control.gob"
	g_return_val_if_fail (self != NULL, (gint )0);
#line 171 "media-player-control.gob"
	g_return_val_if_fail (MEDIA_IS_PLAYER_CONTROL (self), (gint )0);
#line 388 "media-player-control.c"
{
#line 176 "media-player-control.gob"
	
			Bonobo_Media_Stream media_stream;

			media_stream = media_stream_from_stream (stream, type);

			if (media_stream == CORBA_OBJECT_NIL)
			{
				CORBA_exception_set (ev, CORBA_USER_EXCEPTION,
						     ex_Bonobo_Persist_WrongDataType, NULL);
				
				return 0;
			}

			set_stream (self, media_stream);

			return 0;
		}}
#line 408 "media-player-control.c"
#undef __GOB_FUNCTION__

#line 194 "media-player-control.gob"
static Bonobo_Unknown 
media_player_control_corba_object_create (BonoboObject * object)
#line 414 "media-player-control.c"
{
#define __GOB_FUNCTION__ "Media:Player:Control::corba_object_create"
{
#line 195 "media-player-control.gob"
	
			POA_Bonobo_Unknown__vepv vepv;
			POA_Bonobo_Unknown *servant;
			CORBA_Environment ev;

			vepv.Bonobo_Unknown_epv = bonobo_object_get_epv ();
			
			servant = (POA_Bonobo_Unknown *) g_new0 (BonoboObjectServant, 1);
			servant->vepv = &vepv;
			
			CORBA_exception_init (&ev);
			POA_Bonobo_Unknown__init ((PortableServer_Servant) servant, &ev);
			if (BONOBO_EX (&ev)){
				g_free (servant);
				CORBA_exception_free (&ev);
				return CORBA_OBJECT_NIL;
			}
			
			CORBA_exception_free (&ev);
			return (Bonobo_Unknown) bonobo_object_activate_servant (object, servant);
		}}
#line 440 "media-player-control.c"
#undef __GOB_FUNCTION__

#line 218 "media-player-control.gob"
void 
media_player_control_construct (MediaPlayerControl * self)
#line 446 "media-player-control.c"
{
#define __GOB_FUNCTION__ "Media:Player:Control::construct"
#line 218 "media-player-control.gob"
	g_return_if_fail (self != NULL);
#line 218 "media-player-control.gob"
	g_return_if_fail (MEDIA_IS_PLAYER_CONTROL (self));
#line 453 "media-player-control.c"
{
#line 219 "media-player-control.gob"
	
			GtkWidget           *media_control;
			BonoboControl       *control;
			BonoboPersistFile   *pf;
			BonoboPersistStream *ps;
			Bonobo_Unknown       corba_object;

			media_control = bonobo_media_control_new ();
			gtk_widget_show_all (media_control);
			
			control = bonobo_control_new (media_control);
			pf = bonobo_persist_file_new (
				(BonoboPersistFileIOFn) PersistFile_load,
				(BonoboPersistFileIOFn) NULL,
				self);
			ps = bonobo_persist_stream_new (
				(BonoboPersistStreamIOFn)    PersistStream_load,
				(BonoboPersistStreamIOFn)    NULL,
				(BonoboPersistStreamMaxFn)   NULL,
				(BonoboPersistStreamTypesFn) NULL,
				self);

			bonobo_object_add_interface (BONOBO_OBJECT (self),
						     BONOBO_OBJECT (control));
			bonobo_object_add_interface (BONOBO_OBJECT (self),
						     BONOBO_OBJECT (pf));
			bonobo_object_add_interface (BONOBO_OBJECT (self),
						     BONOBO_OBJECT (ps));

			corba_object = corba_object_create (BONOBO_OBJECT (self));
			
			bonobo_object_construct (BONOBO_OBJECT (self),
						 corba_object);

			self->_priv->media_control = BONOBO_MEDIA_CONTROL (media_control);
		}}
#line 492 "media-player-control.c"
#undef __GOB_FUNCTION__

#line 256 "media-player-control.gob"
BonoboObject * 
media_player_control_new (void)
#line 498 "media-player-control.c"
{
#define __GOB_FUNCTION__ "Media:Player:Control::new"
{
#line 257 "media-player-control.gob"
	
			Self *self;

			self = GET_NEW;
			construct (self);
			
			return BONOBO_OBJECT (self);
		}}
#line 511 "media-player-control.c"
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___media_player_control_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))load_media_stream_from_stream)();
	((void (*)(void))media_stream_from_stream)();
	((void (*)(void))set_stream)();
	((void (*)(void))PersistFile_load)();
	((void (*)(void))PersistStream_load)();
	((void (*)(void))corba_object_create)();
	((void (*)(void))construct)();
	((void (*)(void))new)();
	___media_player_control_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

