/* Generated by GOB (v1.0.5) on Mon Jan 22 18:31:52 2001
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 3 "bonobo-media-control-stream.gob"

/* $Id: bonobo-media-control-stream.gob,v 1.10 2001/01/22 17:24:41 cactus Exp $
 *
 * bonobo-media-control-stream: a general user interface for Bonobo:Media streams
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (c) 2000-2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 */

#line 33 "bonobo-media-control-stream.c"
#define GOB_VERSION_MAJOR 1
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 5

#include <string.h> /* memset() */

#include "bonobo-media-control-stream.h"

#include "bonobo-media-control-stream-private.h"


#line 37 "bonobo-media-control-stream.gob"

#include <bonobo/bonobo-widget.h>
#include <bonobo/bonobo-arg.h>
#include <libgnomeui/libgnomeui.h>

#include "play.xpm"
#include "pause.xpm"

#line 54 "bonobo-media-control-stream.c"
/* self casting macros */
#define SELF(x) BONOBO_MEDIA_CONTROL_STREAM(x)
#define SELF_CONST(x) BONOBO_MEDIA_CONTROL_STREAM_CONST(x)
#define IS_SELF(x) BONOBO_IS_MEDIA_CONTROL_STREAM(x)
#define SELF_CLASS(x) BONOBO_MEDIA_CONTROL_STREAM_CLASS(x)

#define SELF_GET_CLASS(x) BONOBO_MEDIA_CONTROL_STREAM_GET_CLASS(x)

/* self typedefs */
typedef BonoboMediaControlStream Self;
typedef BonoboMediaControlStreamClass SelfClass;

/* GTK_CLASS_TYPE for 1.2<->1.3/2.0 GTK+ compatibility */
#ifndef GTK_CLASS_TYPE
#define GTK_CLASS_TYPE(x) (GTK_OBJECT_CLASS(x)->type)
#endif /* GTK_CLASS_TYPE */

/* here are local prototypes */
static void bonobo_media_control_stream_init (BonoboMediaControlStream * o) G_GNUC_UNUSED;
static void bonobo_media_control_stream_class_init (BonoboMediaControlStreamClass * c) G_GNUC_UNUSED;
static void ___1_bonobo_media_control_stream_destroy (GtkObject * obj) G_GNUC_UNUSED;
static void bonobo_media_control_stream_play_cb (GtkObject * caller, BonoboMediaControlStream * self) G_GNUC_UNUSED;
static void bonobo_media_control_stream_pause_cb (GtkObject * caller, BonoboMediaControlStream * self) G_GNUC_UNUSED;
static gint bonobo_media_control_stream_scale_press_cb (GtkObject * caller, GdkEvent * event, BonoboMediaControlStream * self) G_GNUC_UNUSED;
static gint bonobo_media_control_stream_scale_release_cb (GtkObject * caller, GdkEvent * event, BonoboMediaControlStream * self) G_GNUC_UNUSED;
static void bonobo_media_control_stream_seek (BonoboMediaControlStream * self, gint pos) G_GNUC_UNUSED;
static void bonobo_media_control_stream_position_cb (BonoboMediaControlStream * self, int pos) G_GNUC_UNUSED;
static void bonobo_media_control_stream_listener_cb (BonoboListener * listener, char * event_name, BonoboArg * event_data, CORBA_Environment * ev, BonoboMediaControlStream * self) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GtkHBoxClass *parent_class = NULL;

GtkType
bonobo_media_control_stream_get_type (void)
{
	static guint type = 0;

	if ( ! type) {
		static const GtkTypeInfo info = {
			"BonoboMediaControlStream",
			sizeof (BonoboMediaControlStream),
			sizeof (BonoboMediaControlStreamClass),
			(GtkClassInitFunc) bonobo_media_control_stream_class_init,
			(GtkObjectInitFunc) bonobo_media_control_stream_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		type = gtk_type_unique (gtk_hbox_get_type(), &info);
	}

	return type;
}

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define play_cb(args...) bonobo_media_control_stream_play_cb(##args)
#define pause_cb(args...) bonobo_media_control_stream_pause_cb(##args)
#define scale_press_cb(args...) bonobo_media_control_stream_scale_press_cb(##args)
#define scale_release_cb(args...) bonobo_media_control_stream_scale_release_cb(##args)
#define seek(args...) bonobo_media_control_stream_seek(##args)
#define position_cb(args...) bonobo_media_control_stream_position_cb(##args)
#define listener_cb(args...) bonobo_media_control_stream_listener_cb(##args)
#define release_stream(args...) bonobo_media_control_stream_release_stream(##args)
#define set_stream(args...) bonobo_media_control_stream_set_stream(##args)
#define construct(args...) bonobo_media_control_stream_construct(##args)
#define new() bonobo_media_control_stream_new()
#define new_with_stream(args...) bonobo_media_control_stream_new_with_stream(##args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static void (* const play_cb) (GtkObject * caller, BonoboMediaControlStream * self) = bonobo_media_control_stream_play_cb;
static void (* const pause_cb) (GtkObject * caller, BonoboMediaControlStream * self) = bonobo_media_control_stream_pause_cb;
static gint (* const scale_press_cb) (GtkObject * caller, GdkEvent * event, BonoboMediaControlStream * self) = bonobo_media_control_stream_scale_press_cb;
static gint (* const scale_release_cb) (GtkObject * caller, GdkEvent * event, BonoboMediaControlStream * self) = bonobo_media_control_stream_scale_release_cb;
static void (* const seek) (BonoboMediaControlStream * self, gint pos) = bonobo_media_control_stream_seek;
static void (* const position_cb) (BonoboMediaControlStream * self, int pos) = bonobo_media_control_stream_position_cb;
static void (* const listener_cb) (BonoboListener * listener, char * event_name, BonoboArg * event_data, CORBA_Environment * ev, BonoboMediaControlStream * self) = bonobo_media_control_stream_listener_cb;
static void (* const release_stream) (BonoboMediaControlStream * self) = bonobo_media_control_stream_release_stream;
static void (* const set_stream) (BonoboMediaControlStream * self, Bonobo_Media_Stream stream) = bonobo_media_control_stream_set_stream;
static void (* const construct) (BonoboMediaControlStream * self) = bonobo_media_control_stream_construct;
static GtkWidget * (* const new) (void) = bonobo_media_control_stream_new;
static GtkWidget * (* const new_with_stream) (Bonobo_Media_Stream stream) = bonobo_media_control_stream_new_with_stream;

/* a macro for creating a new object of our type */
#define GET_NEW ((BonoboMediaControlStream *)gtk_type_new(bonobo_media_control_stream_get_type()))


static void
___destroy(GtkObject *obj_self)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Control:Stream::destroy"
	BonoboMediaControlStream *self = BONOBO_MEDIA_CONTROL_STREAM (obj_self);
#line 57 "bonobo-media-control-stream.gob"
	___1_bonobo_media_control_stream_destroy(obj_self);
#line 151 "bonobo-media-control-stream.c"
#define VAR (self->_priv->listener)
	{
#line 49 "bonobo-media-control-stream.gob"
	
		if (VAR)
			bonobo_object_unref (BONOBO_OBJECT (VAR));
	}
#line 159 "bonobo-media-control-stream.c"
	memset(&VAR, 0, sizeof(VAR));
#undef VAR
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__


#ifdef G_OBJECT_CLASS
static void
___finalize(GObject *obj_self)
#else /* !G_OBJECT_CLASS */
static void
___finalize(GtkObject *obj_self)
#endif /* G_OBJECT_CLASS */
{
#define __GOB_FUNCTION__ "Bonobo:Media:Control:Stream::finalize"
	BonoboMediaControlStream *self = BONOBO_MEDIA_CONTROL_STREAM (obj_self);
	gpointer priv = self->_priv;
#ifdef G_OBJECT_CLASS
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#else /* !G_OBJECT_CLASS */
	if(GTK_OBJECT_CLASS(parent_class)->finalize) \
		(* GTK_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#endif /* G_OBJECT_CLASS */
	g_free(priv);
}
#undef __GOB_FUNCTION__

static void 
bonobo_media_control_stream_init (BonoboMediaControlStream * o)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Control:Stream::init"
	o->_priv = g_new0 (BonoboMediaControlStreamPrivate, 1);
#line 49 "bonobo-media-control-stream.gob"
	o->_priv->listener = 0;
#line 197 "bonobo-media-control-stream.c"
#line 49 "bonobo-media-control-stream.gob"
	o->_priv->stream = CORBA_OBJECT_NIL;
#line 200 "bonobo-media-control-stream.c"
#line 59 "bonobo-media-control-stream.gob"
	o->_priv->paused = FALSE;
#line 203 "bonobo-media-control-stream.c"
	return;
	o = NULL;
}
#undef __GOB_FUNCTION__
static void 
bonobo_media_control_stream_class_init (BonoboMediaControlStreamClass * c)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Control:Stream::class_init"
	GtkObjectClass *gtk_object_class = (GtkObjectClass*) c;
#ifdef G_OBJECT_CLASS
	GObjectClass *g_object_class = (GObjectClass*) c;
#endif /* G_OBJECT_CLASS */

	parent_class = gtk_type_class (gtk_hbox_get_type ());

#line 57 "bonobo-media-control-stream.gob"
	gtk_object_class->destroy = ___destroy;
#line 221 "bonobo-media-control-stream.c"
#ifdef G_OBJECT_CLASS
	g_object_class->finalize = ___finalize;
#else /* !G_OBJECT_CLASS */
	gtk_object_class->finalize = ___finalize;
#endif /* G_OBJECT_CLASS */
	return;
	c = NULL;
	gtk_object_class = NULL;
#ifdef G_OBJECT_CLASS
	g_object_class = NULL;
#endif /* G_OBJECT_CLASS */
}
#undef __GOB_FUNCTION__



#line 57 "bonobo-media-control-stream.gob"
static void 
___1_bonobo_media_control_stream_destroy (GtkObject * obj)
#line 241 "bonobo-media-control-stream.c"
#define PARENT_HANDLER(___obj) \
	{ if(GTK_OBJECT_CLASS(parent_class)->destroy) \
		(* GTK_OBJECT_CLASS(parent_class)->destroy)(___obj); }
{
#define __GOB_FUNCTION__ "Bonobo:Media:Control:Stream::destroy"
#line 57 "bonobo-media-control-stream.gob"
	g_return_if_fail (obj != NULL);
#line 249 "bonobo-media-control-stream.c"
{
#line 59 "bonobo-media-control-stream.gob"
	
			Self *self = SELF (obj);

			/*
			if (self->_priv->listener)
				bonobo_object_unref (BONOBO_OBJECT (self->_priv->listener));
			*/
			
			release_stream (self);
		}}
#line 262 "bonobo-media-control-stream.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 78 "bonobo-media-control-stream.gob"
static void 
bonobo_media_control_stream_play_cb (GtkObject * caller, BonoboMediaControlStream * self)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Control:Stream::play_cb"
#line 78 "bonobo-media-control-stream.gob"
	g_return_if_fail (self != NULL);
#line 78 "bonobo-media-control-stream.gob"
	g_return_if_fail (BONOBO_IS_MEDIA_CONTROL_STREAM (self));
#line 275 "bonobo-media-control-stream.c"
{
#line 80 "bonobo-media-control-stream.gob"
	
			CORBA_Environment ev;
			Bonobo_Media_Stream media_stream = self->_priv->stream;

			g_return_if_fail (media_stream != CORBA_OBJECT_NIL);
			
			if (self->_priv->paused)
			{	    
				self->_priv->paused = FALSE;
			} else {
				seek (self, 0);
			}
			
			CORBA_exception_init (&ev);
			Bonobo_Media_Stream_play (media_stream, &ev);
			CORBA_exception_free (&ev);
		}}
#line 295 "bonobo-media-control-stream.c"
#undef __GOB_FUNCTION__

#line 98 "bonobo-media-control-stream.gob"
static void 
bonobo_media_control_stream_pause_cb (GtkObject * caller, BonoboMediaControlStream * self)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Control:Stream::pause_cb"
#line 98 "bonobo-media-control-stream.gob"
	g_return_if_fail (self != NULL);
#line 98 "bonobo-media-control-stream.gob"
	g_return_if_fail (BONOBO_IS_MEDIA_CONTROL_STREAM (self));
#line 307 "bonobo-media-control-stream.c"
{
#line 100 "bonobo-media-control-stream.gob"
	
			CORBA_Environment ev;
			Bonobo_Media_Stream media_stream = self->_priv->stream;

			g_return_if_fail (media_stream != CORBA_OBJECT_NIL);
			
			if (self->_priv->paused)
			{
				play_cb (caller, self);
			} else {
				CORBA_exception_init (&ev);
				Bonobo_Media_Stream_stop (media_stream, &ev);
				CORBA_exception_free (&ev);
				
				self->_priv->paused = TRUE;
			}
		}}
#line 327 "bonobo-media-control-stream.c"
#undef __GOB_FUNCTION__

#line 118 "bonobo-media-control-stream.gob"
static gint 
bonobo_media_control_stream_scale_press_cb (GtkObject * caller, GdkEvent * event, BonoboMediaControlStream * self)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Control:Stream::scale_press_cb"
#line 118 "bonobo-media-control-stream.gob"
	g_return_val_if_fail (self != NULL, (gint )0);
#line 118 "bonobo-media-control-stream.gob"
	g_return_val_if_fail (BONOBO_IS_MEDIA_CONTROL_STREAM (self), (gint )0);
#line 339 "bonobo-media-control-stream.c"
{
#line 121 "bonobo-media-control-stream.gob"
	
			self->_priv->scale_dragging = TRUE;
			return FALSE;
		}}
#line 346 "bonobo-media-control-stream.c"
#undef __GOB_FUNCTION__

#line 126 "bonobo-media-control-stream.gob"
static gint 
bonobo_media_control_stream_scale_release_cb (GtkObject * caller, GdkEvent * event, BonoboMediaControlStream * self)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Control:Stream::scale_release_cb"
#line 126 "bonobo-media-control-stream.gob"
	g_return_val_if_fail (self != NULL, (gint )0);
#line 126 "bonobo-media-control-stream.gob"
	g_return_val_if_fail (BONOBO_IS_MEDIA_CONTROL_STREAM (self), (gint )0);
#line 358 "bonobo-media-control-stream.c"
{
#line 129 "bonobo-media-control-stream.gob"
	
			int pos;
			
			self->_priv->scale_dragging = FALSE;
			
			pos = self->_priv->scale_adj->value;
			seek (self, pos);
			
			return FALSE;
		}}
#line 371 "bonobo-media-control-stream.c"
#undef __GOB_FUNCTION__

#line 140 "bonobo-media-control-stream.gob"
static void 
bonobo_media_control_stream_seek (BonoboMediaControlStream * self, gint pos)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Control:Stream::seek"
#line 140 "bonobo-media-control-stream.gob"
	g_return_if_fail (self != NULL);
#line 140 "bonobo-media-control-stream.gob"
	g_return_if_fail (BONOBO_IS_MEDIA_CONTROL_STREAM (self));
#line 383 "bonobo-media-control-stream.c"
{
#line 141 "bonobo-media-control-stream.gob"
	
			CORBA_Environment ev;
			Bonobo_Media_Stream media_stream = self->_priv->stream;

			g_return_if_fail (media_stream != CORBA_OBJECT_NIL);
			
			CORBA_exception_init (&ev);
			Bonobo_Media_Stream_seek (media_stream, pos, &ev);
			CORBA_exception_free (&ev);
		}}
#line 396 "bonobo-media-control-stream.c"
#undef __GOB_FUNCTION__

#line 152 "bonobo-media-control-stream.gob"
static void 
bonobo_media_control_stream_position_cb (BonoboMediaControlStream * self, int pos)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Control:Stream::position_cb"
#line 152 "bonobo-media-control-stream.gob"
	g_return_if_fail (self != NULL);
#line 152 "bonobo-media-control-stream.gob"
	g_return_if_fail (BONOBO_IS_MEDIA_CONTROL_STREAM (self));
#line 408 "bonobo-media-control-stream.c"
{
#line 153 "bonobo-media-control-stream.gob"
	
			if (!self->_priv->scale_dragging)
				gtk_adjustment_set_value (self->_priv->scale_adj, pos);
		}}
#line 415 "bonobo-media-control-stream.c"
#undef __GOB_FUNCTION__

#line 158 "bonobo-media-control-stream.gob"
static void 
bonobo_media_control_stream_listener_cb (BonoboListener * listener, char * event_name, BonoboArg * event_data, CORBA_Environment * ev, BonoboMediaControlStream * self)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Control:Stream::listener_cb"
#line 158 "bonobo-media-control-stream.gob"
	g_return_if_fail (self != NULL);
#line 158 "bonobo-media-control-stream.gob"
	g_return_if_fail (BONOBO_IS_MEDIA_CONTROL_STREAM (self));
#line 427 "bonobo-media-control-stream.c"
{
#line 164 "bonobo-media-control-stream.gob"
	
			if (!strcmp (event_name, bonobo_event_make_name ("Bonobo/Media/Stream",
									 "position_notify", 0)))
				position_cb (self, BONOBO_ARG_GET_LONG (event_data));
		}}
#line 435 "bonobo-media-control-stream.c"
#undef __GOB_FUNCTION__

#line 170 "bonobo-media-control-stream.gob"
void 
bonobo_media_control_stream_release_stream (BonoboMediaControlStream * self)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Control:Stream::release_stream"
#line 170 "bonobo-media-control-stream.gob"
	g_return_if_fail (self != NULL);
#line 170 "bonobo-media-control-stream.gob"
	g_return_if_fail (BONOBO_IS_MEDIA_CONTROL_STREAM (self));
#line 447 "bonobo-media-control-stream.c"
{
#line 171 "bonobo-media-control-stream.gob"
	
			if (self->_priv->stream != CORBA_OBJECT_NIL)
			{
				CORBA_Environment ev;
				
				CORBA_exception_init (&ev);
				Bonobo_Unknown_unref (self->_priv->stream, &ev);
				CORBA_exception_free (&ev);
			}

			self->_priv->stream = CORBA_OBJECT_NIL;
		}}
#line 462 "bonobo-media-control-stream.c"
#undef __GOB_FUNCTION__

#line 184 "bonobo-media-control-stream.gob"
void 
bonobo_media_control_stream_set_stream (BonoboMediaControlStream * self, Bonobo_Media_Stream stream)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Control:Stream::set_stream"
#line 184 "bonobo-media-control-stream.gob"
	g_return_if_fail (self != NULL);
#line 184 "bonobo-media-control-stream.gob"
	g_return_if_fail (BONOBO_IS_MEDIA_CONTROL_STREAM (self));
#line 184 "bonobo-media-control-stream.gob"
	g_return_if_fail (stream != NULL);
#line 476 "bonobo-media-control-stream.c"
{
#line 185 "bonobo-media-control-stream.gob"
	
			CORBA_Environment ev;
			Bonobo_EventSource event_source;
			gfloat ratio;
			gint   length;

			release_stream (self);

			if (stream == CORBA_OBJECT_NIL)
			{
				
				gtk_widget_set_sensitive (self->_priv->scale, FALSE);
				gtk_widget_set_sensitive (self->_priv->play_btn,  FALSE);
				gtk_widget_set_sensitive (self->_priv->pause_btn, FALSE);
				return;
			}
			
			CORBA_exception_init (&ev);
			length = Bonobo_Media_Stream_getLength (stream, &ev);
			if (ev._major == CORBA_USER_EXCEPTION &&
			    !strcmp (ev._repo_id, ex_Bonobo_Media_Stream_NotSupported))
				length = 0;
			CORBA_exception_free (&ev);

			CORBA_exception_init (&ev);
			ratio = Bonobo_Media_Stream_getPositionsPerSecond (stream, &ev);
			CORBA_exception_free (&ev);

			/* Set up the position scale */
			self->_priv->scale_adj->upper          = length;
			self->_priv->scale_adj->step_increment = 1.0 * ratio;
			self->_priv->scale_adj->page_increment = 10.0 * ratio;
			gtk_adjustment_changed (self->_priv->scale_adj);
			gtk_widget_set_sensitive (self->_priv->scale,
						  length != 0);
			
			/* Set up the listener */
			CORBA_exception_init (&ev);
			event_source = Bonobo_Unknown_queryInterface (
				stream, "IDL:Bonobo/EventSource:1.0",
				&ev);
			if (ev._major == CORBA_NO_EXCEPTION &&
			    event_source != CORBA_OBJECT_NIL)
			{
				Bonobo_Listener corba_listener;

				corba_listener =
					bonobo_object_corba_objref
					(BONOBO_OBJECT (self->_priv->listener));
				
				Bonobo_EventSource_addListener
					(event_source, corba_listener, &ev);
				
				Bonobo_Unknown_unref (event_source, &ev);
			}

			CORBA_exception_free (&ev);
				 
			/* Enable buttons */
			gtk_widget_set_sensitive (self->_priv->play_btn,  TRUE);
			gtk_widget_set_sensitive (self->_priv->pause_btn, TRUE);
			
			/* Fill instance information */
			self->_priv->stream    = stream;
//			self->_priv->listener  = listener;
			
			CORBA_exception_init (&ev);
			Bonobo_Unknown_ref (stream, &ev);
			CORBA_exception_free (&ev);
			
		}}
#line 550 "bonobo-media-control-stream.c"
#undef __GOB_FUNCTION__

#line 257 "bonobo-media-control-stream.gob"
void 
bonobo_media_control_stream_construct (BonoboMediaControlStream * self)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Control:Stream::construct"
#line 257 "bonobo-media-control-stream.gob"
	g_return_if_fail (self != NULL);
#line 257 "bonobo-media-control-stream.gob"
	g_return_if_fail (BONOBO_IS_MEDIA_CONTROL_STREAM (self));
#line 562 "bonobo-media-control-stream.c"
{
#line 258 "bonobo-media-control-stream.gob"
	
			GtkWidget      *scale, *button, *pixmap;
			GtkAdjustment  *adj;
			BonoboListener *listener;

			gtk_box_set_spacing (GTK_BOX (self), 0);
			
			/* Create the buttons */
			button = gtk_button_new (); /* Play */
			pixmap = gnome_pixmap_new_from_xpm_d (play_xpm);
			gtk_container_add (GTK_CONTAINER (button), pixmap);
			gtk_signal_connect (GTK_OBJECT (button), "clicked",
					    GTK_SIGNAL_FUNC (play_cb), self);
			gtk_widget_set_sensitive (button, FALSE);
			gtk_widget_show (button);
			gtk_box_pack_start (GTK_BOX (self), button,
					    FALSE, FALSE, 0);
			self->_priv->play_btn = button;
			
			button = gtk_button_new (); /* Pause */
			pixmap = gnome_pixmap_new_from_xpm_d (pause_xpm);
			gtk_container_add (GTK_CONTAINER (button), pixmap);
			gtk_signal_connect (GTK_OBJECT (button), "clicked",
					    GTK_SIGNAL_FUNC (pause_cb), self);
			gtk_widget_set_sensitive (button, FALSE);
			gtk_widget_show (button);
			gtk_box_pack_start (GTK_BOX (self), button,
					    FALSE, FALSE, 0);
			self->_priv->pause_btn = button;

			/* Set up the Listener */
			listener = bonobo_listener_new (
				(BonoboListenerCallbackFn)listener_cb, self);
			self->_priv->listener = listener;
			
			/* Create the position scale */
			adj = GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 0, 0, 0, 0));
			scale = gtk_hscale_new (adj);
			gtk_widget_set_sensitive (scale, FALSE);
			gtk_scale_set_digits (GTK_SCALE (scale), 0);
			gtk_scale_set_draw_value (GTK_SCALE (scale), FALSE);
			gtk_widget_set_usize (scale, 150, 0);
			
			gtk_signal_connect (GTK_OBJECT (scale), "button_press_event",
					    GTK_SIGNAL_FUNC (scale_press_cb), self);
			gtk_signal_connect (GTK_OBJECT (scale), "button_release_event",
					    GTK_SIGNAL_FUNC (scale_release_cb), self);
			
			gtk_widget_show (scale);
			gtk_container_add (GTK_CONTAINER (self), scale);
			self->_priv->scale_adj = adj;
			self->_priv->scale     = scale;
		}}
#line 618 "bonobo-media-control-stream.c"
#undef __GOB_FUNCTION__

#line 312 "bonobo-media-control-stream.gob"
GtkWidget * 
bonobo_media_control_stream_new (void)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Control:Stream::new"
#line 626 "bonobo-media-control-stream.c"
{
#line 313 "bonobo-media-control-stream.gob"
	
			BonoboMediaControlStream *self = GET_NEW;
			
			construct (self);
			
			return GTK_WIDGET (self);
		}}
#line 636 "bonobo-media-control-stream.c"
#undef __GOB_FUNCTION__

#line 321 "bonobo-media-control-stream.gob"
GtkWidget * 
bonobo_media_control_stream_new_with_stream (Bonobo_Media_Stream stream)
{
#define __GOB_FUNCTION__ "Bonobo:Media:Control:Stream::new_with_stream"
#line 321 "bonobo-media-control-stream.gob"
	g_return_val_if_fail (stream != NULL, (GtkWidget * )0);
#line 646 "bonobo-media-control-stream.c"
{
#line 322 "bonobo-media-control-stream.gob"
	
			BonoboMediaControlStream *self = GET_NEW;
			
			construct (self);
			set_stream (self, stream);
			
			return GTK_WIDGET (self);
		}}
#line 657 "bonobo-media-control-stream.c"
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___bonobo_media_control_stream_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))play_cb)();
	((void (*)(void))pause_cb)();
	((void (*)(void))scale_press_cb)();
	((void (*)(void))scale_release_cb)();
	((void (*)(void))seek)();
	((void (*)(void))position_cb)();
	((void (*)(void))listener_cb)();
	((void (*)(void))release_stream)();
	((void (*)(void))set_stream)();
	((void (*)(void))construct)();
	((void (*)(void))new)();
	((void (*)(void))new_with_stream)();
	___bonobo_media_control_stream_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

