module ProblemParser where

import Text.ParserCombinators.Parsec
import Text.ParserCombinators.Parsec.Expr
import qualified Text.ParserCombinators.Parsec.Token as P
import Text.ParserCombinators.Parsec.Language (emptyDef)    

import Control.Monad

import Data.Packed.Vector
import Data.Packed.Matrix
    
lexer :: P.TokenParser ()
lexer = P.makeTokenParser $ emptyDef{
          P.caseSensitive = True,
          P.reservedNames = ["A", "b", "c"],
          P.reservedOpNames = ["=", "-"]
         }
    
brackets   = P.brackets lexer
colon      = P.colon lexer              
comma      = P.comma lexer
semi       = P.semi lexer
float      = P.float lexer
integer    = P.integer lexer
reserved   = P.reserved lexer
reservedOp = P.reservedOp lexer

sfloat = try negfloat <|> try float <|> liftM fromIntegral integer
    where negfloat = do reservedOp "-"
                        n <- float
                        return (negate n)

parseProb = do
  a <- do
    reserved "A"
    reservedOp "="
    cols <- (brackets $ (sfloat `sepBy1` comma) `sepEndBy` semi)
    return cols
                  
  b <- do
    reserved "b"
    reservedOp "="
    brackets $ sfloat `sepBy` semi
  c <- do
    reserved "c"
    reservedOp "="
    brackets $ sfloat `sepBy` comma

  semi
  eof
  return (fromLists a, fromList b, fromList c)         

parseProbFile = parseFromFile parseProb         
