module Main where
    
import Text.Printf (printf)
import ProblemParser
import System.Environment (getArgs)
import InteriorNewton
import qualified Control.Monad.Writer as W
import Data.Packed.Vector

loadProblem fileName = do  Right (a, b, c) <- parseProbFile fileName
                           let prob = Problem a b c
                           return prob

main = do  args <- getArgs
           case args of
             [fileName]  -> do solveIO fileName
             _           -> error "Usage: InteriorNewton {filename.m}"
                     
solveIO fileName = do  prob <- loadProblem fileName
                       let ((x, y, s), log) = W.runWriter $ optimize prob
                       putStr $ unlines $ map (logLine prob) log
                       let (infeasSteps, feasSteps) = count log
                       putStrLn $ unwords ["Number of infeasible steps:", show infeasSteps]
                       putStrLn $ unwords ["Number of feasible steps:", show feasSteps]
                       putStr $ unlines ["Optimal solution:", showVector x]
                       putStrLn $ unwords ["Optimal value:", show $ target prob (x, y, s)]
                       return (x, y, s)
                             
    where  logLine prob (Infeasible (x, y, s) nu) = unwords ["Infeasible step, nu =", show nu]
           logLine prob (Feasible (x, y, s)) = unwords ["Feasible step, gap =", show $ gap prob (x, y, s)]
           count log = (length $ filter isInfeasible log, length $ filter isFeasible log)
               where  isInfeasible (Infeasible _ _)  = True
                      isInfeasible (Feasible _)      = False
                      isFeasible                     = not . isInfeasible
           showVector v = unlines $ map showFloat $ toList v
           showFloat x = printf "\t%.4f" x
