#!/bin/sh

if [ "x$MPI_MPICH_PATH" == "x" ]; then 
### extract mpi-start tarball

   chmod 755 mpi-start.tar
   tar xvf mpi-start.tar
   chmod a+x bin/mpi-start
#   PathPlus=`which mpirun`
#   let lPathPlus=`echo $PathPlus | wc -c`-7
#   Path=`echo $PathPlus | cut -c1-$lPathPlus`
#   export MPI_MPICH_PATH=$Path
#   export MPI_MPICH_PATH=toto
   WhichMpirun=`which mpirun`	
   export MPI_MPICH_PATH=`dirname $WhichMpirun`
   export I2G_MPI_START='bin/mpi-start'
fi


# Pull in the arguments.
MY_EXECUTABLE=`pwd`/$1
MPI_FLAVOR=$2

# Read all arguments using by MPI application.

for (( i=3;i<=$#;i++))
do 
MY_ARGS=$MY_ARGS" "$(echo $* | cut -f$i -d" ")
done




# Convert flavor to lowercase for passing to mpi-start.
MPI_FLAVOR_LOWER=`echo $MPI_FLAVOR | tr '[:upper:]' '[:lower:]'`

# Pull out the correct paths for the requested flavor.
eval MPI_PATH=`printenv MPI_${MPI_FLAVOR}_PATH`

# Ensure the prefix is correctly set.  Don't rely on the defaults.
eval I2G_${MPI_FLAVOR}_PREFIX=$MPI_PATH
export I2G_${MPI_FLAVOR}_PREFIX

# Touch the executable.  It exist must for the shared file system check.
# If it does not, then mpi-start may try to distribute the executable
# when it shouldn't.
touch $MY_EXECUTABLE

# Setup for mpi-start.
export I2G_MPI_APPLICATION=$MY_EXECUTABLE
export I2G_MPI_APPLICATION_ARGS=$MY_ARGS
export I2G_MPI_TYPE=$MPI_FLAVOR_LOWER
export I2G_MPI_PRE_RUN_HOOK=mpi-hooks.sh
export I2G_MPI_POST_RUN_HOOK=mpi-hooks.sh

# If these are set then you will get more debugging information.
export I2G_MPI_START_VERBOSE=1
#export I2G_MPI_START_DEBUG=1

# Invoke mpi-start.
echo "MPI_MPICH_PATH = $MPI_MPICH_PATH"
echo "I2G_MPI_START = $I2G_MPI_START"
$I2G_MPI_START
