#!/bin/sh

#
# This function will be called before the MPI executable is started.
# You can, for example, compile the executable itself.
#
pre_run_hook () {

	#### extract source.tgz ### 
	tar xvzf sourcefiles.tgz 


  # Actually compile the program.
  LD_LIBRARY_PATH=$LD_LIBRARY_PATH:.
 
  cmd="mpicc -o mpiexample dorothy.c dorothy-md5.c dorothy-chain.c"
  ls -l
  echo $cmd
  $cmd 
 
  
  echo Worker Node is `uname -m` architecture

  return 0
}

#
# This function will be called before the MPI executable is finished.
# A typical case for this is to upload the results to a storage element.
#
post_run_hook () {

  echo "Executing post hook."
  echo "Finished the post hook."

  return 0
}


