#include <string.h>
#include <stdlib.h>

#include "dorothy-chain.h"
#include "dorothy-md5.h"

const int cchWord = 5;
const char rgchAlpha[] = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 .";
const int cchAlpha = 64;

int dorothy_cchWord ()
{
    return cchWord;
}

#define USE_MPI 1

char dorothy_get_ch (unsigned char i)
{
    return rgchAlpha[i % cchAlpha];
}

void dorothy_print_md5 (unsigned char h[16])
{
    int i;
    for (i = 0; i < 16; i++)
        printf ("%02x", h[i]);
}

void dorothy_md5 (const char *text, unsigned char *digest)
{
    struct md5_ctx ctx;
    __md5_init_ctx (&ctx);

    __md5_process_bytes (text, strlen (text), &ctx);
    __md5_finish_ctx (&ctx, digest);
}

char * dorothy_reduce (unsigned char h[16], int iReduce)
{
    char *stWord = calloc (sizeof (char), cchWord + 1);
    
    int iPos = 0;
    for (int i = 0; i < cchWord; ++i)
    {
        int dPos = 1;
        if (iReduce & 1 << i) ++dPos;
        if (iReduce & 1 << (9-i)) ++dPos;        
        iPos += dPos;

        stWord[i] = dorothy_get_ch (h[iPos]);
    }
    
    return stWord;
}

void dorothy_randomize (char *st)
{
    int i;
    for (i = 0; i < cchWord; ++i)
    {
        int r = rand ();
        st[i] = dorothy_get_ch (r);
    }
}
