#include "dorothy-chain.h"

#define _BSD_SOURCE

#include <mpi.h>

#include <stdint.h>
#include <stdio.h>
#include <string.h>

#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#define USE_MPI 1

enum Msg
{
    MSG_KEY,
    MSG_FINISHED
};

void finished_pair (const char *stKey, unsigned char *h)
{
#if USE_MPI
    char buf[5 + 16] = {0,};
    memcpy(buf, stKey, dorothy_cchWord ());
    memcpy(buf + dorothy_cchWord (), h, 16);

    MPI_Send (buf, 21, MPI_CHAR, 0, MSG_KEY, MPI_COMM_WORLD);
#else
    printf ("%s ", stKey);
    print_md5 (h);         
    printf ("\n");
#endif
}

void process_chain (char *stKey)
{
    char *stWord = strdup (stKey);
    
    unsigned char h[16];
    {
        unsigned long int iStep;
        for (iStep = 0; iStep < (1<<10) + 1; ++iStep)
        {
            dorothy_md5 (stWord, h);
            
            /* if (iStep == 300) */
            /* { */
            /*     printf ("%s ", stWord); */
            /*     /\* printf ("%s  %s  ", stWord, stKey); *\/ */
            /*     dorothy_print_md5 (h); */
            /*     printf ("\n"); */
            /* } */
            
            free (stWord);
            stWord = dorothy_reduce (h, iStep);
        }
    }

    free (stWord);
    finished_pair (stKey, h);
}

void slave (int iJob, int iSlave, int cPair)
{
    printf ("SLAVE %d: Start\n", iSlave);
    srand (iJob * 1000 + (iSlave + 1));
    
    {
        int i;
        for (i = 0; i < cPair; ++i)
        {
            char stKey[6] = {0, };
            dorothy_randomize (stKey);
            process_chain (stKey);
        }
    }
    
#if USE_MPI
    MPI_Send(0, 0, MPI_CHAR, 0, MSG_FINISHED, MPI_COMM_WORLD);
#endif
}

void master (int cSlave)
{
    printf ("MASTER: Starting with %d slaves\n", cSlave);
    
    FILE *fdOut = fopen ("dorothy.out", "wb");
    
    char *buf[cSlave];
    {
        int iSlave;
        for (iSlave = 0; iSlave < cSlave; ++iSlave)
            buf[iSlave] = malloc (50 * sizeof(char));
    }

    MPI_Request rgreq[2 * cSlave];
    {
        int iSlave;
        for (iSlave = 0; iSlave < cSlave; ++iSlave)
        {
            MPI_Irecv(buf[iSlave], 21, MPI_CHAR, iSlave + 1, MSG_KEY, MPI_COMM_WORLD, &rgreq[iSlave]);
            MPI_Irecv(0, 0, MPI_CHAR, iSlave + 1, MSG_FINISHED, MPI_COMM_WORLD, &rgreq[cSlave + iSlave]);
        }
    }
    
    int cSlaveWorking = cSlave;    
    while (cSlaveWorking)
    {
        int ireq;
        
        MPI_Waitany(2 * cSlave, rgreq, &ireq, MPI_STATUS_IGNORE);
        
        if (ireq >= cSlave)
        {
            int iSlave = ireq - cSlave;

            printf ("MASTER: Slave %d finished\n", iSlave);

            rgreq[ireq] = MPI_REQUEST_NULL;
            --cSlaveWorking;
        }
        else
        {
            int iSlave = ireq;
            
#if DEBUG
            char stKey[6] = {0, };
            strncpy(stKey, buf[iSlave], cchWord);            
            unsigned char h[16];
            memcpy (h, buf[iSlave] + cchWord + 1, 16);
            
            printf ("MASTER: Result from %d: %s -> ", iSlave, stKey);
            print_md5 (h);
            printf ("\n");
#endif
            fwrite (buf[iSlave], dorothy_cchWord() + 16, sizeof (char), fdOut);
            
            MPI_Irecv(buf[iSlave], 21, MPI_CHAR, iSlave + 1, MSG_KEY, MPI_COMM_WORLD, &rgreq[iSlave]);
        }
    }

    fclose (fdOut);
}

int main (int argc, char **argv)
{
    int iJob = atoi (argv[1]);
    int cPair = atoi (argv[2]);
    
#if USE_MPI
    int numprocs;
    int myid;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &myid);
    
    if (myid == 0)
    {
        MPI_Comm_size(MPI_COMM_WORLD, &numprocs);
        master (numprocs - 1);
    }
    else
    {
        slave (iJob, myid - 1, cPair);
    }        
    
    MPI_Finalize ();
#else
    slave (0);
#endif
    return 0;
}
