#!/usr/bin/python
# -*- coding: iso-8859-2 -*-

###########################################################################
# Interpreter for a Simple Programming Language
#
# Copyright (C) 2006-2008 Gerg RDI
# http://cactus.rulez.org/
#
# Published under the terms of the GNU General Public License 2.0
# $Id: sp.py 188 2006-03-12 11:59:46Z cactus $
###########################################################################
#
# SP is a toy language allowing the following simple statements:
#
# READ var              Read an int from the user, and store it in 'var'
# WRITE expr            Print the value of 'expr'
# GOTO lbl [IF expr]    Jump to the specified line. If 'expr' is present,
#                       jump only if the result of 'expr' >= 0
# LET var = expr        Set value of 'var' to 'expr'
#
# There are 33 variables, named X, Y, Z, X0, ..., X9, Y0, ...
# The type of variables and expressions are all 32-bit signed integers
# 
###########################################################################

import parser

class Interpreter:
    def __init__ (self):
        self.vars = {}
        self.stmts = []
        self.lbl_map = {}
        
    def get_variable (self, var):
        if not var in self.vars: return 0
        return self.vars[var]

    def set_variable (self, var, val):
        self.vars[var] = val

    def load (self, program):
        for (lbl, stmt) in program:
            self.stmts.append(stmt)

            pos = len(self.stmts) - 1
            if not (lbl is None): self.lbl_map[lbl] = pos

    def run(self):
        self.pc = 0
        end = len(self.stmts)
        while self.pc < end:
            self.step()

    def step(self):
        stmt = self.stmts[self.pc]
        self.pc += 1
        stmt.evaluate (self)

    def jump(self, lbl):
        self.pc = self.lbl_map[lbl]

    def write(self, val):
        print val

    def read(self):
        try:
            s = raw_input('> ')
            return int(s)
        except EOFError:
            print
            return self.read()
        except ValueError:
            print "'%s': Invalid number" % s
            return self.read()

def run_sp (filename):
    prog = parser.load_sp (filename)
    interpreter = Interpreter ()
    interpreter.load(prog)
    interpreter.run()

if __name__ == '__main__':
    import sys

    for filename in sys.argv[1:]:
        run_sp (filename)
