; Linked list filtering for Linux/IA-32
;
; (C) 2007 Gergo ERDI
; http://cactus.rulez.org/
	
	section .text
	global filter, free_metalist
	extern malloc, free

int_width equ 4
ptr_width equ 4	
metalist_size equ ptr_width + ptr_width
	
%macro pushregs 0
	push ebx
	push ecx
	push edx
%endmacro

%macro popregs 0
	pop edx
	pop ecx
	pop ebx
%endmacro
	
%macro calldw 1-*		; calls %1 with dword arguments
	pushregs
	%rotate -1
	%rep (%0 - 1)
	push dword %1
	%rotate -1
	%endrep
	call %1
	add esp, 4 * (%0 - 1)
	popregs
%endmacro	

; metalist_t * filter (list_t *head, int (*predicate) (int data, void *closure), void *closure)		
filter:
	push ebp
	mov ebp, esp

	mov edx, 0	
	mov ecx, [ebp + 8]
	
l:	cmp ecx, 0
	je end

	calldw [ebp + 12], [ecx + 4], [ebp + 16] ; if !(*predicate)(current->data, closure) goto next
	cmp eax, 0
	je next
	
	calldw malloc, metalist_size ; Create new metalist element, ...
	
	cmp edx, 0
	je first
	mov [edx], eax
	jmp link
first:	mov ebx, eax
link:	mov [eax], dword 0	; ... and link it to the back
	mov [eax + ptr_width], ecx
	mov edx, eax
	
next:	mov ecx, [ecx]	
	jmp l
	
end:
	mov eax, ebx		; ebx holds the head of the list all along
	mov esp, ebp
	pop ebp
	ret

	
; void free_metalist (metalist_t *head)
free_metalist:
	push ebp
	mov ebp, esp

	mov ecx, [ebp + 8]
	
free_l:	cmp ecx, 0
	je free_end

	mov edx, [ecx]
	calldw free, ecx
	mov ecx, edx
	jmp free_l
	
free_end:	
	mov esp, ebp
	pop ebp
	ret
