#include <stdlib.h>
#include <stdio.h>

#include "list-filter.h"

void print_list (list_t *l)
{
    for (; l; l = l->next)
        printf ("%d\n", l->data);
}

void print_metalist (metalist_t *l)
{
    for (; l; l = l->next)
        printf ("%d\n", l->listitem->data);
}

int greater_than (int i, int *limit)
{
    return i > *limit;
}

list_t * cons (int i, list_t *tail)
{
    list_t *l = malloc (sizeof (list_t));
    l->next = tail;
    l->data = i;
    
    return l;
}

int main (int argc, char **argv)
{
    list_t *l = cons (30, cons (42, cons (53, cons (27, NULL))));

    int *limit = malloc (sizeof (limit));
    *limit = 28;
    
    metalist_t *filtered_list = filter (l, (list_predicate_t)greater_than, limit);
    print_metalist (filtered_list);    
    free_metalist (filtered_list);
    
    return 0;
}
