//
//  HaskellBackendTests.m
//  HaskellBackendTests
//
//  Created by Károly Lőrentey on 2011-02-08.
//  Copyright 2011 Gergő Érdi and Károly Lőrentey. All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without modification, are
//  permitted provided that the following conditions are met:
// 
//  1. Redistributions of source code must retain the above copyright notice, this list of
//  conditions and the following disclaimer.
// 
//  2. Redistributions in binary form must reproduce the above copyright notice, this list
//  of conditions and the following disclaimer in the documentation and/or other materials
//  provided with the distribution.
// 
//  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS OR
//  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
//  THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
//  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
//  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
//  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#import "HaskellBackendTests.h"
#import "LKHaskellWrapper.h"

@implementation HaskellBackendTests

- (void)testEngine
{
    LKHaskellWrapper *wrapper = [LKHaskellWrapper wrapper];

    STAssertNil([wrapper engine:@"short"], @"string too short");
    
    NSString *input = @"this should be long enough";
    NSArray *result = [wrapper engine:input];
    STAssertNotNil(result, @"Backend should return an array");
    STAssertTrue([result isKindOfClass:NSArray.class], @"Backend should return an array");
    STAssertEquals([input length], [result count], @"Array size should match string length");
    int i = 0;
    for (NSNumber *num in result) {
        STAssertEquals([num intValue], (int)[input characterAtIndex:i++], @"Character value mismatch");
    }
}

@end
