//
//  LKHaskellWrapper.m
//  AsymptoteHaskellBackend
//
//  Created by Károly Lőrentey on 2011-02-08.
//  Copyright 2011 Gergő Érdi and Károly Lőrentey. All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without modification, are
//  permitted provided that the following conditions are met:
// 
//  1. Redistributions of source code must retain the above copyright notice, this list of
//  conditions and the following disclaimer.
// 
//  2. Redistributions in binary form must reproduce the above copyright notice, this list
//  of conditions and the following disclaimer in the documentation and/or other materials
//  provided with the distribution.
// 
//  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS OR
//  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
//  THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
//  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
//  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
//  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#import "LKHaskellWrapper.h"
#import <dispatch/dispatch.h>

void hs_init(int *argc, char *(*argv)[]);
void hs_exit(void);

int engine(const char *input, char **error, int **result, int *length);

@implementation LKHaskellWrapper

- (id)init {
    self = [super init];
    if (self) {
        static dispatch_once_t onceToken;
        dispatch_once(&onceToken, ^{
            int argc = 0;
            char *argv[2];
            argv[0] = "dummy";
            argv[1] = NULL;
            hs_init(&argc, &argv);
#if 0 // hs_exit itself calls exit for some silly reason, so we must not ever call it.
            atexit(hs_exit);
#endif
        });
    }
    return self;
}

+ (LKHaskellWrapper *)wrapper {
    static LKHaskellWrapper *wrapper = NULL;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        wrapper = [[LKHaskellWrapper alloc] init];
    });
    return wrapper;
}

- (NSArray *)engine:(NSString *)input {
    const char *input_text = [input cStringUsingEncoding:NSUTF8StringEncoding];
    
    int *result = NULL, length = 0;
    char *err = NULL;
    if (engine(input_text, &err, &result, &length)) {
        //NSLog(@"Backend error: %s", err);
        free(err);
        return nil;
    }
    NSMutableArray *values = [NSMutableArray arrayWithCapacity:length];
    for (int i = 0; i < length; i++) {
        [values addObject:[NSNumber numberWithInt:result[i]]];
    }
    return values;
}

@end
