char jhc_c_compile[] = "gcc '-std=gnu99' -D_GNU_SOURCE '-falign-functions=4' -ffast-math -Wextra -Wall -Wno-unused-parameter -fno-strict-aliasing -m32 -m32 -m32 -m32 -o FFIHello.jhc.c FFIHello.jhc.c -DNDEBUG -O3 '-D_JHC_GC=_JHC_GC_JGC'";
char jhc_command[] = "jhc -fffi -fjgc --cross -mle32 -C FFIHello.hs -o FFIHello.jhc.c";
char jhc_version[] = "jhc 0.7.7 (0.7.7-14)";

#ifdef JHC_RTS_INCLUDE
#include "HsFFI.h"
#include "wsize.h"
#include "jhc_rts_header.h"
#include "jhc_jgc.h"
#include "debug.c"
#include "jhc_rts_alloc.c"
#include "jhc_rts.c"
#include "profile.c"
#include "jhc_rts2.c"
#include "bitarray.h"
#include "slub.c"
#include "jhc_jgc.c"
#include "lib_cbits.c"
#else
/* src/data/HsFFI.h */
/* HsFFI.h for jhc */

#ifndef _JHC_HSFFI_H
#define _JHC_HSFFI_H

#include <stdint.h>
#include <stdbool.h>
#include <stddef.h>


typedef int32_t HsInt;
typedef int8_t  HsInt8;
typedef int16_t HsInt16;
typedef int32_t HsInt32;
typedef int64_t HsInt64;

typedef uint32_t HsWord;
typedef uint8_t  HsWord8;
typedef uint16_t HsWord16;
typedef uint32_t HsWord32;
typedef uint64_t HsWord64;

typedef wchar_t HsChar;
typedef bool HsBool;

typedef double HsDouble;
typedef float HsFloat;

typedef void *HsPtr;
typedef void (*HsFunPtr)(void);
typedef void *HsStablePtr;

#define HS_BOOL_FALSE 0
#define HS_BOOL_TRUE 1

void hs_init (int *argc, char **argv[]);
void hs_exit (void);
void hs_set_argv(int argc, char *argv[]);
void hs_perform_gc(void);
void hs_free_stable_ptr(HsStablePtr sp);
void hs_free_fun_ptr(HsFunPtr fp);

#endif
/* src/rts/wsize.h */
#ifndef WSIZE_H
#define WSIZE_H

/*
 * wsize.h
 * define appropriate __WORDSIZE and __BYTE_ORDER macros
 *
 * always use operating systems headers rather than checking for architectures
 * when possible. if adding new cases. Checking the CPU type should be a last
 * resort.
 *
 */

#include <limits.h>

#ifdef __linux__
#include<endian.h>
#endif

#ifndef __LITTLE_ENDIAN
#define	__LITTLE_ENDIAN	1234
#endif
#ifndef __BIG_ENDIAN
#define	__BIG_ENDIAN	4321
#endif
#ifndef __PDP_ENDIAN
#define	__PDP_ENDIAN	3412
#endif

#ifndef __BYTE_ORDER
#ifdef _BIG_ENDIAN
#define __BYTE_ORDER __BIG_ENDIAN
#elif defined(__BIG_ENDIAN__)
#define __BYTE_ORDER __BIG_ENDIAN
#elif defined(_LITTLE_ENDIAN)
#define __BYTE_ORDER __LITTLE_ENDIAN
#elif defined(__LITTLE_ENDIAN__)
#define __BYTE_ORDER __LITTLE_ENDIAN
#elif defined(__i386__)
#define __BYTE_ORDER __LITTLE_ENDIAN
#else
#error Could not determine Byte Order
#endif
#endif

#ifndef __WORDSIZE
#ifdef __SIZEOF_POINTER__
#define __WORDSIZE (CHAR_BIT*__SIZEOF_POINTER__)
#elif defined(__i386__)
#define __WORDSIZE 32
#elif defined(__x86_64__)
#define __WORDSIZE 64
#else
#error Could not determine bitsize
#endif
#endif


#ifdef TEST_WSIZE
#include <stdio.h>
int
main(int argc, char *argv[])
{
    printf("__WORDSIZE:   %i\n", __WORDSIZE);
    printf("__BYTE_ORDER: %i\n", __BYTE_ORDER);
    return 0;
}
#endif

#endif
/* src/rts/jhc_rts_header.h */
#include <assert.h>
#include <errno.h>
#include <float.h>
#include <limits.h>
#include <locale.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <wchar.h>
#include <setjmp.h>
#ifndef __WIN32__
#include <sys/select.h>
#include <sys/times.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/utsname.h>
#else
#include <malloc.h>
#endif

// #define our options

#define _JHC_GC_NONE   0
#define _JHC_GC_JGC    1
#define _JHC_GC_BOEHM  2
#define _JHC_GC_REGION 3

#ifndef _JHC_GC
#define _JHC_GC _JHC_GC_NONE
#endif

#ifndef _JHC_PROFILE
#define _JHC_PROFILE 0
#endif

#ifndef _JHC_DEBUG
#ifdef NDEBUG
#define _JHC_DEBUG 0
#else
#define _JHC_DEBUG 1
#endif
#endif

#ifndef JHC_VALGRIND
#define JHC_VALGRIND 0
#endif

#ifndef JHC_MEM_ANNOTATE
#define JHC_MEM_ANNOTATE 0
#endif

#ifndef _JHC_STANDALONE
#define _JHC_STANDALONE 1
#endif

#ifndef JHC_STATUS
#define JHC_STATUS 0
#endif

// GNU attributes
#ifdef __GNUC__
#  define __predict_true(exp)     __builtin_expect(!!(exp), 1)
#  define __predict_false(exp)    __builtin_expect(!!(exp), 0)
#else
#  define __predict_true(exp)     (exp)
#  define __predict_false(exp)    (exp)
#endif

#ifdef __GNUC__
#define A_ALIGNED  __attribute__ ((aligned))
#define A_CONST    __attribute__ ((const))
#define A_MALLOC   __attribute__ ((malloc))
#define A_MAYALIAS __attribute__ ((__may_alias__))
#define A_NORETURN __attribute__ ((noreturn))
#define A_PURE     __attribute__ ((pure))
#define A_UNUSED   __attribute__ ((unused))
#ifdef __i386__
#define A_REGPARM __attribute__ ((fastcall))
#else
#define A_REGPARM
#endif
#define A_STD    A_REGPARM

#else
#define A_ALIGNED
#define A_CONST
#define A_MALLOC
#define A_MAYALIAS
#define A_NORETURN
#define A_PURE
#define A_UNUSED
#define A_STD
#endif

// these should be enabled with newer versions of gcc
#define A_HOT
#define A_COLD
#define A_FALIGNED

#define M_ALIGN(a,n) ((n) - 1 + ((a) - ((n) - 1) % (a)))

#ifdef __WIN32__
#define JHC_isWindows   1
#define JHC_isBigEndian 0
#else
#define JHC_isWindows 0
#define JHC_isBigEndian (__BYTE_ORDER == __BIG_ENDIAN)
#endif

#define JHC_isPosix (!JHC_isWindows)

static void _amain(void);

static void jhc_alloc_init(void);
static void jhc_alloc_fini(void);
static void jhc_alloc_print_stats(void);
static void jhc_print_profile(void);

static int jhc_argc;
static char **jhc_argv;
static char *jhc_progname;

#if JHC_STATUS > 1
#define debugf(...) fprintf(stderr,__VA_ARGS__)
#else
#define debugf(...) do { } while (0)
#endif
/* src/rts/jhc_jgc.h */
#if _JHC_GC == _JHC_GC_JGC

#ifdef JHC_JGC_STACK
struct frame;
typedef struct frame *gc_t;
#else
typedef void* *gc_t;
static gc_t gc_stack_base;
#endif

static gc_t saved_gc;

#define GC_BASE sizeof(void *)

#define TO_BLOCKS(x) ((x) <= GC_BASE ? 1 : (((x) - 1)/GC_BASE) + 1)

struct s_cache;
static void gc_perform_gc(gc_t gc);
static void *gc_alloc(gc_t gc,struct s_cache **sc, unsigned count, unsigned nptrs);

#endif
/* src/rts/debug.c */
#if JHC_VALGRIND
#include <valgrind/valgrind.h>
#include <valgrind/memcheck.h>
#else
#define VALGRIND_MAKE_MEM_UNDEFINED(x,y) \
    do { } while (0)
#define VALGRIND_MAKE_MEM_DEFINED(x,y) \
    do { } while (0)
#define VALGRIND_MAKE_MEM_NOACCESS(x,y) \
    do { } while (0)
#define VALGRIND_PRINTF(...) \
    do { } while (0)
#endif

#if JHC_MEM_ANNOTATE && _JHC_GC == _JHC_GC_JGC
#include <Judy.h>

static Pvoid_t mem_annotate = NULL;

#define XSTR(x) #x
#define STR(x) XSTR(x)
#define gc_alloc(gc,sc,c,nptrs) \
    gc_alloc_annot(gc,sc,c,nptrs,(__FILE__ ":" STR(__LINE__)))


A_UNUSED static void *
gc_alloc_annot(gc_t gc,struct s_cache **sc, unsigned count, unsigned nptrs, char *str)
{
        void *ret = (gc_alloc)(gc,sc,count,nptrs);
        PWord_t pval;
        JLI(pval,mem_annotate,(Word_t)ret);
        *pval = (Word_t)str;
        return ret;
}

char *
gc_lookup(void *ptr)
{
        PWord_t pval;
        JLG(pval,mem_annotate,(Word_t)ptr & ~(Word_t)3);
        return pval ? (char *)*pval : "(none)";
}


#endif
/* src/rts/jhc_rts_alloc.c */
#define jhc_malloc_whnf jhc_malloc
#define jhc_malloc_suspension jhc_malloc
#define jhc_malloc_atomic jhc_malloc
#define jhc_malloc_atomic_whnf jhc_malloc_atomic
#define jhc_malloc_sanity(p,t) (1)
#define _JHC_GC_CONTEXT 0

#ifdef JHC_ALLOC_NEEDS_STUBS
void hs_perform_gc(void) {}
void hs_free_stable_ptr(HsStablePtr sp) {}
void hs_free_fun_ptr(HsFunPtr fp) {}
#endif

#if _JHC_PROFILE

#define BUCKETS 7

static unsigned alloced[BUCKETS];
static unsigned alloced_atomic[BUCKETS];

static void
alloc_count(int n,int atomic)
{
        n = n ? ((n - 1)/sizeof(void *)) + 1 : 0;
        n = n > BUCKETS - 1 ? BUCKETS - 1 : n;
        (atomic ? alloced_atomic : alloced)[n]++;
}

static void
print_alloc_size_stats(void) {
        char fmt[] = "%10s %10s %10s %10s %10s\n";
        char fmt2[] = "%10u %10u %10u %10u %10u\n";
        fprintf(stderr,fmt,"Size","Normal","Atomic","Total","Accum");
        fprintf(stderr,fmt,"----","------","------","-----","-----");
        unsigned accum = 0;
        for(int i = 0; i < BUCKETS; i++) {
                accum += alloced[i] + alloced_atomic[i];
                fprintf(stderr,fmt2,i,alloced[i],alloced_atomic[i],alloced_atomic[i] + alloced[i], accum);
        }
}

#else

#define alloc_count(x,y)
#define print_alloc_size_stats()

#endif

#if _JHC_GC == _JHC_GC_BOEHM

#include <gc/gc.h>

#define jhc_malloc GC_malloc
#undef  jhc_malloc_atomic
#define jhc_malloc_atomic GC_malloc_atomic
#define jhc_free GC_free

static void jhc_alloc_init(void) { GC_INIT(); }
static void jhc_alloc_fini(void) { }
static void jhc_alloc_print_stats(void) { }

#elif _JHC_GC == _JHC_GC_NONE

// memory allocated in 1MB chunks.
#define JHC_MEM_CHUNK_SIZE (1 << 20)

static char initial_chunk[JHC_MEM_CHUNK_SIZE];

static void *jhc_current_chunk = initial_chunk;
static unsigned mem_chunks,mem_offset;


static void jhc_alloc_init(void) {}
static void jhc_alloc_fini(void) {}

static void
jhc_alloc_print_stats(void) {
        fprintf(stderr, "Memory Allocated: %u bytes\n", (JHC_MEM_CHUNK_SIZE*(mem_chunks)) + mem_offset);
        print_alloc_size_stats();
}

static void
jhc_malloc_grow(void) {
        void *c = malloc(JHC_MEM_CHUNK_SIZE);
        if(!c) {
                fputs("Out of memory!\n",stderr);
                abort();
        }
        mem_chunks++;
        jhc_current_chunk = c;
        mem_offset = 0;
}

static inline void * A_MALLOC
jhc_malloc_basic(size_t n) {
        n = M_ALIGN(sizeof(void *),n);
        if (n > (JHC_MEM_CHUNK_SIZE - mem_offset))
                jhc_malloc_grow();
        void *ret = jhc_current_chunk + mem_offset;
        mem_offset += n;
        return ret;
}


#if _JHC_DEBUG

#define jhc_malloc(n) jhc_malloc_debug(n,__LINE__,0)
#undef jhc_malloc_atomic
#define jhc_malloc_atomic(n) jhc_malloc_debug(n,__LINE__,1)

static void * A_MALLOC
jhc_malloc_debug(size_t n,int line,int atomic) {
        alloc_count(n,atomic);
        void *ret = jhc_malloc_basic(n + sizeof(uintptr_t));
        *((uintptr_t *)ret) = line;
        return ret + sizeof(uintptr_t);
}

#else

static inline void * A_MALLOC
jhc_malloc(size_t n) {
        alloc_count(n,0);
        return jhc_malloc_basic(n);
}

#undef jhc_malloc_atomic
static inline void * A_MALLOC
jhc_malloc_atomic(size_t n) {
        alloc_count(n,1);
        return jhc_malloc_basic(n);
}


#endif

#endif
/* src/rts/jhc_rts.c */
static jmp_buf jhc_uncaught;

#ifdef __WIN32__
A_UNUSED static char *jhc_options_os =  "mingw32";
A_UNUSED static char *jhc_options_arch = "i386";
#else
A_UNUSED struct utsname jhc_utsname;
A_UNUSED static char *jhc_options_os = "(unknown os)";
A_UNUSED static char *jhc_options_arch = "(unknown arch)";
#endif


static void A_NORETURN A_UNUSED A_COLD
jhc_exit(int n) {
        fflush(stdout);
        jhc_print_profile();
        exit(n);
}

static void  A_NORETURN A_UNUSED  A_COLD
jhc_error(char *s) {
        fflush(stdout);
        fputs(s,stderr);
        fputs("\n",stderr);
        jhc_exit(1);
}

static void  A_NORETURN A_UNUSED  A_COLD
jhc_case_fell_off(int n) {
        fflush(stdout);
        fprintf(stderr, "\n%s:%i: case fell off\n", __FILE__, n);
        abort();
}

#define jhc_setjmp(jb) setjmp(*(jb))
#define jhc_longjmp(jb) longjmp(*(jb),1)

struct jhc_continuation {
    void *argument;
    jmp_buf jump_buf;
};

#define prim_umaxbound(t) ((t)~((t)0))
#define prim_maxbound(t) ((t)(~((t)1 << (sizeof(t)*8 - 1))))
#define prim_minbound(t) ((t)(((t)1 << (sizeof(t)*8 - 1))))

void
hs_set_argv(int argc, char *argv[])
{
        jhc_argc = argc - 1;
        jhc_argv = argv + 1;
        jhc_progname = argv[0];
}

static int hs_init_count;

static void jhc_hs_init(void);

void
hs_init(int *argc, char **argv[])
{

        if(!hs_init_count++) {
                /* A few random assertions about the architecture that the compiler
                 * assumes. should be true of any but the oddest of beasts. */
                assert(sizeof(HsPtr) == sizeof(HsFunPtr));
                assert(sizeof(HsPtr) == sizeof(intptr_t));
                assert(sizeof(HsPtr) == sizeof(uintptr_t));
                assert(CHAR_BIT == 8);
                assert(EOF == -1);

                jhc_alloc_init();
                jhc_hs_init();
                hs_set_argv(*argc,*argv);
#if JHC_isPosix
                if(!uname(&jhc_utsname)) {
                        jhc_options_arch = jhc_utsname.machine;
                        jhc_options_os   = jhc_utsname.sysname;
                }
#endif
                setlocale(LC_ALL,"");
        }
}

void
hs_exit(void)
{
        if(!hs_init_count) {
                fprintf(stderr, "hs_exit() called before hs_init()\n");
                abort();
        }
        if(!--hs_init_count) {
                jhc_alloc_fini();
                jhc_exit(0);
        }
}

#if _JHC_STANDALONE
int
main(int argc, char *argv[])
{
        hs_init(&argc,&argv);
        if (jhc_setjmp(&jhc_uncaught))
                jhc_error("Uncaught Exception");
        else
                _amain();
        hs_exit();
        return 0;
}
#endif

/* src/rts/profile.c */
static void A_UNUSED
profile_print_header(FILE *file, char *value_unit)
{
        fprintf(file, "JOB \"%s", jhc_progname);
        for(int i = 0; i < jhc_argc; i++)
                fprintf(file, " %s", jhc_argv[i]);
        fprintf(file, "\"\n");
        fprintf(file, "DATE \"%s\"\n", ctime(NULL));
        fprintf(file, "SAMPLE_UNIT \"seconds\"\n");
        fprintf(file, "VALUE_UNIT \"%s\"\n", value_unit ? value_unit : "bytes");
}

#if _JHC_PROFILE

struct profile_stack {
    struct tms tm_total;
    struct tms tm_pushed;
};

struct profile_stack gc_alloc_time;
struct profile_stack gc_gc_time;


void
profile_push(struct profile_stack *ps)
{
        times(&ps->tm_pushed);
}

void
profile_pop(struct profile_stack *ps)
{
    struct tms tm;
    times(&tm);
    ps->tm_total.tms_utime += tm.tms_utime - ps->tm_pushed.tms_utime;
    ps->tm_total.tms_stime += tm.tms_stime - ps->tm_pushed.tms_stime;
}


#else

#define profile_push(x) do { } while(0)
#define profile_pop(x) do { } while(0)

#endif

#ifndef __WIN32__
void print_times(struct tms *tm) {
    float cpt = (float)sysconf(_SC_CLK_TCK);
    fprintf(stderr, "User Time:   %.2fs\n", (float)tm->tms_utime/cpt);
    fprintf(stderr, "System Time: %.2fs\n", (float)tm->tms_stime/cpt);
    fprintf(stderr, "Total Time:  %.2fs\n", (float)(tm->tms_stime + tm->tms_utime)/cpt);
}
#endif

static void A_COLD
jhc_print_profile(void) {
#ifndef __WIN32__
        struct tms tm;
        times(&tm);
#endif
        if(!(_JHC_PROFILE || getenv("JHC_RTS_PROFILE"))) return;

        fprintf(stderr, "\n-----------------\n");
        fprintf(stderr, "Profiling: %s\n", jhc_progname);
        fprintf(stderr, "Command: %s\n", jhc_command);
        fprintf(stderr, "Complie: %s\n", jhc_c_compile);
        fprintf(stderr, "Version: %s\n\n", jhc_version);
        jhc_alloc_print_stats();
#ifndef __WIN32__
        print_times(&tm);
#if _JHC_PROFILE
        print_times(&gc_gc_time.tm_total);
        print_times(&gc_alloc_time.tm_total);
#endif
#endif
        fprintf(stderr, "-----------------\n");
}
/* src/rts/jhc_rts2.c */
/*@Internals

# The Run Time System

Jhc is very minimalist in that it does not have a precompiled run time system,
but rather generates what is needed as part of the compilation process.
However, back ends do have specific run-time representations of data, which can
be affected by things like the choice of garbage collector. The following
describes the general layout for the C based back-ends, but compiler options
such as garbage collection method or whether we do full program analysis, will
affect which features are used and whether certain optimized layouts are
possible.

Unboxed values directly translate to values in the target language, an unboxed
Int will translate directly into an 'int' as an argument and an unboxed pointer
will be a raw pointer. Unboxed values have no special interpretation and are
_not_ followed by the garbage collector. If the target language does not
support a feature such as multiple return values, it will have to be simulated.
It would not be wrong to think of Grin code that only deals with unboxed values
to be isomorphic to C-- or C augmented with multiple return values.

Boxed values have a standard representation and can be followed. Unlike some
other implementation, being boxed does not imply the object is located on the
heap. It may be on the stack, heap, or even embedded within the smart pointer
itself. Being boxed only means that the object may be represented by a smart
pointer, which may or may not actually be a pointer in the traditional sense.

A boxed value in jhc is represented by a 'smart pointer' of c type sptr_t. a
smart pointer is the size of a native pointer, but can take on different roles
depending on a pair of tag bits, called the ptype.

smart pointers take on a general form as follows:

    -------------------------
    |    payload        | GL|
    -------------------------

      G - if set, then the garbage collector should not treat value as a pointer to be followed
      L - lazy, this bit being set means the value is potentially not in WHNF

A sptr_t on its own in the wild can only take on one of the following forms:

    -------------------------
    |    whnf raw value | 10|
    -------------------------

    -------------------------
    |    whnf location  | 00|
    -------------------------

WHNF stands for 'Weak Head Normal Form' and means that the value is not a
suspended function and hence not a pointer to a thunk. It may be directly
examined and need not be evaluated. wptr_t is an alias for sptr_t that is
guarenteed to be of one of the above forms. It is used to improve safety for
when we can statically know that a value is WHNF and hence we can skip the
expensive 'eval'.

The difference between the raw value and the whnf location is that the first
contains uninterpreted bits, while the second is a pointer to a location on the
heap or stack and hence the garbage collector should follow it. The format of
the memory pointed to by the whnf location is unspecified and dependent on the
actual type being represented.

Partial (unsaturated) applications are normal WHNF values. Saturated
applications which may be 'eval'ed and updated are called thunks and must not
be pointed to by WHNF pointers. Their representation follows.

    -------------------------
    |   lazy location   | 01|
    -------------------------

A lazy location points to either a thunk, or a redirection to a WHNF value. A
lazy location is always a pointer to an allocated block of memory which always
begins with a restricted smart pointer. This restricted smart pointer is represented by
the C type alias 'fptr_t'. fptr_t's only occur as the first entry in a lazy
location, they never are passed around as objects in their own right.

A fptr_t may be a whnf value or a code pointer. If a fptr_t is a whnf value (of one of
the two forms given above) then it is called a redirection, the lazy location should be
treated exactly as if it were the whnf given. This is used to redirect an evaluated
thunk to its computed value.

A fptr_t may also be a 'code pointer' in which case the lazy location is called
a thunk. A code pointer is a pointer to executable machine code that evaluates
a closure and returns a wptr_t, the returned wptr_t is then generally written
over the code pointer, turning the thunk into a redirection. It is the
responsibility of the code pointed to to perform this redirection.

    -------------------------
    |    code pointer   | 11|
    -------------------------
    |     data ...          |

When debugging, the special code pointer BLACK_HOLE is also sometimes stored in
a fptr_t to detect certain run-time errors.

Note that unlike other implementations, a fptr_t may _not_ be another lazy
location. you can not have chained redirections, a redirection is always a
redirection to a whnf value.

    sptr_t - a tagged smart pointer, may contain a whnf value or a lazy location.
    wptr_t - a tagged smart pointer that contains a whnf value (either raw or a location)
    fptr_t - a tagged smart pointer, may contain a whnf value indicating a redirection, or a code pointer indicating a thunk.

*/

#define P_WHNF  0x0
#define P_LAZY  0x1
#define P_VALUE 0x2
#define P_FUNC  0x3

#define IS_LAZY(x)     (bool)(((uintptr_t)(x)) & 0x1)
#define IS_PTR(x)      (bool)(!(((uintptr_t)(x)) & 0x2))

#define FROM_SPTR(x)   (typeof (x))((uintptr_t)(x) & ~0x3)  // remove a ptype from a smart pointer
#define GET_PTYPE(x)   ((uintptr_t)(x) & 0x3)               // return the ptype associated with a smart pointer
#define TO_SPTR(t,x)   (typeof (x))((uintptr_t)(x) | (t))   // attach a ptype to a smart pointer
#define TO_SPTR_C(t,x) (typeof (x))((uintptr_t)(x) + (t))   // attach a ptype to a smart pointer, suitable for use by constant initialializers

#define GETHEAD(x)   (NODEP(x)->head)
#define NODEP(x)     ((node_t *)(x))
#define DNODEP(x)    ((dnode_t *)(x))

#define MKLAZY(fn)    TO_SPTR(P_LAZY,(sptr_t)fn)
#define MKLAZY_C(fn)  TO_SPTR_C(P_LAZY,(sptr_t)fn)
#define TO_FPTR(fn)   TO_SPTR_C(P_FUNC,(fptr_t)fn)

#define RAW_SET_F(n)   ((wptr_t)(((intptr_t)(n) << 2) | P_VALUE))
#define RAW_SET_UF(n)  ((wptr_t)(((uintptr_t)(n) << 2) | P_VALUE))
#define RAW_GET_F(n)   ((intptr_t)(n) >> 2)
#define RAW_GET_UF(n)  ((uintptr_t)(n) >> 2)

#define RAW_SET_16(w)  (wptr_t)(((uintptr_t)(w) << 16) | P_VALUE)
#define RAW_GET_16(n)  ((intptr_t)(n) >> 16)
#define RAW_GET_U16(n) ((uintptr_t)(n) >> 16)

// demote is always safe, we must only promote when we know the argument is a WHNF
#define PROMOTE(n)   ((wptr_t)(n))
#define DEMOTE(n)    ((sptr_t)(n))

#define FETCH_TAG(x)      RAW_GET_U16(IS_PTR(x) ? FETCH_MEM_TAG(x) : (what_t)(x))
#define FETCH_RAW_TAG(x)  RAW_GET_U16(x)
#define SET_RAW_TAG(x)    RAW_SET_16(x)
#define FETCH_MEM_TAG(x)  (DNODEP(x)->what)
#define SET_MEM_TAG(x,v)  (DNODEP(x)->what = (what_t)RAW_SET_16(v))



#define BLACK_HOLE TO_FPTR(0xDEADBEE0)

struct sptr {};
struct wptr {};
struct fptr {};

// we use dummy structs here so the compiler will catch any attempt
// to use one type in anothers place
typedef struct sptr * sptr_t;
typedef struct wptr * wptr_t;
typedef struct fptr * fptr_t;
typedef uintptr_t     what_t;


typedef struct node {
        fptr_t head;
        sptr_t rest[];
} A_MAYALIAS node_t;

typedef struct dnode {
        what_t what;
        sptr_t rest[];
} A_MAYALIAS dnode_t;

#if _JHC_DEBUG

// these ensure the type synonyms are available to the debugger
uintptr_t _dummy1;
node_t *_dummy2;
dnode_t *_dummy3;
sptr_t *_dummy4;
fptr_t *_dummy5;
wptr_t *_dummy6;


static bool A_UNUSED
jhc_valid_whnf(wptr_t s)
{
        return ((GET_PTYPE(s) == P_VALUE) || ((GET_PTYPE(s) == P_WHNF) && jhc_malloc_sanity(s,P_WHNF)));
}

static bool A_UNUSED
jhc_valid_lazy(sptr_t s)
{
        if(jhc_valid_whnf((wptr_t)s))
                return true;
        assert(GET_PTYPE(s) == P_LAZY);
        node_t *ds = (node_t *)FROM_SPTR(s);
        assert(jhc_malloc_sanity(ds,P_LAZY));
        if(IS_LAZY(ds->head)) {
                if(ds->head == BLACK_HOLE) return true;
                assert(GET_PTYPE(ds->head) == P_FUNC);
                return true;
        } else
                return jhc_valid_whnf((wptr_t)ds->head);
}


#else

#define jhc_valid_whnf(x) true
#define jhc_valid_lazy(x) true

#endif


#if _JHC_GC == _JHC_GC_JGC
typedef wptr_t (*eval_fn)(gc_t gc,node_t *node) A_STD;
#else
typedef wptr_t (*eval_fn)(node_t *node) A_STD;
#endif

// both promote and demote evaluate to nothing when debugging is not enabled
// otherwise, they check that their arguments are in the correct form.

static inline wptr_t A_STD A_UNUSED  A_HOT
promote(sptr_t s)
{
        assert(!IS_LAZY(s));
        assert(jhc_valid_whnf((wptr_t)s));
        return (wptr_t)s;
}

static inline sptr_t A_STD A_UNUSED A_HOT
demote(wptr_t s)
{
        assert(!IS_LAZY(s));
        assert(jhc_valid_whnf(s));
        return (sptr_t)s;
}

// like eval but you know the target is in WHNF or is a already evaluated indirection
static inline wptr_t A_STD A_UNUSED  A_HOT
follow(sptr_t s)
{
        assert(jhc_valid_lazy(s));
        if(IS_LAZY(s)) {
                sptr_t h = (sptr_t)(GETHEAD(FROM_SPTR(s)));
                assert(!IS_LAZY(h));
                return (wptr_t)h;
        }
        return (wptr_t)s;
}

static wptr_t A_STD A_UNUSED  A_HOT
#if _JHC_GC == _JHC_GC_JGC
eval(gc_t gc,sptr_t s)
#else
eval(sptr_t s)
#endif
{
        assert(jhc_valid_lazy(s));
        if(IS_LAZY(s)) {
                assert(GET_PTYPE(s) == P_LAZY);
                void *ds = FROM_SPTR(s);
                sptr_t h = (sptr_t)(GETHEAD(ds));
                assert((fptr_t)h != BLACK_HOLE);
                if(IS_LAZY(h)) {
                        eval_fn fn = (eval_fn)FROM_SPTR(h);
                        assert(GET_PTYPE(h) == P_FUNC);
#if _JHC_DEBUG
                        GETHEAD(ds) = BLACK_HOLE;
#endif
#if _JHC_GC == _JHC_GC_JGC
                        wptr_t r = (*fn)(gc,NODEP(ds));
#else
                        wptr_t r = (*fn)(NODEP(ds));
#endif
#if _JHC_DEBUG
                        assert(GETHEAD(ds) != BLACK_HOLE);
#endif
                        return r;
                }
                return (wptr_t)h;
        }
        assert(jhc_valid_whnf((wptr_t)s));
        return (wptr_t)s;
}


static void A_STD A_UNUSED A_HOT
update(void * thunk, wptr_t new)
{
        assert(GETHEAD(thunk) == BLACK_HOLE);
        assert(!IS_LAZY(new));
        GETHEAD(thunk) = (fptr_t)new;
}
/* src/rts/bitarray.h */
#ifndef BITARRAY_H
#define BITARRAY_H

#include <limits.h>
#include <stdbool.h>

typedef unsigned long bitarray_t;

#define BITS_PER_UNIT (bitarray_t)(CHAR_BIT*sizeof(bitarray_t))
#define BITARRAY_SIZE(bits) (((bits) + (BITS_PER_UNIT - 1)) / BITS_PER_UNIT)
#define BITARRAY_SIZE_IN_BYTES(bits) (sizeof(bitarray_t)*BITARRAY_SIZE(bits))

#define WHICH_BIT(bit)  \
    (1UL << ((((bitarray_t)(bit)) % BITS_PER_UNIT)))

#define OFFSET_IN_ARRAY(array,bit) \
    (((bitarray_t *)(array))[((bitarray_t)(bit)) / BITS_PER_UNIT])

#define BIT_IS_SET(array,bit)  \
    (OFFSET_IN_ARRAY(array,bit) & WHICH_BIT(bit))

#define BIT_IS_UNSET(array,bit) \
    (!(BIT_IS_SET(array,bit)))

#define BIT_SET(array,bit) \
    (OFFSET_IN_ARRAY(array,bit) |= WHICH_BIT(bit))

#define BIT_UNSET(array,bit) \
    (OFFSET_IN_ARRAY(array,bit) &= ~WHICH_BIT(bit))

#define BIT_TOGGLE(array,bit) \
    (OFFSET_IN_ARRAY(array,bit) ^= WHICH_BIT(bit))

#define BIT_COPY(dest,src,bit)  \
    do { BIT_IS_SET((src),(bit)) ? BIT_SET((dest),(bit)) : BIT_UNSET((dest),(bit)) } while(0)

#define BIT_VALUE(array,bit) \
    (BIT_IS_SET((array),(bit)) ? true : false)

#define BIT_SET_VALUE(array,bit,value) \
    do { (value) ? BIT_SET((array),(bit)) : BIT_UNSET((array),(bit)) } while(0)

#endif
/* src/rts/slub.c */
#if _JHC_GC == _JHC_GC_JGC
/*
 * Singly-linked List definitions.
 */
#define	SLIST_HEAD(name, type)						\
struct name {								\
	struct type *slh_first;	/* first element */			\
}
#define	SLIST_ENTRY(type)						\
struct {								\
	struct type *sle_next;	/* next element */			\
}
#define	SLIST_INIT(head) do {						\
	(head)->slh_first = NULL;					\
} while (/*CONSTCOND*/0)
#define	SLIST_INSERT_HEAD(head, elm, field) do {			\
	(elm)->field.sle_next = (head)->slh_first;			\
	(head)->slh_first = (elm);					\
} while (/*CONSTCOND*/0)
#define	SLIST_REMOVE_HEAD(head, field) do {				\
	(head)->slh_first = (head)->slh_first->field.sle_next;		\
} while (/*CONSTCOND*/0)
#define	SLIST_FIRST(head)	((head)->slh_first)
#define	SLIST_NEXT(elm, field)	((elm)->field.sle_next)
#define	SLIST_FOREACH(var, head, field)					\
	for((var) = (head)->slh_first; (var); (var) = (var)->field.sle_next)


#define BLOCK_SIZE     (1UL << 12)
#define MEGABLOCK_SIZE (1UL << 20)


#define S_BLOCK(val) (struct s_block *)((uintptr_t)(val) & ~ (BLOCK_SIZE - 1))

struct s_arena {
        struct s_megablock *current_megablock;
        SLIST_HEAD(,s_block) free_blocks;
        unsigned block_used;
        unsigned block_threshold;
        SLIST_HEAD(,s_cache) caches;
        SLIST_HEAD(,s_megablock) megablocks;
};

struct s_megablock {
        void *base;
        unsigned next_free;
        SLIST_ENTRY(s_megablock) next;
};

struct s_block_info {
        unsigned char color;
        unsigned char size;
        unsigned char num_ptrs;
};

struct s_block {
        SLIST_ENTRY(s_block) link;
        struct s_block_info pi;
        unsigned short num_free;
        unsigned short next_free;
        bitarray_t used[];
};

struct s_cache {
        SLIST_ENTRY(s_cache) next;
        SLIST_HEAD(,s_block) blocks;
        SLIST_HEAD(,s_block) full_blocks;
        struct s_block_info pi;
        unsigned short num_entries;
        struct s_arena *arena;
};


/* This finds a bit that isn't set, sets it, then returns its index.  It
 * assumes that a bit is available to be found, otherwise it goes into an
 * infinite loop. */

static unsigned
bitset_find_free(unsigned *next_free,int n,bitarray_t ba[static n]) {
        assert(*next_free < (unsigned)n);
        unsigned i = *next_free;
        do {
                int o = __builtin_ffsl(~ba[i]);
                if(__predict_true(o)) {
                        ba[i] |= (1UL << (o - 1));
                        *next_free = i;
                        return (i*BITS_PER_UNIT + (o - 1));
                }
                i = (i + 1) % n;
                assert(i != *next_free);
        } while (1);
}

struct s_megablock *
s_new_megablock(struct s_arena *arena)
{
        struct s_megablock *mb = malloc(sizeof(*mb));
#if defined(__WIN32__)
        mb->base = _aligned_malloc(MEGABLOCK_SIZE, BLOCK_SIZE);
        int ret = !mb->base;
#elif (defined(__ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__ <  1060)
        assert(sysconf(_SC_PAGESIZE) == BLOCK_SIZE);
        mb->base = valloc(MEGABLOCK_SIZE);
        int ret = !mb->base;
#else
        int ret = posix_memalign(&mb->base,BLOCK_SIZE,MEGABLOCK_SIZE);
#endif
        if(ret != 0) {
                fprintf(stderr,"Unable to allocate memory for megablock\n");
                abort();
        }
        VALGRIND_MAKE_MEM_NOACCESS(mb->base,MEGABLOCK_SIZE);
        //VALGRIND_FREELIKE_BLOCK(mb->base,0);
        mb->next_free = 0;
        return mb;
}

/* block allocator */

static unsigned block_threshold = 8;

static struct s_block *
get_free_block(gc_t gc, struct s_arena *arena) {
        arena->block_used++;
        if(__predict_true(SLIST_FIRST(&arena->free_blocks))) {
                struct s_block *pg = SLIST_FIRST(&arena->free_blocks);
                SLIST_REMOVE_HEAD(&arena->free_blocks,link);
                return pg;
        } else {
                if((arena->block_used >= arena->block_threshold)) {
                        gc_perform_gc(gc);
                        // if we are still using 80% of the heap after a gc, raise the threshold.
                        if(__predict_false((unsigned)arena->block_used * 10 >= arena->block_threshold * 9)) {
                                arena->block_threshold *= 2;
                        }
                }
                if(__predict_false(!arena->current_megablock))
                        arena->current_megablock = s_new_megablock(arena);
                struct s_megablock *mb = arena->current_megablock;
                struct s_block *pg = mb->base + BLOCK_SIZE*mb->next_free;
                mb->next_free++;
                if(mb->next_free == MEGABLOCK_SIZE / BLOCK_SIZE) {
                        SLIST_INSERT_HEAD(&arena->megablocks,mb, next);
                        arena->current_megablock = NULL;
                }
                VALGRIND_MAKE_MEM_UNDEFINED(pg,sizeof(struct s_block));
                pg->num_free = 0;
                return pg;
        }
}

static void
s_cleanup_blocks(struct s_arena *arena) {
        struct s_cache *sc = SLIST_FIRST(&arena->caches);
        for(;sc;sc = SLIST_NEXT(sc,next)) {

                // 'best' keeps track of the block with the fewest free spots
                // and percolates it to the front, effectively a single pass
                // of a bubblesort to help combat fragmentation. It does
                // not increase the complexity of the cleanup algorithm as
                // we had to scan every block anyway, but over many passes
                // of the GC it will eventually result in a more sorted list
                // than would occur by chance.

                struct s_block *best = NULL;
                int free_best = 4096;
                struct s_block *pg = SLIST_FIRST(&sc->blocks);
                struct s_block *fpg = SLIST_FIRST(&sc->full_blocks);
                SLIST_INIT(&sc->blocks);
                SLIST_INIT(&sc->full_blocks);
                if(!pg) {
                        pg = fpg;
                        fpg = NULL;
                }
                while(pg) {
                        struct s_block *npg = SLIST_NEXT(pg,link);
                        if(__predict_false(pg->num_free == 0)) {
                                SLIST_INSERT_HEAD(&sc->full_blocks,pg,link);
                        } else if(__predict_true(pg->num_free == sc->num_entries)) {
                                arena->block_used--;
                                VALGRIND_MAKE_MEM_NOACCESS((char *)pg + sizeof(struct s_block), BLOCK_SIZE - sizeof(struct s_block));
                                SLIST_INSERT_HEAD(&arena->free_blocks,pg,link);
                        } else {
                                if(!best) {
                                        free_best = pg->num_free;
                                        best = pg;
                                } else {
                                        if(pg->num_free < free_best) {
                                                struct s_block *tmp = best;
                                                best = pg; pg = tmp;
                                                free_best = pg->num_free;
                                        }
                                        SLIST_INSERT_HEAD(&sc->blocks,pg,link);
                                }
                        }
                        if(!npg && fpg) {
                                pg = fpg;
                                fpg = NULL;
                        } else
                                pg = npg;
                }
                if(best)
                        SLIST_INSERT_HEAD(&sc->blocks,best,link);
        }
}

inline static void
clear_block_used_bits(unsigned num_entries, struct s_block *pg)
{
        pg->num_free = num_entries;
        memset(pg->used,0,BITARRAY_SIZE_IN_BYTES(num_entries) - sizeof(pg->used[0]));
        int excess = num_entries % BITS_PER_UNIT;
        pg->used[BITARRAY_SIZE(num_entries) - 1] = ~((1UL << excess) - 1);
#if JHC_VALGRIND
                unsigned header =  sizeof(struct s_block) + BITARRAY_SIZE_IN_BYTES(num_entries);
                VALGRIND_MAKE_MEM_NOACCESS((char *)pg + header, BLOCK_SIZE - header);
#endif
}

static void *
s_alloc(gc_t gc, struct s_cache *sc)
{
        struct s_block *pg = SLIST_FIRST(&sc->blocks);
        if(__predict_false(!pg)) {
                pg = get_free_block(gc, sc->arena);
                VALGRIND_MAKE_MEM_NOACCESS(pg, BLOCK_SIZE);
                VALGRIND_MAKE_MEM_DEFINED(pg, sizeof(struct s_block));
                if(sc->num_entries != pg->num_free)
                        VALGRIND_MAKE_MEM_UNDEFINED((char *)pg->used,BITARRAY_SIZE_IN_BYTES(sc->num_entries));
                else
                        VALGRIND_MAKE_MEM_DEFINED((char *)pg->used,BITARRAY_SIZE_IN_BYTES(sc->num_entries));
                assert(pg);
                pg->pi = sc->pi;
                pg->next_free = 0;
                SLIST_INSERT_HEAD(&sc->blocks,pg,link);
                if(sc->num_entries != pg->num_free)
                        clear_block_used_bits(sc->num_entries, pg);
                pg->used[0] = 1; //set the first bit
                pg->num_free = sc->num_entries - 1;
                return (uintptr_t *)pg + pg->pi.color;
        } else {
                __builtin_prefetch(pg->used,1);
                pg->num_free--;
                unsigned next_free = pg->next_free;
                unsigned found = bitset_find_free(&next_free,BITARRAY_SIZE(sc->num_entries),pg->used);
                pg->next_free = next_free;
                void *val = (uintptr_t *)pg + pg->pi.color + found*pg->pi.size;
                if(__predict_false(0 == pg->num_free)) {
                        assert(pg == SLIST_FIRST(&sc->blocks));
                        SLIST_REMOVE_HEAD(&sc->blocks,link);
                        SLIST_INSERT_HEAD(&sc->full_blocks,pg,link);
                }
                assert(S_BLOCK(val) == pg);
                //printf("s_alloc: val: %p s_block: %p size: %i color: %i found: %i num_free: %i\n", val, pg, pg->pi.size, pg->pi.color, found, pg->num_free);
                return val;
        }
}

/*
static void
s_free(void *val)
{
        assert(val);
        struct s_block *pg = s_block(val);
        unsigned int offset = ((uintptr_t *)val - (uintptr_t *)pg) - pg->pi.color;
//        printf("s_free:  val: %p s_block: %p size: %i color: %i num_free: %i offset: %i bit: %i\n", val, pg, pg->pi.size, pg->pi.color, pg->num_free, offset, offset/pg->pi.size);
        assert(BIT_VALUE(pg->used,offset/(pg->pi.size)));
        BIT_UNSET(pg->used,offset/(pg->pi.size));
        pg->num_free++;
}
*/

static struct s_cache *
new_cache(struct s_arena *arena, unsigned short size, unsigned short num_ptrs)
{
        struct s_cache *sc = malloc(sizeof(*sc));
        sc->arena = arena;
        sc->pi.size = size;
        sc->pi.num_ptrs = num_ptrs;
        size_t excess = BLOCK_SIZE - sizeof(struct s_block);
        sc->num_entries = (8*excess) / (8*sizeof(uintptr_t)*size + 1) - 1;
        //sc->num_entries = (8*excess) / (8*size*sizeof(uintptr_t) + 1);
        sc->pi.color = (sizeof(struct s_block) + BITARRAY_SIZE_IN_BYTES(sc->num_entries) + sizeof(uintptr_t) - 1) / sizeof(uintptr_t);
        SLIST_INIT(&sc->blocks);
        SLIST_INIT(&sc->full_blocks);
        SLIST_INSERT_HEAD(&arena->caches,sc,next);
        //print_cache(sc);
        return sc;
}


// clear all used bits, must be followed by a marking phase.
static void
clear_used_bits(struct s_arena *arena)
{
        struct s_cache *sc = SLIST_FIRST(&arena->caches);
        for(;sc;sc = SLIST_NEXT(sc,next)) {
                struct s_block *pg = SLIST_FIRST(&sc->blocks);
                struct s_block *fpg = SLIST_FIRST(&sc->full_blocks);
                do {
                        for(;pg;pg = SLIST_NEXT(pg,link))
                                clear_block_used_bits(sc->num_entries,pg);
                        pg = fpg;
                        fpg = NULL;
                }  while(pg);
        }
}

// set a used bit. returns true if the
// tagged node should be scanned by the GC.
// this happens when the used bit was not previously set
// and the node contains internal pointers.

static bool
s_set_used_bit(void *val)
{
        assert(val);
        struct s_block *pg = S_BLOCK(val);
        unsigned int offset = ((uintptr_t *)val - (uintptr_t *)pg) - pg->pi.color;
        if(__predict_true(BIT_IS_UNSET(pg->used,offset/pg->pi.size))) {
                BIT_SET(pg->used,offset/pg->pi.size);
                pg->num_free--;
                return (bool)pg->pi.num_ptrs;
        }
        return false;
}

static struct s_cache *
find_cache(struct s_cache **rsc, struct s_arena *arena, unsigned short size, unsigned short num_ptrs)
{
        if(__predict_true(rsc && *rsc))
                return *rsc;
        struct s_cache *sc = SLIST_FIRST(&arena->caches);
        for(;sc;sc = SLIST_NEXT(sc,next)) {
                if(sc->pi.size == size && sc->pi.num_ptrs == num_ptrs)
                        goto found;
        }
        sc = new_cache(arena,size,num_ptrs);
found:
        if(rsc)
                *rsc = sc;
        return sc;
}

struct s_arena *
new_arena(void) {
        struct s_arena *arena = malloc(sizeof(struct s_arena));
        SLIST_INIT(&arena->caches);
        SLIST_INIT(&arena->free_blocks);
        SLIST_INIT(&arena->megablocks);
        arena->block_used = 0;
        arena->block_threshold = 8;
        arena->current_megablock = NULL;
        return arena;
}

void
print_cache(struct s_cache *sc) {
        fprintf(stderr, "num_entries: %i\n",(int)sc->num_entries);
//        printf("  entries: %i words\n",(int)(sc->num_entries*sc->pi.size));
        fprintf(stderr, "  header: %lu bytes\n", sizeof(struct s_block) + BITARRAY_SIZE_IN_BYTES(sc->num_entries));
        fprintf(stderr, "  size: %i words\n",(int)sc->pi.size);
//        printf("  color: %i words\n",(int)sc->pi.color);
        fprintf(stderr, "  nptrs: %i words\n",(int)sc->pi.num_ptrs);
//        printf("  end: %i bytes\n",(int)(sc->pi.color+ sc->num_entries*sc->pi.size)*sizeof(uintptr_t));
        fprintf(stderr, "%20s %9s %9s %s\n", "block", "num_free", "next_free", "status");
        struct s_block *pg;
        SLIST_FOREACH(pg,&sc->blocks,link) {
            fprintf(stderr, "%20p %9i %9i %c\n", pg, pg->num_free, pg->next_free, 'P');
        }
        fprintf(stderr, "  full_blocks:\n");
        SLIST_FOREACH(pg,&sc->full_blocks,link) {
            fprintf(stderr, "%20p %9i %9i %c\n", pg, pg->num_free, pg->next_free, 'F');
        }
}

#ifdef SLAB_TEST

#define NUM_CACHES 15
#define FACTOR (1 << 16)

void
stress_test(int n) {
        struct s_arena *arena = new_arena();
        struct s_cache *caches[NUM_CACHES];

        void *ptrs[n];
        memset(ptrs,0,n*sizeof(void *));
        for(int i = 0; i < NUM_CACHES; i++)
                caches[i] = new_cache(arena,sizeof(void *)*(i + 1), 0);
        for(int i = 0; i < FACTOR * n; i++) {
                int wp = rand() % n;
                if (ptrs[wp]) {
                        s_free(ptrs[wp]);
                        //free(ptrs[wp]);
                        ptrs[wp] = NULL;
                } else {
                        ptrs[wp] = s_alloc(caches[rand() % NUM_CACHES]);
                        //ptrs[wp] = malloc((rand() % NUM_CACHES) * sizeof(uintptr_t));
                }
        }
}


int
main(int argc, char *argv[])
{

        setbuf(stdout,NULL);
        stress_test(1 << 8);
        struct s_arena *arena = new_arena();
        for(int i = 0;i < 10; i++) {
        struct s_cache *sc = new_cache(arena,i,0);
        print_cache(sc);
        }
        struct s_cache *sc1 = new_cache(arena,7,4);
        struct s_cache *sc2 = new_cache(arena,1,3);

        printf("Alloc1: %p\n", s_alloc(sc1));
        printf("Alloc1: %p\n", s_alloc(sc1));
        printf("Alloc1: %p\n", s_alloc(sc1));
        printf("Alloc2: %p\n", s_alloc(sc2));
        printf("Alloc2: %p\n", s_alloc(sc2));
        printf("Alloc2: %p\n", s_alloc(sc2));

        print_cache(sc1);
        print_cache(sc2);


        return 0;
}

#endif
#endif
/* src/rts/jhc_jgc.c */
#if _JHC_GC == _JHC_GC_JGC
static struct s_arena *arena;

#ifdef JHC_JGC_STACK
struct frame {
        struct frame *prev;
        unsigned nptrs;
        void *ptrs[0];
};
#define gc_frame0(gc,n,...) struct { struct frame *prev; unsigned nptrs;void *ptrs[n]; } l \
          = { gc, n, { __VA_ARGS__ } }; gc_t gc = (gc_t)(void *)&l;
#else
#define gc_frame0(gc,n,...) void *ptrs[n] = { __VA_ARGS__ }; for(int i = 0; i < n; i++) gc[i] = (sptr_t)ptrs[i]; gc_t sgc = gc;  gc_t gc = sgc + n;
#define gc_frame1(gc,p1) gc[0] = (sptr_t)p1; gc_t sgc = gc;  gc_t gc = sgc + 1;
#define gc_frame2(gc,p1,p2) gc[0] = (sptr_t)p1; gc[1] = (sptr_t)p2; gc_t sgc = gc;  gc_t gc = sgc + 2;
#endif

static unsigned number_gcs;             // number of garbage collections
static unsigned number_allocs;          // number of allocations since last garbage collection

#define TO_GCPTR(x) (entry_t *)(FROM_SPTR(x))

typedef struct {
        sptr_t ptrs[0];
} entry_t;

static const void *nh_start, *nh_end;

static bool
gc_check_heap(entry_t *s)
{
        return (s < (entry_t *)nh_start || s > (entry_t *)nh_end);
}

struct stack {
        unsigned size;
        unsigned ptr;
        entry_t * *stack;
};

#define EMPTY_STACK { 0, 0, NULL }

static void
stack_grow(struct stack *s, unsigned grow)
{
        s->size += grow;
        s->stack = realloc(s->stack, sizeof(s->stack[0])*s->size);
        assert(s->stack);
        debugf("stack:");
        for(unsigned i = 0; i < s->ptr; i++) {
                debugf(" %p", (void *)s->stack[i]);
        }
        debugf("\n");
}

inline static void
stack_check(struct stack *s, unsigned n) {
        if(__predict_false(s->size - s->ptr < n)) {
                stack_grow(s,n + 1024);
        }
}

static struct stack root_stack = EMPTY_STACK;

A_UNUSED static void
gc_add_root(gc_t gc, sptr_t root)
{
        if(IS_PTR(root)) {
                entry_t *nroot = TO_GCPTR(root);
                if(gc_check_heap(nroot)) {
                        stack_check(&root_stack,1);
                        root_stack.stack[root_stack.ptr++] = nroot;
                }
        }
}

static void
gc_add_grey(struct stack *stack, entry_t *s)
{
        VALGRIND_MAKE_MEM_DEFINED(s,S_BLOCK(s)->pi.size * sizeof(uintptr_t));
        if(gc_check_heap(s) && s_set_used_bit(s))
                stack->stack[stack->ptr++] = s;
}

static void
gc_perform_gc(gc_t gc)
{
        profile_push(&gc_gc_time);
        number_gcs++;

        unsigned number_redirects = 0;
        unsigned number_stack = 0;
        unsigned number_ptr = 0;
        struct stack stack = EMPTY_STACK;

        clear_used_bits(arena);

        debugf("Setting Roots:");
        stack_check(&stack, root_stack.ptr);
        for(unsigned i = 0; i < root_stack.ptr; i++) {
                gc_add_grey(&stack, root_stack.stack[i]);
                debugf(" %p", root_stack.stack[i]);
        }
        debugf("\n");
        debugf("Trace:");
#ifdef JHC_JGC_STACK
        for(;gc;gc = gc->prev) {
                debugf(" |");
                stack_check(&stack, gc->nptrs);
                for(unsigned i = 0;i < gc->nptrs; i++) {
                        number_stack++;
                        // TODO - short circuit redirects on stack
                        sptr_t ptr = gc->ptrs[i];
                        if(P_LAZY == GET_PTYPE(ptr)) {
                                if(!IS_LAZY(GETHEAD(FROM_SPTR(ptr)))) {
                                        J1U(r,gc_allocated,((uintptr_t)FROM_SPTR(ptr) - sizeof(entry_t))/GC_ALIGNMENT);
                                        if(r)
                                                J1S(r,gc_grey,((uintptr_t)FROM_SPTR(ptr) - sizeof(entry_t))/GC_ALIGNMENT);
                                        number_redirects++;
                                        debugf(" *");
                                        ptr = (sptr_t)GETHEAD(FROM_SPTR(ptr));
                                }
                        }
                        if(__predict_false(!IS_PTR(ptr))) {
                                debugf(" -");
                                continue;
                        }
                        number_ptr++;
                        entry_t *e = (entry_t *)FROM_SPTR(ptr) - 1;
                        debugf(" %p",(void *)e);
                        gc_add_grey(&gc_grey, &stack, (uintptr_t)e / GC_ALIGNMENT);
                }
        }
#else
        stack_check(&stack, gc - gc_stack_base);
        number_stack = gc - gc_stack_base;
        for(unsigned i = 0; i < number_stack; i++) {
                debugf(" |");
                // TODO - short circuit redirects on stack
                sptr_t ptr = gc_stack_base[i];
                if(1 && (IS_LAZY(ptr))) {
                        assert(GET_PTYPE(ptr) == P_LAZY);
                        VALGRIND_MAKE_MEM_DEFINED(FROM_SPTR(ptr), sizeof(uintptr_t));
                        if(!IS_LAZY(GETHEAD(FROM_SPTR(ptr)))) {
                                void *gptr = TO_GCPTR(ptr);
                                if(gc_check_heap(gptr))
                                        s_set_used_bit(gptr);
                                number_redirects++;
                                debugf(" *");
                                ptr = (sptr_t)GETHEAD(FROM_SPTR(ptr));
                        }
                }
                if(__predict_false(!IS_PTR(ptr))) {
                        debugf(" -");
                        continue;
                }
                number_ptr++;
                entry_t *e = TO_GCPTR(ptr);
                debugf(" %p",(void *)e);
                gc_add_grey(&stack, e);
        }
#endif
        debugf("\n");

        while(stack.ptr) {
                entry_t *e = stack.stack[--stack.ptr];
                struct s_block *pg = S_BLOCK(e);
                VALGRIND_MAKE_MEM_DEFINED(e,pg->pi.size * sizeof(uintptr_t));
                debugf("Processing Grey: %p\n",e);

                stack_check(&stack, pg->pi.num_ptrs);
                for(int i = 0; i < pg->pi.num_ptrs; i++) {
                        if(1 && (P_LAZY == GET_PTYPE(e->ptrs[i]))) {
                                VALGRIND_MAKE_MEM_DEFINED(FROM_SPTR(e->ptrs[i]), sizeof(uintptr_t));
                                if(!IS_LAZY(GETHEAD(FROM_SPTR(e->ptrs[i])))) {
                                        number_redirects++;
                                        debugf(" *");
                                        e->ptrs[i] = (sptr_t)GETHEAD(FROM_SPTR(e->ptrs[i]));
                                }
                        }
                        if(IS_PTR(e->ptrs[i])) {
                                entry_t * ptr = TO_GCPTR(e->ptrs[i]);
                                debugf("Following: %p %p\n",e->ptrs[i], ptr);
                                gc_add_grey( &stack, ptr);
                        }
                }
        }
        free(stack.stack);
        s_cleanup_blocks(arena);
        if(JHC_STATUS) {
#ifdef JHC_JGC_STACK
                void * gc_stack_base = &gc_stack_base;
                Word_t n_roots;
                J1C(n_roots,gc_roots,0,-1);
#endif

                fprintf(stderr, "%3u - %6u Used: %4u Thresh: %4u Ss: %5u Ps: %5u Rs: %5u Root: %3u\n",
                        number_gcs,
                        number_allocs,
                        (unsigned)arena->block_used,
                        block_threshold,
                        number_stack,
                        number_ptr,
                        number_redirects,
                        (unsigned)root_stack.ptr
                       );
                number_allocs = 0;
        }
        profile_pop(&gc_gc_time);
}

A_UNUSED static void *
(gc_alloc)(gc_t gc,struct s_cache **sc, unsigned count, unsigned nptrs)
{
        profile_push(&gc_alloc_time);
        if (JHC_STATUS)
                number_allocs++;
        assert(nptrs <= count);
        entry_t *e = s_alloc(gc, find_cache(sc, arena, count, nptrs));
        VALGRIND_MAKE_MEM_UNDEFINED(e,sizeof(uintptr_t)*count);
        debugf("allocated: %p %i %i\n",(void *)e, count, nptrs);
        profile_pop(&gc_alloc_time);
        return (void *)e;
}

static void jhc_alloc_print_stats(void) { }
static const void * const nh_stuff[];

static void
jhc_alloc_init(void) {
        VALGRIND_PRINTF("Jhc-Valgrind mode active.\n");
#ifndef JHC_JGC_STACK
        saved_gc = gc_stack_base = malloc((1UL << 18)*sizeof(gc_stack_base[0]));
#endif
        arena = new_arena();
        if(nh_stuff[0]) {
                nh_end = nh_start = nh_stuff[0];
                for(int i = 1; nh_stuff[i]; i++) {
                        if(nh_stuff[i] < nh_start)
                                nh_start = nh_stuff[i];
                        if(nh_stuff[i] > nh_end)
                                nh_end = nh_stuff[i];
                }
        }
}

static void
jhc_alloc_fini(void) {
        if(JHC_STATUS) {
                fprintf(stderr, "arena: %p\n", arena);
                fprintf(stderr, "  block_used: %i\n", arena->block_used);
                fprintf(stderr, "  block_threshold: %i\n", arena->block_threshold);
                struct s_cache *sc = SLIST_FIRST(&arena->caches);
                for(;sc;sc = SLIST_NEXT(sc,next)) {
                        print_cache(sc);
                }
        }
}
#endif
/* src/rts/lib_cbits.c */
/* this file contains C only needed to help support the 
 * standard libraries */

static HsInt jhc_stdrnd[2] A_UNUSED = { 1 , 1 };
static HsInt jhc_data_unique A_UNUSED;

static HsBool A_UNUSED
jhc_wait_for_input(FILE *f,HsInt timeout) {
#if JHC_isPosix
        fd_set fds;
        FD_ZERO(&fds);
        FD_SET(fileno(f),&fds);
        struct timeval to = {  0, timeout * 1000 };
        int retval = select(1,&fds,NULL,&fds,&to);
        if(retval)
                return HS_BOOL_TRUE;
        else
                return HS_BOOL_FALSE;
#else
        return HS_BOOL_FALSE;
#endif
}

#ifdef __WIN32__
#define getchar_unlocked() getchar()
#define putchar_unlocked(x) putchar(x)
#define getc_unlocked(x) getc(x)
#define putc_unlocked(x,y) putc(x,y)
#endif

inline static int A_UNUSED
jhc_utf8_getchar(void)
{
    return getchar_unlocked();
}

inline static int A_UNUSED
jhc_utf8_getc(FILE *f)
{
    return getc_unlocked(f);
}

inline static int A_UNUSED
jhc_utf8_putchar(int ch)
{
    return putchar_unlocked(ch);
}

inline static int A_UNUSED
jhc_utf8_putc(int ch, FILE *f)
{
    return putc_unlocked(ch,f);
}
#endif
#include <stdio.h>
#include <stdlib.h>
static struct s_cache *cCJhc_Prim_$x3a;
static struct s_cache *cCInt$h;
static struct s_cache *cCJhc_Addr_Ptr;
static struct s_cache *cCCInt$h;
static struct s_cache *cFFE$__CCall_engine$d5;
static struct s_cache *cFFE$__CCall_engine$d6;
static struct s_cache *cFR$__fJhc_Basics_zipWith;
static struct s_cache *cP1__FE$__CCall_engine$d4;
static struct s_cache *cFR$__fJhc_Basics_iterate;
static struct s_cache *cFFE$__CCall_engine$d3;
static struct s_cache *cFFE$__CCall_engine$d2;
static struct s_cache *cFJhc_Basics_89__go;
static struct s_cache *cFR$__fJhc_Basics_$pp;
static struct s_cache *cCPrelude_Right;

enum {
    CCInt$h = 0,
    CJhc_Basics_$LR = 0,
    CJhc_Prim_$BE = 1,
    CJhc_Prim_$x3a = 0,
    CJhc_Prim_Char = 0,
    CPrelude_Left = 0,
    CPrelude_Right = 1,
    P1__FE$__CCall_engine$d4 = 0
};
struct sCCInt$h A_ALIGNED;
struct sCInt$h A_ALIGNED;
struct sCJhc_Addr_Ptr A_ALIGNED;
struct sCJhc_Prim_$x3a A_ALIGNED;
struct sCPrelude_Left A_ALIGNED;
struct sCPrelude_Right A_ALIGNED;
struct sFFE$__CCall_engine$d2 A_ALIGNED;
struct sFFE$__CCall_engine$d3 A_ALIGNED;
struct sFFE$__CCall_engine$d5 A_ALIGNED;
struct sFFE$__CCall_engine$d6 A_ALIGNED;
struct sFJhc_Basics_89__go A_ALIGNED;
struct sFR$__fJhc_Basics_$pp A_ALIGNED;
struct sFR$__fJhc_Basics_iterate A_ALIGNED;
struct sFR$__fJhc_Basics_zipWith A_ALIGNED;
struct sP1__FE$__CCall_engine$d4 A_ALIGNED;

struct sCCInt$h {
    int a1;
};

struct sCInt$h {
    uint32_t a1;
};

struct sCJhc_Addr_Ptr {
    uintptr_t a1;
};

struct sCJhc_Prim_$x3a {
    sptr_t a1;
    sptr_t a2;
};

struct sCPrelude_Left {
    what_t what;
    sptr_t a1;
};

struct sCPrelude_Right {
    what_t what;
    sptr_t a1;
};

struct sFFE$__CCall_engine$d2 {
    fptr_t head;
    sptr_t a1;
};

struct sFFE$__CCall_engine$d3 {
    fptr_t head;
    sptr_t a1;
};

struct sFFE$__CCall_engine$d5 {
    fptr_t head;
    sptr_t a1;
};

struct sFFE$__CCall_engine$d6 {
    fptr_t head;
    sptr_t a1;
};

struct sFJhc_Basics_89__go {
    fptr_t head;
    sptr_t a1;
};

struct sFR$__fJhc_Basics_$pp {
    fptr_t head;
    sptr_t a1;
    wptr_t a2;
};

struct sFR$__fJhc_Basics_iterate {
    fptr_t head;
    sptr_t a1;
};

struct sFR$__fJhc_Basics_zipWith {
    fptr_t head;
    sptr_t a1;
    sptr_t a2;
};

struct sP1__FE$__CCall_engine$d4 {
    what_t what;
    sptr_t a1;
    sptr_t a2;
};
static void jhc_hs_init(void) ;
static wptr_t E__fFE$__CCall_engine$d2(gc_t gc,struct sFFE$__CCall_engine$d2* arg) A_STD A_FALIGNED;
static wptr_t E__fFE$__CCall_engine$d3(gc_t gc,struct sFFE$__CCall_engine$d3* arg) A_STD A_FALIGNED;
static wptr_t E__fFE$__CCall_engine$d5(gc_t gc,struct sFFE$__CCall_engine$d5* arg) A_STD A_FALIGNED;
static wptr_t E__fFE$__CCall_engine$d6(gc_t gc,struct sFFE$__CCall_engine$d6* arg) A_STD A_FALIGNED;
static wptr_t E__fJhc_Basics_89__go(gc_t gc,struct sFJhc_Basics_89__go* arg) A_STD A_FALIGNED;
static wptr_t E__fR$__fJhc_Basics_$pp(gc_t gc,struct sFR$__fJhc_Basics_$pp* arg) A_STD A_FALIGNED;
static wptr_t E__fR$__fJhc_Basics_iterate(gc_t gc,struct sFR$__fJhc_Basics_iterate* arg) A_STD A_FALIGNED;
static wptr_t E__fR$__fJhc_Basics_zipWith(gc_t gc,struct sFR$__fJhc_Basics_zipWith* arg) A_STD A_FALIGNED;
void _amain(void) ;
static void b__main(gc_t gc) A_STD;
static sptr_t bapply__7936(gc_t gc,wptr_t v1) A_STD A_MALLOC;
int engine(HsPtr x31,HsPtr x32,HsPtr x33,HsPtr x34) ;
static int fFE$__CCall_engine(gc_t gc,uintptr_t v264192726,uintptr_t v163333522,uintptr_t v73700196,uintptr_t v218886262) A_STD;
static wptr_t fFE$__CCall_engine$d2(gc_t gc,sptr_t v30) A_STD A_MALLOC;
static wptr_t fFE$__CCall_engine$d3(gc_t gc,sptr_t v44725398) A_STD A_MALLOC;
static sptr_t fFE$__CCall_engine$d4(gc_t gc,sptr_t v92,sptr_t v238) A_STD A_MALLOC;
static wptr_t fFE$__CCall_engine$d5(gc_t gc,sptr_t v105553378) A_STD A_MALLOC;
static wptr_t fFE$__CCall_engine$d6(gc_t gc,sptr_t v209623816) A_STD A_MALLOC;
static wptr_t fJhc_Basics_89__go(gc_t gc,sptr_t v182) A_STD A_MALLOC;
static wptr_t fR$__fJhc_Basics_$pp(gc_t gc,sptr_t v110947982,wptr_t v227981058) A_STD A_MALLOC;
static wptr_t fR$__fJhc_Basics_iterate(gc_t gc,sptr_t v182639122) A_STD A_MALLOC;
static wptr_t fR$__fJhc_Basics_zipWith(gc_t gc,sptr_t v68216824,sptr_t v194635132) A_STD A_MALLOC;
static wptr_t fW$__fForeign_Marshal_Alloc_mallocBytes(gc_t gc,uint32_t v1200623177) A_STD A_MALLOC;
static wptr_t fW$__fInstance$__iForeign_Storable_peekElemOff_default(gc_t gc,uintptr_t v1333792319,uint32_t v1337855549) A_STD A_MALLOC;
static uint32_t fW$__fJhc_List_length(gc_t gc,sptr_t v871243297) A_STD;
static void ftheMain(gc_t gc) A_STD;
/* CAFS */
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 121),Left &("CJhc.Prim.[]")],7) */
static const struct sCJhc_Prim_$x3a _c7 = {.a1 = (sptr_t)RAW_SET_UF('y'), .a2 = (sptr_t)SET_RAW_TAG(CJhc_Prim_$BE)};
#define c7 (TO_SPTR_C(P_WHNF, (sptr_t)&_c7))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 114),Right 7],8) */
static const struct sCJhc_Prim_$x3a _c8 = {.a1 = (sptr_t)RAW_SET_UF('r'), .a2 = c7};
#define c8 (TO_SPTR_C(P_WHNF, (sptr_t)&_c8))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 111),Right 8],9) */
static const struct sCJhc_Prim_$x3a _c9 = {.a1 = (sptr_t)RAW_SET_UF('o'), .a2 = c8};
#define c9 (TO_SPTR_C(P_WHNF, (sptr_t)&_c9))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 109),Right 9],10) */
static const struct sCJhc_Prim_$x3a _c10 = {.a1 = (sptr_t)RAW_SET_UF('m'), .a2 = c9};
#define c10 (TO_SPTR_C(P_WHNF, (sptr_t)&_c10))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 101),Right 10],11) */
static const struct sCJhc_Prim_$x3a _c11 = {.a1 = (sptr_t)RAW_SET_UF('e'), .a2 = c10};
#define c11 (TO_SPTR_C(P_WHNF, (sptr_t)&_c11))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 109),Right 11],12) */
static const struct sCJhc_Prim_$x3a _c12 = {.a1 = (sptr_t)RAW_SET_UF('m'), .a2 = c11};
#define c12 (TO_SPTR_C(P_WHNF, (sptr_t)&_c12))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 32),Right 12],13) */
static const struct sCJhc_Prim_$x3a _c13 = {.a1 = (sptr_t)RAW_SET_UF(' '), .a2 = c12};
#define c13 (TO_SPTR_C(P_WHNF, (sptr_t)&_c13))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 102),Right 13],14) */
static const struct sCJhc_Prim_$x3a _c14 = {.a1 = (sptr_t)RAW_SET_UF('f'), .a2 = c13};
#define c14 (TO_SPTR_C(P_WHNF, (sptr_t)&_c14))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 111),Right 14],15) */
static const struct sCJhc_Prim_$x3a _c15 = {.a1 = (sptr_t)RAW_SET_UF('o'), .a2 = c14};
#define c15 (TO_SPTR_C(P_WHNF, (sptr_t)&_c15))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 32),Right 15],16) */
static const struct sCJhc_Prim_$x3a _c16 = {.a1 = (sptr_t)RAW_SET_UF(' '), .a2 = c15};
#define c16 (TO_SPTR_C(P_WHNF, (sptr_t)&_c16))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 116),Right 16],17) */
static const struct sCJhc_Prim_$x3a _c17 = {.a1 = (sptr_t)RAW_SET_UF('t'), .a2 = c16};
#define c17 (TO_SPTR_C(P_WHNF, (sptr_t)&_c17))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 117),Right 17],18) */
static const struct sCJhc_Prim_$x3a _c18 = {.a1 = (sptr_t)RAW_SET_UF('u'), .a2 = c17};
#define c18 (TO_SPTR_C(P_WHNF, (sptr_t)&_c18))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 111),Right 18],19) */
static const struct sCJhc_Prim_$x3a _c19 = {.a1 = (sptr_t)RAW_SET_UF('o'), .a2 = c18};
#define c19 (TO_SPTR_C(P_WHNF, (sptr_t)&_c19))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 32),Right 19],20) */
static const struct sCJhc_Prim_$x3a _c20 = {.a1 = (sptr_t)RAW_SET_UF(' '), .a2 = c19};
#define c20 (TO_SPTR_C(P_WHNF, (sptr_t)&_c20))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 104),Left &("CJhc.Prim.[]")],22) */
static const struct sCJhc_Prim_$x3a _c22 = {.a1 = (sptr_t)RAW_SET_UF('h'), .a2 = (sptr_t)SET_RAW_TAG(CJhc_Prim_$BE)};
#define c22 (TO_SPTR_C(P_WHNF, (sptr_t)&_c22))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 103),Right 22],23) */
static const struct sCJhc_Prim_$x3a _c23 = {.a1 = (sptr_t)RAW_SET_UF('g'), .a2 = c22};
#define c23 (TO_SPTR_C(P_WHNF, (sptr_t)&_c23))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 117),Right 23],24) */
static const struct sCJhc_Prim_$x3a _c24 = {.a1 = (sptr_t)RAW_SET_UF('u'), .a2 = c23};
#define c24 (TO_SPTR_C(P_WHNF, (sptr_t)&_c24))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 111),Right 24],25) */
static const struct sCJhc_Prim_$x3a _c25 = {.a1 = (sptr_t)RAW_SET_UF('o'), .a2 = c24};
#define c25 (TO_SPTR_C(P_WHNF, (sptr_t)&_c25))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 110),Right 25],26) */
static const struct sCJhc_Prim_$x3a _c26 = {.a1 = (sptr_t)RAW_SET_UF('n'), .a2 = c25};
#define c26 (TO_SPTR_C(P_WHNF, (sptr_t)&_c26))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 101),Right 26],27) */
static const struct sCJhc_Prim_$x3a _c27 = {.a1 = (sptr_t)RAW_SET_UF('e'), .a2 = c26};
#define c27 (TO_SPTR_C(P_WHNF, (sptr_t)&_c27))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 32),Right 27],28) */
static const struct sCJhc_Prim_$x3a _c28 = {.a1 = (sptr_t)RAW_SET_UF(' '), .a2 = c27};
#define c28 (TO_SPTR_C(P_WHNF, (sptr_t)&_c28))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 103),Right 28],29) */
static const struct sCJhc_Prim_$x3a _c29 = {.a1 = (sptr_t)RAW_SET_UF('g'), .a2 = c28};
#define c29 (TO_SPTR_C(P_WHNF, (sptr_t)&_c29))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 110),Right 29],30) */
static const struct sCJhc_Prim_$x3a _c30 = {.a1 = (sptr_t)RAW_SET_UF('n'), .a2 = c29};
#define c30 (TO_SPTR_C(P_WHNF, (sptr_t)&_c30))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 111),Right 30],31) */
static const struct sCJhc_Prim_$x3a _c31 = {.a1 = (sptr_t)RAW_SET_UF('o'), .a2 = c30};
#define c31 (TO_SPTR_C(P_WHNF, (sptr_t)&_c31))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 108),Right 31],32) */
static const struct sCJhc_Prim_$x3a _c32 = {.a1 = (sptr_t)RAW_SET_UF('l'), .a2 = c31};
#define c32 (TO_SPTR_C(P_WHNF, (sptr_t)&_c32))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 32),Right 32],33) */
static const struct sCJhc_Prim_$x3a _c33 = {.a1 = (sptr_t)RAW_SET_UF(' '), .a2 = c32};
#define c33 (TO_SPTR_C(P_WHNF, (sptr_t)&_c33))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 116),Right 33],34) */
static const struct sCJhc_Prim_$x3a _c34 = {.a1 = (sptr_t)RAW_SET_UF('t'), .a2 = c33};
#define c34 (TO_SPTR_C(P_WHNF, (sptr_t)&_c34))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 111),Right 34],35) */
static const struct sCJhc_Prim_$x3a _c35 = {.a1 = (sptr_t)RAW_SET_UF('o'), .a2 = c34};
#define c35 (TO_SPTR_C(P_WHNF, (sptr_t)&_c35))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 110),Right 35],36) */
static const struct sCJhc_Prim_$x3a _c36 = {.a1 = (sptr_t)RAW_SET_UF('n'), .a2 = c35};
#define c36 (TO_SPTR_C(P_WHNF, (sptr_t)&_c36))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 32),Right 36],37) */
static const struct sCJhc_Prim_$x3a _c37 = {.a1 = (sptr_t)RAW_SET_UF(' '), .a2 = c36};
#define c37 (TO_SPTR_C(P_WHNF, (sptr_t)&_c37))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 58),Right 20],21) */
static const struct sCJhc_Prim_$x3a _c21 = {.a1 = (sptr_t)RAW_SET_UF(':'), .a2 = c20};
#define c21 (TO_SPTR_C(P_WHNF, (sptr_t)&_c21))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 103),Right 37],38) */
static const struct sCJhc_Prim_$x3a _c38 = {.a1 = (sptr_t)RAW_SET_UF('g'), .a2 = c37};
#define c38 (TO_SPTR_C(P_WHNF, (sptr_t)&_c38))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 110),Right 38],39) */
static const struct sCJhc_Prim_$x3a _c39 = {.a1 = (sptr_t)RAW_SET_UF('n'), .a2 = c38};
#define c39 (TO_SPTR_C(P_WHNF, (sptr_t)&_c39))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 105),Right 39],40) */
static const struct sCJhc_Prim_$x3a _c40 = {.a1 = (sptr_t)RAW_SET_UF('i'), .a2 = c39};
#define c40 (TO_SPTR_C(P_WHNF, (sptr_t)&_c40))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 114),Right 40],41) */
static const struct sCJhc_Prim_$x3a _c41 = {.a1 = (sptr_t)RAW_SET_UF('r'), .a2 = c40};
#define c41 (TO_SPTR_C(P_WHNF, (sptr_t)&_c41))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 116),Right 41],42) */
static const struct sCJhc_Prim_$x3a _c42 = {.a1 = (sptr_t)RAW_SET_UF('t'), .a2 = c41};
#define c42 (TO_SPTR_C(P_WHNF, (sptr_t)&_c42))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 83),Right 42],43) */
static const struct sCJhc_Prim_$x3a _c43 = {.a1 = (sptr_t)RAW_SET_UF('S'), .a2 = c42};
#define c43 (TO_SPTR_C(P_WHNF, (sptr_t)&_c43))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 99),Left &("CJhc.Prim.[]")],1) */
static const struct sCJhc_Prim_$x3a _c1 = {.a1 = (sptr_t)RAW_SET_UF('c'), .a2 = (sptr_t)SET_RAW_TAG(CJhc_Prim_$BE)};
#define c1 (TO_SPTR_C(P_WHNF, (sptr_t)&_c1))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 111),Right 1],2) */
static const struct sCJhc_Prim_$x3a _c2 = {.a1 = (sptr_t)RAW_SET_UF('o'), .a2 = c1};
#define c2 (TO_SPTR_C(P_WHNF, (sptr_t)&_c2))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 108),Right 2],3) */
static const struct sCJhc_Prim_$x3a _c3 = {.a1 = (sptr_t)RAW_SET_UF('l'), .a2 = c2};
#define c3 (TO_SPTR_C(P_WHNF, (sptr_t)&_c3))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 108),Right 3],4) */
static const struct sCJhc_Prim_$x3a _c4 = {.a1 = (sptr_t)RAW_SET_UF('l'), .a2 = c3};
#define c4 (TO_SPTR_C(P_WHNF, (sptr_t)&_c4))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 97),Right 4],5) */
static const struct sCJhc_Prim_$x3a _c5 = {.a1 = (sptr_t)RAW_SET_UF('a'), .a2 = c4};
#define c5 (TO_SPTR_C(P_WHNF, (sptr_t)&_c5))
/* (HcNode CJhc.Prim.: [Left &("CJhc.Prim.Char" 109),Right 5],6) */
static const struct sCJhc_Prim_$x3a _c6 = {.a1 = (sptr_t)RAW_SET_UF('m'), .a2 = c5};
#define c6 (TO_SPTR_C(P_WHNF, (sptr_t)&_c6))
/* (HcNode CCInt# [Left 0],46) */
static const struct sCCInt$h _c46 = {.a1 = 0};
#define c46 (TO_SPTR_C(P_WHNF, (sptr_t)&_c46))
/* (HcNode CCInt# [Left 1],45) */
static const struct sCCInt$h _c45 = {.a1 = 1};
#define c45 (TO_SPTR_C(P_WHNF, (sptr_t)&_c45))
/* (HcNode CPrelude.Left [Right 43],44) */
static const struct sCPrelude_Left _c44 = {.what = SET_RAW_TAG(CPrelude_Left), .a1 = c43};
#define c44 (TO_SPTR_C(P_WHNF, (sptr_t)&_c44))

static const void * const nh_stuff[] = {
&_c1, &_c2, &_c3, &_c4, &_c5, &_c6, &_c7, &_c8, &_c9, &_c10, &_c11,
&_c12, &_c13, &_c14, &_c15, &_c16, &_c17, &_c18, &_c19, &_c20,
&_c21, &_c22, &_c23, &_c24, &_c25, &_c26, &_c27, &_c28, &_c29,
&_c30, &_c31, &_c32, &_c33, &_c34, &_c35, &_c36, &_c37, &_c38,
&_c39, &_c40, &_c41, &_c42, &_c43, &_c44, &_c45, &_c46, NULL
};


static void 
jhc_hs_init(void)
{
        find_cache(&cCJhc_Prim_$x3a,arena,TO_BLOCKS(sizeof(struct sCJhc_Prim_$x3a)),2);
        find_cache(&cCInt$h,arena,TO_BLOCKS(sizeof(struct sCInt$h)),0);
        find_cache(&cCJhc_Addr_Ptr,arena,TO_BLOCKS(sizeof(struct sCJhc_Addr_Ptr)),0);
        find_cache(&cCCInt$h,arena,TO_BLOCKS(sizeof(struct sCCInt$h)),0);
        find_cache(&cFFE$__CCall_engine$d5,arena,TO_BLOCKS(sizeof(struct sFFE$__CCall_engine$d5)),2);
        find_cache(&cFFE$__CCall_engine$d6,arena,TO_BLOCKS(sizeof(struct sFFE$__CCall_engine$d6)),2);
        find_cache(&cFR$__fJhc_Basics_zipWith,arena,TO_BLOCKS(sizeof(struct sFR$__fJhc_Basics_zipWith)),3);
        find_cache(&cP1__FE$__CCall_engine$d4,arena,TO_BLOCKS(sizeof(struct sP1__FE$__CCall_engine$d4)),3);
        find_cache(&cFR$__fJhc_Basics_iterate,arena,TO_BLOCKS(sizeof(struct sFR$__fJhc_Basics_iterate)),2);
        find_cache(&cFFE$__CCall_engine$d3,arena,TO_BLOCKS(sizeof(struct sFFE$__CCall_engine$d3)),2);
        find_cache(&cFFE$__CCall_engine$d2,arena,TO_BLOCKS(sizeof(struct sFFE$__CCall_engine$d2)),2);
        find_cache(&cFJhc_Basics_89__go,arena,TO_BLOCKS(sizeof(struct sFJhc_Basics_89__go)),2);
        find_cache(&cFR$__fJhc_Basics_$pp,arena,TO_BLOCKS(sizeof(struct sFR$__fJhc_Basics_$pp)),3);
        find_cache(&cCPrelude_Right,arena,TO_BLOCKS(sizeof(struct sCPrelude_Right)),2);
}

static wptr_t A_STD A_FALIGNED
E__fFE$__CCall_engine$d2(gc_t gc,struct sFFE$__CCall_engine$d2* arg)
{
        {
            wptr_t r;
            gc_frame0(gc,1,MKLAZY(arg));
            r = fFE$__CCall_engine$d2(gc,arg->a1);
            update(arg,r);
            return r;
        }
}

static wptr_t A_STD A_FALIGNED
E__fFE$__CCall_engine$d3(gc_t gc,struct sFFE$__CCall_engine$d3* arg)
{
        {
            wptr_t r;
            gc_frame0(gc,1,MKLAZY(arg));
            r = fFE$__CCall_engine$d3(gc,arg->a1);
            update(arg,r);
            return r;
        }
}

static wptr_t A_STD A_FALIGNED
E__fFE$__CCall_engine$d5(gc_t gc,struct sFFE$__CCall_engine$d5* arg)
{
        {
            wptr_t r;
            gc_frame0(gc,1,MKLAZY(arg));
            r = fFE$__CCall_engine$d5(gc,arg->a1);
            update(arg,r);
            return r;
        }
}

static wptr_t A_STD A_FALIGNED
E__fFE$__CCall_engine$d6(gc_t gc,struct sFFE$__CCall_engine$d6* arg)
{
        {
            wptr_t r;
            gc_frame0(gc,1,MKLAZY(arg));
            r = fFE$__CCall_engine$d6(gc,arg->a1);
            update(arg,r);
            return r;
        }
}

static wptr_t A_STD A_FALIGNED
E__fJhc_Basics_89__go(gc_t gc,struct sFJhc_Basics_89__go* arg)
{
        {
            wptr_t r;
            gc_frame0(gc,1,MKLAZY(arg));
            r = fJhc_Basics_89__go(gc,arg->a1);
            update(arg,r);
            return r;
        }
}

static wptr_t A_STD A_FALIGNED
E__fR$__fJhc_Basics_$pp(gc_t gc,struct sFR$__fJhc_Basics_$pp* arg)
{
        {
            wptr_t r;
            gc_frame0(gc,1,MKLAZY(arg));
            r = fR$__fJhc_Basics_$pp(gc,arg->a1,arg->a2);
            update(arg,r);
            return r;
        }
}

static wptr_t A_STD A_FALIGNED
E__fR$__fJhc_Basics_iterate(gc_t gc,struct sFR$__fJhc_Basics_iterate* arg)
{
        {
            wptr_t r;
            gc_frame0(gc,1,MKLAZY(arg));
            r = fR$__fJhc_Basics_iterate(gc,arg->a1);
            update(arg,r);
            return r;
        }
}

static wptr_t A_STD A_FALIGNED
E__fR$__fJhc_Basics_zipWith(gc_t gc,struct sFR$__fJhc_Basics_zipWith* arg)
{
        {
            wptr_t r;
            gc_frame0(gc,1,MKLAZY(arg));
            r = fR$__fJhc_Basics_zipWith(gc,arg->a1,arg->a2);
            update(arg,r);
            return r;
        }
}

void 
_amain(void)
{
        return (void)b__main(saved_gc);
}

static void A_STD
b__main(gc_t gc)
{
        return ftheMain(gc);
}

static sptr_t A_STD A_MALLOC
bapply__7936(gc_t gc,wptr_t v1)
{
        sptr_t v3;
        sptr_t v4;
        v3 = ((struct sP1__FE$__CCall_engine$d4*)v1)->a1;
        v4 = ((struct sP1__FE$__CCall_engine$d4*)v1)->a2;
        return fFE$__CCall_engine$d4(gc,v3,v4);
}

int 
engine(HsPtr x31,HsPtr x32,HsPtr x33,HsPtr x34)
{
        return (int)fFE$__CCall_engine(saved_gc,(uintptr_t)x31,(uintptr_t)x32,(uintptr_t)x33,(uintptr_t)x34);
}

static int A_STD
fFE$__CCall_engine(gc_t gc,uintptr_t v264192726,uintptr_t v163333522,uintptr_t v73700196,uintptr_t v218886262)
{
        wptr_t v104;
        wptr_t v38;
        uint32_t v151514820;
        uint32_t v247305776;
        v247305776 = 0;
        fW$__fForeign_Marshal_Array_139__loop__22:;
        {
            wptr_t x23 = s_alloc(gc,cCInt$h);
            ((struct sCInt$h*)x23)->a1 = v247305776;
            wptr_t v185 = x23;
            sptr_t v90861648 = demote(v185);
            {
                wptr_t v12;
                sptr_t v121;
                uint8_t v228308038;
                gc_frame0(gc,1,v90861648);
                v12 = fW$__fInstance$__iForeign_Storable_peekElemOff_default(gc,v264192726,v247305776);
                v228308038 = ((uint8_t)RAW_GET_UF(v12));
                if (0 == v228308038) {
                    v121 = v90861648;
                } else {
                    wptr_t v18;
                    uint32_t v111142934 = (1 + v247305776);
                    v247305776 = v111142934;
                    goto fW$__fForeign_Marshal_Array_139__loop__22;
                }
                v104 = promote(v121);
            }
        }
        v151514820 = ((struct sCInt$h*)v104)->a1;
        uint16_t v100022 = (((int32_t)0) >= ((int32_t)v151514820));
        if (0 == v100022) {
            wptr_t v59069478;
            uint32_t v205779218;
            uint32_t v35878050 = (v151514820 - 1);
            v59069478 = SET_RAW_TAG(CJhc_Prim_$BE);
            v205779218 = v35878050;
            fW$__fForeign_C_String_7__loop__24:;
            {
                sptr_t v59069508 = demote(v59069478);
                {
                    wptr_t v67;
                    uint8_t v52590394;
                    gc_frame0(gc,1,v59069508);
                    v67 = fW$__fInstance$__iForeign_Storable_peekElemOff_default(gc,v264192726,v205779218);
                    v52590394 = ((uint8_t)RAW_GET_UF(v67));
                    uint32_t v119514820 = ((uint32_t)v52590394);
                    wptr_t v227 = RAW_SET_UF(v119514820);
                    sptr_t v240673846 = demote(v227);
                    uint16_t v100026 = (((int32_t)0) >= ((int32_t)v205779218));
                    if (0 == v100026) {
                        uint32_t v182639120 = (v205779218 - 1);
                        {
                            gc_frame0(gc,1,v240673846);
                            wptr_t x25 = s_alloc(gc,cCJhc_Prim_$x3a);
                            ((struct sCJhc_Prim_$x3a*)x25)->a1 = v240673846;
                            ((struct sCJhc_Prim_$x3a*)x25)->a2 = v59069508;
                            wptr_t v236 = x25;
                            v59069478 = v236;
                            v205779218 = v182639120;
                            goto fW$__fForeign_C_String_7__loop__24;
                        }
                    } else {
                        /* 1 */
                        assert(1 == v100026);
                        {
                            gc_frame0(gc,1,v240673846);
                            wptr_t x26 = s_alloc(gc,cCJhc_Prim_$x3a);
                            ((struct sCJhc_Prim_$x3a*)x26)->a1 = v240673846;
                            ((struct sCJhc_Prim_$x3a*)x26)->a2 = v59069508;
                            v38 = x26;
                        }
                    }
                }
            }
        } else {
            /* 1 */
            assert(1 == v100022);
            v38 = SET_RAW_TAG(CJhc_Prim_$BE);
        }
        sptr_t v123670240 = demote(v38);
        {
            wptr_t v111;
            sptr_t v174020696;
            uint32_t v220594014;
            int v245228926;
            gc_frame0(gc,1,v123670240);
            v220594014 = fW$__fJhc_List_length(gc,v123670240);
            uint16_t v100028 = (((int32_t)10) > ((int32_t)v220594014));
            if (0 == v100028) {
                sptr_t x27 = s_alloc(gc,cFFE$__CCall_engine$d6);
                ((struct sFFE$__CCall_engine$d6*)x27)->head = TO_FPTR(&E__fFE$__CCall_engine$d6);
                ((struct sFFE$__CCall_engine$d6*)x27)->a1 = v123670240;
                sptr_t v110163150 = MKLAZY(x27);
                {
                    gc_frame0(gc,1,v110163150);
                    wptr_t x28 = s_alloc(gc,cCPrelude_Right);
                    SET_MEM_TAG((struct sCPrelude_Right*)x28,CPrelude_Right);
                    ((struct sCPrelude_Right*)x28)->a1 = v110163150;
                    v111 = x28;
                }
            } else {
                /* 1 */
                assert(1 == v100028);
                v111 = PROMOTE(c44);
            }
            if (CPrelude_Left == FETCH_TAG(v111)) {
                sptr_t v6;
                v6 = ((struct sCPrelude_Left*)v111)->a1;
                {
                    wptr_t v60;
                    uint32_t v913262;
                    gc_frame0(gc,1,v6);
                    v913262 = fW$__fJhc_List_length(gc,v6);
                    uint32_t v62470114 = (1 + v913262);
                    uint32_t v15818818 = (v62470114 * sizeof(uint8_t));
                    v60 = fW$__fForeign_Marshal_Alloc_mallocBytes(gc,v15818818);
                    {
                        sptr_t v227981062;
                        uint32_t v105553376;
                        uintptr_t v178407644;
                        gc_frame0(gc,1,v60);
                        v227981062 = v6;
                        v105553376 = 0;
                        fW$__fForeign_C_String_22__go__29:;
                        {
                            wptr_t v100036 = eval(gc,v227981062);
                            if (SET_RAW_TAG(CJhc_Prim_$BE) == v100036) {
                                uintptr_t v120254442;
                                v120254442 = ((struct sCJhc_Addr_Ptr*)v60)->a1;
                                uint32_t v115160442 = (v105553376 * sizeof(uint8_t));
                                uintptr_t v124940226 = ((intptr_t)((int32_t)v115160442));
                                uintptr_t v216085086 = (v120254442 + v124940226);
                                *((uint8_t *)(v216085086)) = 0;
                                SET_RAW_TAG(CJhc_Basics_$LR);
                            } else {
                                sptr_t v66;
                                sptr_t v68;
                                uintptr_t v164498532;
                                /* ("CJhc.Prim.:" ni66 ni68) */
                                v66 = ((struct sCJhc_Prim_$x3a*)v100036)->a1;
                                v68 = ((struct sCJhc_Prim_$x3a*)v100036)->a2;
                                v164498532 = ((struct sCJhc_Addr_Ptr*)v60)->a1;
                                {
                                    uint32_t v73786434;
                                    gc_frame0(gc,1,v68);
                                    wptr_t v100040 = eval(gc,v66);
                                    v73786434 = ((uint32_t)RAW_GET_UF(v100040));
                                    uint8_t v98167654 = ((uint8_t)v73786434);
                                    uint32_t v253791878 = (v105553376 * sizeof(uint8_t));
                                    uintptr_t v237992582 = ((intptr_t)((int32_t)v253791878));
                                    uintptr_t v172090970 = (v164498532 + v237992582);
                                    *((uint8_t *)(v172090970)) = v98167654;
                                    uint32_t v122154544 = (1 + v105553376);
                                    v227981062 = v68;
                                    v105553376 = v122154544;
                                    goto fW$__fForeign_C_String_22__go__29;
                                }
                            }
                        }
                        v178407644 = ((struct sCJhc_Addr_Ptr*)v60)->a1;
                        *((uintptr_t *)(v163333522)) = v178407644;
                        v174020696 = c45;
                    }
                }
            } else {
                wptr_t v100044;
                sptr_t v8;
                /* ("CPrelude.Right" ni8) */
                v8 = ((struct sCPrelude_Right*)v111)->a1;
                v100044 = fJhc_Basics_89__go(gc,v8);
                sptr_t v167886982 = demote(v100044);
                {
                    wptr_t v96;
                    uint32_t v109152422;
                    gc_frame0(gc,1,v167886982);
                    v109152422 = fW$__fJhc_List_length(gc,v167886982);
                    uint32_t v29077244 = (v109152422 * sizeof(int));
                    v96 = fW$__fForeign_Marshal_Alloc_mallocBytes(gc,v29077244);
                    sptr_t v120834806 = demote(v96);
                    {
                        wptr_t v100048;
                        wptr_t v100052;
                        sptr_t v59150084;
                        uintptr_t v15858612;
                        gc_frame0(gc,1,v96);
                        v100048 = fR$__fJhc_Basics_iterate(gc,v120834806);
                        sptr_t v1612318235 = demote(v100048);
                        v100052 = fR$__fJhc_Basics_zipWith(gc,v1612318235,v167886982);
                        sptr_t v219298162 = demote(v100052);
                        v59150084 = v219298162;
                        fR$__fJhc_Monad_87__f__30:;
                        {
                            wptr_t v100058 = eval(gc,v59150084);
                            if (SET_RAW_TAG(CJhc_Prim_$BE) == v100058) {
                                SET_RAW_TAG(CJhc_Basics_$LR);
                            } else {
                                sptr_t v197;
                                sptr_t v200;
                                /* ("CJhc.Prim.:" ni197 ni200) */
                                v197 = ((struct sCJhc_Prim_$x3a*)v100058)->a1;
                                v200 = ((struct sCJhc_Prim_$x3a*)v100058)->a2;
                                {
                                    gc_frame0(gc,1,v200);
                                    wptr_t v100060 = eval(gc,v197);
                                    bapply__7936(gc,v100060);
                                    v59150084 = v200;
                                    goto fR$__fJhc_Monad_87__f__30;
                                }
                            }
                        }
                        v15858612 = ((struct sCJhc_Addr_Ptr*)v96)->a1;
                        *((uintptr_t *)(v73700196)) = v15858612;
                        int v115160444 = ((int)((int32_t)v109152422));
                        *((int *)(v218886262)) = v115160444;
                        v174020696 = c46;
                    }
                }
            }
            wptr_t v100030 = promote(v174020696);
            v245228926 = ((struct sCCInt$h*)v100030)->a1;
            return v245228926;
        }
}

static wptr_t A_STD A_MALLOC
fFE$__CCall_engine$d2(gc_t gc,sptr_t v30)
{
        uint32_t v119285244;
        wptr_t v100016 = eval(gc,v30);
        v119285244 = ((struct sCInt$h*)v100016)->a1;
        int v135370994 = ((int)((int32_t)v119285244));
        wptr_t x7 = s_alloc(gc,cCCInt$h);
        ((struct sCCInt$h*)x7)->a1 = v135370994;
        return x7;
}

static wptr_t A_STD A_MALLOC
fFE$__CCall_engine$d3(gc_t gc,sptr_t v44725398)
{
        uintptr_t v242479196;
        wptr_t v100012 = eval(gc,v44725398);
        v242479196 = ((struct sCJhc_Addr_Ptr*)v100012)->a1;
        uintptr_t v117740408 = (v242479196 + ((intptr_t)((int32_t)sizeof(int))));
        wptr_t x11 = s_alloc(gc,cCJhc_Addr_Ptr);
        ((struct sCJhc_Addr_Ptr*)x11)->a1 = v117740408;
        return x11;
}

static sptr_t A_STD A_MALLOC
fFE$__CCall_engine$d4(gc_t gc,sptr_t v92,sptr_t v238)
{
        {
            gc_frame0(gc,1,v238);
            wptr_t v100008 = eval(gc,v92);
            {
                uintptr_t v260952206;
                int v98167652;
                gc_frame0(gc,1,v100008);
                wptr_t v100010 = eval(gc,v238);
                v260952206 = ((struct sCJhc_Addr_Ptr*)v100008)->a1;
                v98167652 = ((struct sCCInt$h*)v100010)->a1;
                *((int *)(v260952206)) = v98167652;
                return (sptr_t)SET_RAW_TAG(CJhc_Basics_$LR);
            }
        }
}

static wptr_t A_STD A_MALLOC
fFE$__CCall_engine$d5(gc_t gc,sptr_t v105553378)
{
        uint32_t v124940224;
        wptr_t v100002 = eval(gc,v105553378);
        v124940224 = ((uint32_t)RAW_GET_UF(v100002));
        wptr_t x18 = s_alloc(gc,cCInt$h);
        ((struct sCInt$h*)x18)->a1 = v124940224;
        return x18;
}

static wptr_t A_STD A_MALLOC
fFE$__CCall_engine$d6(gc_t gc,sptr_t v209623816)
{
        wptr_t v100000 = eval(gc,v209623816);
        if (SET_RAW_TAG(CJhc_Prim_$BE) == v100000) {
            return v100000;
        } else {
            sptr_t v154420600;
            sptr_t v61835124;
            /* ("CJhc.Prim.:" ni154420600 ni61835124) */
            v154420600 = ((struct sCJhc_Prim_$x3a*)v100000)->a1;
            v61835124 = ((struct sCJhc_Prim_$x3a*)v100000)->a2;
            {
                gc_frame0(gc,2,v61835124,v154420600);
                sptr_t x19 = s_alloc(gc,cFFE$__CCall_engine$d6);
                ((struct sFFE$__CCall_engine$d6*)x19)->head = TO_FPTR(&E__fFE$__CCall_engine$d6);
                ((struct sFFE$__CCall_engine$d6*)x19)->a1 = v61835124;
                sptr_t v264254032 = MKLAZY(x19);
                {
                    gc_frame0(gc,1,v264254032);
                    sptr_t x20 = s_alloc(gc,cFFE$__CCall_engine$d5);
                    ((struct sFFE$__CCall_engine$d5*)x20)->head = TO_FPTR(&E__fFE$__CCall_engine$d5);
                    ((struct sFFE$__CCall_engine$d5*)x20)->a1 = v154420600;
                    sptr_t v44725404 = MKLAZY(x20);
                    {
                        gc_frame0(gc,1,v44725404);
                        wptr_t x21 = s_alloc(gc,cCJhc_Prim_$x3a);
                        ((struct sCJhc_Prim_$x3a*)x21)->a1 = v44725404;
                        ((struct sCJhc_Prim_$x3a*)x21)->a2 = v264254032;
                        return x21;
                    }
                }
            }
        }
}

static wptr_t A_STD A_MALLOC
fJhc_Basics_89__go(gc_t gc,sptr_t v182)
{
        wptr_t v100014 = eval(gc,v182);
        if (SET_RAW_TAG(CJhc_Prim_$BE) == v100014) {
            return v100014;
        } else {
            sptr_t v189;
            sptr_t v264254028;
            /* ("CJhc.Prim.:" ni264254028 ni189) */
            v264254028 = ((struct sCJhc_Prim_$x3a*)v100014)->a1;
            v189 = ((struct sCJhc_Prim_$x3a*)v100014)->a2;
            {
                gc_frame0(gc,2,v189,v264254028);
                sptr_t x8 = s_alloc(gc,cFJhc_Basics_89__go);
                ((struct sFJhc_Basics_89__go*)x8)->head = TO_FPTR(&E__fJhc_Basics_89__go);
                ((struct sFJhc_Basics_89__go*)x8)->a1 = v189;
                sptr_t v79708486 = MKLAZY(x8);
                {
                    gc_frame0(gc,1,v79708486);
                    sptr_t x9 = s_alloc(gc,cFFE$__CCall_engine$d2);
                    ((struct sFFE$__CCall_engine$d2*)x9)->head = TO_FPTR(&E__fFE$__CCall_engine$d2);
                    ((struct sFFE$__CCall_engine$d2*)x9)->a1 = v264254028;
                    sptr_t v252304004 = MKLAZY(x9);
                    {
                        gc_frame0(gc,1,v252304004);
                        wptr_t x10 = s_alloc(gc,cCJhc_Prim_$x3a);
                        ((struct sCJhc_Prim_$x3a*)x10)->a1 = v252304004;
                        ((struct sCJhc_Prim_$x3a*)x10)->a2 = v79708486;
                        return x10;
                    }
                }
            }
        }
}

static wptr_t A_STD A_MALLOC
fR$__fJhc_Basics_$pp(gc_t gc,sptr_t v110947982,wptr_t v227981058)
{
        {
            gc_frame0(gc,1,v227981058);
            wptr_t v100018 = eval(gc,v110947982);
            if (SET_RAW_TAG(CJhc_Prim_$BE) == v100018) {
                return v227981058;
            } else {
                sptr_t v237;
                sptr_t v44;
                /* ("CJhc.Prim.:" ni44 ni237) */
                v44 = ((struct sCJhc_Prim_$x3a*)v100018)->a1;
                v237 = ((struct sCJhc_Prim_$x3a*)v100018)->a2;
                {
                    gc_frame0(gc,2,v44,v237);
                    sptr_t x3 = s_alloc(gc,cFR$__fJhc_Basics_$pp);
                    ((struct sFR$__fJhc_Basics_$pp*)x3)->head = TO_FPTR(&E__fR$__fJhc_Basics_$pp);
                    ((struct sFR$__fJhc_Basics_$pp*)x3)->a1 = v237;
                    ((struct sFR$__fJhc_Basics_$pp*)x3)->a2 = v227981058;
                    sptr_t v25922040 = MKLAZY(x3);
                    {
                        gc_frame0(gc,1,v25922040);
                        wptr_t x4 = s_alloc(gc,cCJhc_Prim_$x3a);
                        ((struct sCJhc_Prim_$x3a*)x4)->a1 = v44;
                        ((struct sCJhc_Prim_$x3a*)x4)->a2 = v25922040;
                        return x4;
                    }
                }
            }
        }
}

static wptr_t A_STD A_MALLOC
fR$__fJhc_Basics_iterate(gc_t gc,sptr_t v182639122)
{
        {
            gc_frame0(gc,1,v182639122);
            sptr_t x12 = s_alloc(gc,cFFE$__CCall_engine$d3);
            ((struct sFFE$__CCall_engine$d3*)x12)->head = TO_FPTR(&E__fFE$__CCall_engine$d3);
            ((struct sFFE$__CCall_engine$d3*)x12)->a1 = v182639122;
            sptr_t v29821312 = MKLAZY(x12);
            {
                gc_frame0(gc,1,v29821312);
                sptr_t x13 = s_alloc(gc,cFR$__fJhc_Basics_iterate);
                ((struct sFR$__fJhc_Basics_iterate*)x13)->head = TO_FPTR(&E__fR$__fJhc_Basics_iterate);
                ((struct sFR$__fJhc_Basics_iterate*)x13)->a1 = v29821312;
                sptr_t v262419594 = MKLAZY(x13);
                {
                    gc_frame0(gc,1,v262419594);
                    wptr_t x14 = s_alloc(gc,cCJhc_Prim_$x3a);
                    ((struct sCJhc_Prim_$x3a*)x14)->a1 = v182639122;
                    ((struct sCJhc_Prim_$x3a*)x14)->a2 = v262419594;
                    return x14;
                }
            }
        }
}

static wptr_t A_STD A_MALLOC
fR$__fJhc_Basics_zipWith(gc_t gc,sptr_t v68216824,sptr_t v194635132)
{
        {
            gc_frame0(gc,1,v194635132);
            wptr_t v100004 = eval(gc,v68216824);
            if (SET_RAW_TAG(CJhc_Prim_$BE) == v100004) {
                return v100004;
            } else {
                sptr_t v29375120;
                sptr_t v94;
                /* ("CJhc.Prim.:" ni29375120 ni94) */
                v29375120 = ((struct sCJhc_Prim_$x3a*)v100004)->a1;
                v94 = ((struct sCJhc_Prim_$x3a*)v100004)->a2;
                {
                    gc_frame0(gc,2,v94,v29375120);
                    wptr_t v100006 = eval(gc,v194635132);
                    if (SET_RAW_TAG(CJhc_Prim_$BE) == v100006) {
                        return v100006;
                    } else {
                        sptr_t v215884492;
                        sptr_t v98;
                        /* ("CJhc.Prim.:" ni215884492 ni98) */
                        v215884492 = ((struct sCJhc_Prim_$x3a*)v100006)->a1;
                        v98 = ((struct sCJhc_Prim_$x3a*)v100006)->a2;
                        {
                            gc_frame0(gc,2,v98,v215884492);
                            wptr_t x15 = s_alloc(gc,cP1__FE$__CCall_engine$d4);
                            SET_MEM_TAG((struct sP1__FE$__CCall_engine$d4*)x15,P1__FE$__CCall_engine$d4);
                            ((struct sP1__FE$__CCall_engine$d4*)x15)->a1 = v29375120;
                            ((struct sP1__FE$__CCall_engine$d4*)x15)->a2 = v215884492;
                            wptr_t v215 = x15;
                            sptr_t v66997298 = demote(v215);
                            {
                                gc_frame0(gc,1,v66997298);
                                sptr_t x16 = s_alloc(gc,cFR$__fJhc_Basics_zipWith);
                                ((struct sFR$__fJhc_Basics_zipWith*)x16)->head = TO_FPTR(&E__fR$__fJhc_Basics_zipWith);
                                ((struct sFR$__fJhc_Basics_zipWith*)x16)->a1 = v94;
                                ((struct sFR$__fJhc_Basics_zipWith*)x16)->a2 = v98;
                                sptr_t v185665992 = MKLAZY(x16);
                                {
                                    gc_frame0(gc,1,v185665992);
                                    wptr_t x17 = s_alloc(gc,cCJhc_Prim_$x3a);
                                    ((struct sCJhc_Prim_$x3a*)x17)->a1 = v66997298;
                                    ((struct sCJhc_Prim_$x3a*)x17)->a2 = v185665992;
                                    return x17;
                                }
                            }
                        }
                    }
                }
            }
        }
}

static wptr_t A_STD A_MALLOC
fW$__fForeign_Marshal_Alloc_mallocBytes(gc_t gc,uint32_t v1200623177)
{
        sptr_t v186;
        size_t v242159974 = ((size_t)((int32_t)v1200623177));
        uintptr_t v146 = ((uintptr_t)malloc((size_t)v242159974));
        wptr_t x5 = s_alloc(gc,cCJhc_Addr_Ptr);
        ((struct sCJhc_Addr_Ptr*)x5)->a1 = v146;
        wptr_t v194 = x5;
        sptr_t v227981060 = demote(v194);
        if (0 == v146) {
            wptr_t v100064;
            sptr_t v40405742;
            v100064 = fR$__fJhc_Basics_$pp(gc,c6,PROMOTE(c21));
            sptr_t v212800854 = demote(v100064);
            v40405742 = v212800854;
            fR$__fJhc_IO_putErrLn__6:;
            {
                wptr_t v100068 = eval(gc,v40405742);
                if (SET_RAW_TAG(CJhc_Prim_$BE) == v100068) {
                    (void)jhc_utf8_putchar((int)10);
                    SET_RAW_TAG(CJhc_Basics_$LR);
                } else {
                    sptr_t v153480248;
                    sptr_t v196335306;
                    /* ("CJhc.Prim.:" ni196335306 ni153480248) */
                    v196335306 = ((struct sCJhc_Prim_$x3a*)v100068)->a1;
                    v153480248 = ((struct sCJhc_Prim_$x3a*)v100068)->a2;
                    {
                        uint32_t v119549092;
                        gc_frame0(gc,1,v153480248);
                        wptr_t v100070 = eval(gc,v196335306);
                        v119549092 = ((uint32_t)RAW_GET_UF(v100070));
                        (void)jhc_utf8_putchar((int)v119549092);
                        v40405742 = v153480248;
                        goto fR$__fJhc_IO_putErrLn__6;
                    }
                }
            }
            jhc_exit(255);
        } else {
            v186 = v227981060;
        }
        return promote(v186);
}

static wptr_t A_STD A_MALLOC
fW$__fInstance$__iForeign_Storable_peekElemOff_default(gc_t gc,uintptr_t v1333792319,uint32_t v1337855549)
{
        uint32_t v44000678 = (v1337855549 * sizeof(uint8_t));
        uintptr_t v215884490 = ((intptr_t)((int32_t)v44000678));
        uintptr_t v242479192 = (v1333792319 + v215884490);
        uint8_t v53587372 = *((uint8_t *)(v242479192));
        return RAW_SET_UF(v53587372);
}

static uint32_t A_STD
fW$__fJhc_List_length(gc_t gc,sptr_t v871243297)
{
        sptr_t v29534748;
        uint32_t v40405744;
        v29534748 = v871243297;
        v40405744 = 0;
        fW$__fR$__fJhc_List_253__f__2:;
        {
            wptr_t v100072 = eval(gc,v29534748);
            if (SET_RAW_TAG(CJhc_Prim_$BE) == v100072) {
                return v40405744;
            } else {
                sptr_t v301;
                /* ("CJhc.Prim.:" ni0 ni301) */
                v301 = ((struct sCJhc_Prim_$x3a*)v100072)->a2;
                uint32_t v68216830 = (1 + v40405744);
                v29534748 = v301;
                v40405744 = v68216830;
                goto fW$__fR$__fJhc_List_253__f__2;
            }
        }
}

static void A_STD
ftheMain(gc_t gc)
{
        return;
}
